/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.onecode.api.dto.RelateFileDTO;
import com.geoway.onecode.api.entity.ResultsCatalogConfig;
import com.geoway.onecode.api.service.RelatedResultsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/relate"})
@Api(tags={"\u5173\u8054\u6210\u679c"})
public class RelatedResultsController {
    @Resource
    private RelatedResultsService relatedResultsService;

    @ApiOperation(value="\u83b7\u53d6\u6210\u679c\u5e94\u7528\u76ee\u5f55")
    @GetMapping(value={"/catalog"})
    public Response<String> getResultsCatalog() {
        return Response.ok((Object)this.relatedResultsService.getResultsCatalog());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6210\u679c\u5e94\u7528\u76ee\u5f55")
    @PostMapping(value={"/catalog"})
    public Response saveResultsCatalog(String catalogId) {
        this.relatedResultsService.saveResultsCatalog(catalogId);
        return Response.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u914d\u7f6e\u7684\u76ee\u5f55\u8282\u70b9")
    @GetMapping(value={"/allNodes"})
    public Response<List<ResultsCatalogConfig>> getAllConfigNodes() {
        return Response.ok(this.relatedResultsService.getAllConfigNodes());
    }

    @ApiOperation(value="\u83b7\u53d6\u6210\u679c\u76ee\u5f55\u8282\u70b9\u914d\u7f6e")
    @GetMapping(value={"/node"})
    public Response<ResultsCatalogConfig> getResultsNodeConfig(String nodeId) {
        return Response.ok((Object)this.relatedResultsService.getResultsNodeConfig(nodeId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6210\u679c\u76ee\u5f55\u8282\u70b9\u914d\u7f6e")
    @PostMapping(value={"/node"})
    public Response saveResultsNodeConfig(ResultsCatalogConfig config) {
        this.relatedResultsService.saveResultsNodeConfig(config);
        return Response.ok();
    }

    @ApiOperation(value="\u6210\u679c\u9879\u76ee\u5173\u8054\u9644\u4ef6\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u6210\u679c\u76ee\u5f55\u8282\u70b9id"), @ApiImplicitParam(name="projectName", value="\u9879\u76ee\u540d\u79f0")})
    @GetMapping(value={"/node/attachment"})
    public Response<List<RelateFileDTO>> queryCatalogNodeAttachments(@RequestParam String nodeId, @RequestParam String projectName) {
        return Response.ok(this.relatedResultsService.queryProjectAttachmentFiles(nodeId, projectName));
    }

    @ApiOperation(value="\u6210\u679c\u76ee\u5f55\u8282\u70b9\u5173\u8054\u9644\u4ef6\u9884\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u6210\u679c\u76ee\u5f55\u8282\u70b9id"), @ApiImplicitParam(name="filePath", value="\u9644\u4ef6\u8def\u5f84")})
    @GetMapping(value={"/node/attachment/preview"})
    public void previewNodeAttachment(String nodeId, String filePath, HttpServletRequest request, HttpServletResponse response) {
        this.relatedResultsService.previewNodeAttachment(nodeId, filePath, request, response);
    }

    @ApiOperation(value="\u9879\u76ee\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u8282\u70b9id"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4")})
    @GetMapping(value={"/projectData"})
    public Response<DataQueryResult> queryProjectData(@RequestParam String nodeId, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.relatedResultsService.queryProjectData(nodeId, keyword));
    }
}

