/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.plugin;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.onecode.entity.CodeRecord;
import com.geoway.dgt.onecode.service.CodeRecordService;
import com.geoway.onecode.api.plugin.Entity2BusinessRelSettingParams;
import com.geoway.onecode.api.plugin.GraphDatabaseWriter;
import com.geoway.webstore.input.constant.TaskItemTypeEnum;
import com.geoway.webstore.input.plugin.ImportPluginBase;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.data.ImportVector;
import com.geoway.webstore.input.plugin.event.ImportLogEventArgs;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class Entity2BusinessRelationshipPlugin
extends ImportPluginBase {
    protected final int maxErrorLogCount = 100;
    protected final int batchCount = 100000;
    protected GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected DictionaryService dictionaryService = (DictionaryService)SpringContextUtil.getBean(DictionaryService.class);
    protected GraphDatabaseWriter graphDatabaseWriter = (GraphDatabaseWriter)SpringContextUtil.getBean(GraphDatabaseWriter.class);
    protected CodeRecordService codeRecordService = (CodeRecordService)SpringContextUtil.getBean(CodeRecordService.class);
    private Entity2BusinessRelSettingParams settingParams = null;
    private boolean overwrite = false;

    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        super.initialize(sourceParamsStr, targetParamsStr, settingParamsStr);
        this.settingParams = (Entity2BusinessRelSettingParams)JSONObject.parseObject((String)settingParamsStr, Entity2BusinessRelSettingParams.class);
        this.overwrite = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy()) == DataDuplicateStrategyEnum.Delete;
    }

    public void scanData() {
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(this.settingParams.getDatasetId());
        DatasetNameInfo bizDatasetNameInfo = new DatasetNameInfo(this.settingParams.getBizDatasetId());
        ImportUnit importUnit = new ImportUnit();
        importUnit.setName(String.format("%s(%s)->%s(%s)", datasetNameInfo.getShortName(), this.settingParams.getDataYear(), bizDatasetNameInfo.getShortName(), this.settingParams.getBizDataYear()));
        importUnit.setCode(datasetNameInfo.getShortName());
        importUnit.setPath("");
        ImportVector importVector = new ImportVector();
        importVector.setName(datasetNameInfo.getShortName());
        importVector.setPath("");
        importVector.setDatasetName(null);
        ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, Arrays.asList(importVector));
        this.onDataUnitScaned(args);
    }

    public IImportData getImportData(Long dataId) {
        return ImportVector.getImportData((Long)dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResultDetail executeImport(IImportData importData) {
        ExecuteResultDetail executeResult = super.executeImport(importData);
        executeResult.setTotalCount(1L);
        executeResult.setSuccessCount(0L);
        executeResult.setFailCount(0L);
        this.onDataProgress(1L, 0L, 0L);
        try (Driver graphDriver = null;){
            CodeRecord dltbRecord = this.codeRecordService.getCodeRecord(this.settingParams.getDatasetId());
            if (dltbRecord == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u56fd\u571f\u8c03\u67e5\u5b9e\u4f53\u6570\u636e\u672a\u5bfc\u5165");
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            CodeRecord bizRecord = this.codeRecordService.getCodeRecord(this.settingParams.getBizDatasetId());
            if (!this.overwrite && bizRecord != null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u4e1a\u52a1\u6570\u636e\u5df2\u5b58\u5728");
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            graphDriver = this.graphDatabaseWriter.getNeo4jDriver(this.settingParams.getGraphDbKey());
            List<ChangeRow> changeRowMap = this.readChangeTable();
            if (this.overwrite) {
                this.graphDatabaseWriter.deleteNode(graphDriver, this.settingParams.getBizDatasetId());
            }
            if (!this.importEntityNode(executeResult, graphDriver)) {
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            CodeRecord codeRecord = new CodeRecord();
            codeRecord.setDatasetId(this.settingParams.getBizDatasetId());
            codeRecord.setBizClassCode(this.settingParams.getBizCode());
            codeRecord.setDataYear(this.settingParams.getBizDataYear());
            codeRecord.setPreviousDatasetId(null);
            this.codeRecordService.saveCodeRecord(codeRecord);
            if (this.importRelation(executeResult, graphDriver, changeRowMap)) {
                executeResult.setSuccessCount(1L);
                this.onDataProgress(1L, 1L, 0L);
            } else {
                executeResult.setFailCount(1L);
                this.onDataProgress(1L, 0L, 1L);
            }
        }
        return executeResult;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importEntityNode(ExecuteResultDetail executeResult, Driver graphDriver) {
        String datasetId = this.settingParams.getBizDatasetId();
        String dataYear = this.settingParams.getBizDataYear();
        String entityFieldName = this.settingParams.getBizEntityIdField();
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
        IFeatureWorkspace workspace = null;
        IFeatureCursor cursor = null;
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        try {
            this.onImportDataLog(String.format("%s(%s)\u5f00\u59cb\u5bfc\u5165", datasetNameInfo.getShortName(), dataYear));
            workspace = this.geoDatabaseService.openGeoWorkspace(datasetNameInfo.getDsKey());
            IFeatureClass dltbTable = workspace.openFeatureClass(datasetNameInfo.getName());
            if (dltbTable == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(datasetNameInfo.getShortName() + " \u6570\u636e\u6253\u5f00\u5931\u8d25");
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            if (!dltbTable.getFields().contains(entityFieldName)) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5b9e\u4f53\u6807\u8bc6\u7801\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + entityFieldName);
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            session = graphDriver.session();
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseWriter.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter csvWriter = null;
            int fileIndex = 0;
            int entityCount = 0;
            int errorLogCount = 0;
            LinkedHashMap<String, String> nodePropertys = new LinkedHashMap<String, String>();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(dltbTable.getOidFieldName());
            fields.add(entityFieldName);
            boolean hasTbmj = false;
            if (dltbTable.getFields().contains("tbbh")) {
                fields.add("tbbh");
                hasTbmj = true;
            }
            boolean hasTbbh = false;
            if (dltbTable.getFields().contains("tbmj")) {
                fields.add("tbmj");
                hasTbbh = true;
            }
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(String.join((CharSequence)",", fields));
            cursor = dltbTable.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                if (this.isStopped()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                try {
                    String nodeId = datasetId + "-" + feature.getObjectId();
                    String entityID = this.valueOf((IRow)feature, entityFieldName);
                    String tbmj = this.valueOf((IRow)feature, "tbmj");
                    String tbbh = this.valueOf((IRow)feature, "tbbh");
                    if (StringUtil.isEmpty((String)entityID)) {
                        this.onImportDataLog(feature.getObjectId() + "\u5b9e\u4f53\u6807\u8bc6\u7801\u4e3a\u7a7a", ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    nodePropertys.put("node_id", nodeId);
                    nodePropertys.put("node_class", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1");
                    nodePropertys.put("stma", entityID);
                    nodePropertys.put("node_name", this.settingParams.getBizCode());
                    nodePropertys.put("year", dataYear);
                    nodePropertys.put("ywlx", this.settingParams.getBizCode());
                    if (hasTbmj) {
                        nodePropertys.put("tbmj", tbmj == null ? "" : tbmj);
                    }
                    if (hasTbbh) {
                        nodePropertys.put("tbbh", tbbh == null ? "" : tbbh);
                    }
                    if (csvWriter == null) {
                        File csvFile = new File(csvPath, "entity" + ++fileIndex + ".csv");
                        csvFile.createNewFile();
                        csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                    }
                    this.graphDatabaseWriter.appendEntityNode(csvWriter, nodePropertys);
                    if (++entityCount == 100000) {
                        csvWriter.flush();
                        csvWriter.close();
                        csvWriter = null;
                        entityCount = 0;
                        this.graphDatabaseWriter.importEntityNode(graphDriver, "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.log.error(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", (Throwable)e);
                    this.onImportDataLog(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", ++errorLogCount);
                    ++failCount;
                }
                finally {
                    feature = cursor.nextFeature();
                }
            }
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
                csvWriter = null;
                this.graphDatabaseWriter.importEntityNode(graphDriver, "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
            }
            if (successCount > 0) {
                session.run(String.format("CREATE CONSTRAINT IF NOT EXISTS ON (n:`%s`) ASSERT n.%s IS UNIQUE", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id"));
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", datasetId, "stma"));
            }
            executeResult.setSuccess(Boolean.valueOf(failCount == 0));
            this.onImportDataLog(String.format("%s(%s)\u5bfc\u5165\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", datasetNameInfo.getShortName(), dataYear, successCount, failCount));
            boolean bl = executeResult.getSuccess();
            return bl;
        }
        catch (Exception e) {
            this.log.error(String.format("%s(%s)\u5bfc\u5165\u5931\u8d25", datasetNameInfo.getShortName(), dataYear), (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(String.format("%s(%s)\u5bfc\u5165\u5931\u8d25\uff1a%s", datasetNameInfo.getShortName(), dataYear, e.getMessage()));
            this.onImportDataLog(executeResult.getErrorMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importRelation(ExecuteResultDetail executeResult, Driver graphDriver, List<ChangeRow> changeRowMap) {
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        int errorLogCount = 0;
        try {
            this.onImportDataLog("\u4e1a\u52a1\u5173\u7cfb\u5f00\u59cb\u5199\u5165");
            String relationClass = null;
            String relationCode = this.settingParams.getBizRelationCode();
            String relationName = null;
            DmDictValueDTO relationDictValue = this.dictionaryService.getDictionaryTree("ZRZY_YYGX");
            if (relationDictValue != null) {
                block7: for (DmDictValueDTO dictValueDTO : relationDictValue.getChildren()) {
                    if ("GUOTUDIAOCHA".equalsIgnoreCase(dictValueDTO.getCode())) continue;
                    for (DmDictValueDTO dict : dictValueDTO.getChildren()) {
                        if (!dict.getCode().equalsIgnoreCase(relationCode)) continue;
                        relationClass = dictValueDTO.getCode();
                        relationName = dict.getName();
                        continue block7;
                    }
                }
            }
            if (relationClass == null) {
                relationClass = relationCode;
                relationName = relationCode;
            }
            session = graphDriver.session();
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseWriter.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter relationCsvWriter = null;
            int relationFileIndex = 0;
            int relationCount = 0;
            LinkedHashMap<String, String> relationPropertys = new LinkedHashMap<String, String>();
            for (ChangeRow changeRow : changeRowMap) {
                if (this.isStopped()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                if (relationCsvWriter == null) {
                    File csvFile = new File(csvPath, "relation" + ++relationFileIndex + ".csv");
                    csvFile.createNewFile();
                    relationCsvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                }
                try {
                    relationPropertys.put("edge_id", IdUtil.getSnowflakeNextIdStr());
                    relationPropertys.put("edge_name", relationName);
                    relationPropertys.put("edge_class", relationClass);
                    relationPropertys.put("yygx", relationCode);
                    relationPropertys.put("mj", changeRow.mj);
                    this.graphDatabaseWriter.appendEntityRelation(relationCsvWriter, changeRow.entityId, changeRow.bizEntityId, relationPropertys);
                    if (++relationCount >= 100000) {
                        relationCsvWriter.flush();
                        relationCsvWriter.close();
                        relationCsvWriter = null;
                        relationCount = 0;
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.log.error(changeRow.entityId + "\u5904\u7406\u5931\u8d25", (Throwable)e);
                    this.onImportDataLog(changeRow.entityId + "\u5904\u7406\u5931\u8d25", ++errorLogCount);
                    ++failCount;
                }
            }
            if (relationCsvWriter != null) {
                relationCsvWriter.flush();
                relationCsvWriter.close();
                relationCsvWriter = null;
                relationCount = 0;
            }
            for (int index = 1; index <= relationFileIndex; ++index) {
                this.graphDatabaseWriter.importEntityRelation(graphDriver, relationClass, this.settingParams.getDatasetId(), this.settingParams.getBizDatasetId(), relationPropertys.keySet(), guid, "relation" + index);
            }
            boolean success = failCount == 0;
            executeResult.setSuccess(Boolean.valueOf(success));
            this.onImportDataLog(String.format("\u4e1a\u52a1\u5173\u7cfb\u5199\u5165\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", successCount, failCount));
        }
        catch (Exception e) {
            this.log.error("\u4e1a\u52a1\u5173\u7cfb\u5199\u5165\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage("\u4e1a\u52a1\u5173\u7cfb\u5199\u5165\u5931\u8d25\uff1a" + e.getMessage());
            this.onImportDataLog(executeResult.getErrorMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return executeResult.getSuccess();
    }

    private List<ChangeRow> readChangeTable() {
        IFeatureWorkspace workspace = null;
        ICursor cursor = null;
        try {
            Path tablePath = UploadPathConfig.getFullPath((String)this.settingParams.getRelationshipTable());
            String excelFile = tablePath.getParent().toString();
            String sheetName = tablePath.getFileName().toString();
            workspace = WorkspaceUtil.openLocalFileGeodatabase((String)excelFile);
            ITable table = workspace.openTable(sheetName);
            if (table == null) {
                throw new RuntimeException("\u6253\u5f00\u65f6\u5e8f\u5173\u7cfb\u8868\u5931\u8d25\uff01");
            }
            ArrayList<ChangeRow> changeRowMap = new ArrayList<ChangeRow>();
            cursor = table.searchRow(null);
            IRow row = cursor.nextRow();
            while (row != null) {
                String bizEntityId;
                String entityid = this.valueOf(row, this.settingParams.getRelationDltbEntityIdField());
                if (StringUtil.isEmpty((String)entityid) || StringUtil.isEmpty((String)(bizEntityId = this.valueOf(row, this.settingParams.getRelationBizEntityIdField())))) continue;
                String relation = this.valueOf(row, "match_type");
                String mj = this.valueOf(row, this.settingParams.getRelationAreaField());
                ChangeRow changeRow = new ChangeRow();
                changeRow.entityId = entityid;
                changeRow.bizEntityId = bizEntityId;
                changeRow.relation = relation;
                changeRow.mj = mj;
                changeRowMap.add(changeRow);
                row = cursor.nextRow();
            }
            ArrayList<ChangeRow> arrayList = changeRowMap;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(this.settingParams.getRelationshipTable() + " \u65f6\u5e8f\u5173\u7cfb\u8868\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
    }

    protected void onImportDataLog(String logMsg, int errorLogCount) {
        if (this.currentImportData != null) {
            if (errorLogCount <= this.maxErrorLogCount) {
                ImportLogEventArgs args = new ImportLogEventArgs((Object)this, logMsg, TaskItemTypeEnum.TaskData, this.currentImportData.getId());
                this.onImportLog(args);
            } else {
                this.log.error(logMsg);
            }
        } else {
            this.log.error(logMsg);
        }
    }

    private String valueOf(IRow row, String fld) {
        Object value = row.getValue(fld);
        return value == null ? null : value.toString();
    }

    static class ChangeRow {
        public String entityId;
        public String relation;
        public String bizEntityId;
        public String mj;

        ChangeRow() {
        }
    }
}

