/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.plugin;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.onecode.entity.CodeRecord;
import com.geoway.dgt.onecode.service.CodeEntityClassService;
import com.geoway.dgt.onecode.service.CodeRecordService;
import com.geoway.onecode.api.plugin.EntityTimingRelSettingParams;
import com.geoway.onecode.api.plugin.GraphDatabaseWriter;
import com.geoway.webstore.input.constant.TaskItemTypeEnum;
import com.geoway.webstore.input.plugin.ImportPluginBase;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.data.ImportVector;
import com.geoway.webstore.input.plugin.event.ImportLogEventArgs;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class EntityTimingRelationshipPlugin
extends ImportPluginBase {
    protected final int maxErrorLogCount = 100;
    protected final int batchCount = 100000;
    protected GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected DictionaryService dictionaryService = (DictionaryService)SpringContextUtil.getBean(DictionaryService.class);
    protected GraphDatabaseWriter graphDatabaseWriter = (GraphDatabaseWriter)SpringContextUtil.getBean(GraphDatabaseWriter.class);
    protected CodeEntityClassService codeEntityClassService = (CodeEntityClassService)SpringContextUtil.getBean(CodeEntityClassService.class);
    protected CodeRecordService codeRecordService = (CodeRecordService)SpringContextUtil.getBean(CodeRecordService.class);
    private EntityTimingRelSettingParams settingParams = null;
    private boolean overwrite = false;

    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        super.initialize(sourceParamsStr, targetParamsStr, settingParamsStr);
        this.settingParams = (EntityTimingRelSettingParams)JSONObject.parseObject((String)settingParamsStr, EntityTimingRelSettingParams.class);
        this.overwrite = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy()) == DataDuplicateStrategyEnum.Delete;
    }

    public void scanData() {
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(this.settingParams.getDatasetId());
        DatasetNameInfo predatasetNameInfo = new DatasetNameInfo(this.settingParams.getPreviousDatasetId());
        ImportUnit importUnit = new ImportUnit();
        importUnit.setName(String.format("%s(%s)->%s(%s)", predatasetNameInfo.getShortName(), this.settingParams.getPreviousDataYear(), datasetNameInfo.getShortName(), this.settingParams.getDataYear()));
        importUnit.setCode(datasetNameInfo.getShortName());
        importUnit.setPath("");
        ImportVector importVector = new ImportVector();
        importVector.setName(datasetNameInfo.getShortName());
        importVector.setPath("");
        importVector.setDatasetName(null);
        ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, Arrays.asList(importVector));
        this.onDataUnitScaned(args);
    }

    public IImportData getImportData(Long dataId) {
        return ImportVector.getImportData((Long)dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResultDetail executeImport(IImportData importData) {
        ExecuteResultDetail executeResult = super.executeImport(importData);
        executeResult.setTotalCount(1L);
        executeResult.setSuccessCount(0L);
        executeResult.setFailCount(0L);
        this.onDataProgress(1L, 0L, 0L);
        try (Driver graphDriver = null;){
            CodeRecord codeRecord2;
            CodeRecord currentRecord = this.codeRecordService.getCodeRecord(this.settingParams.getDatasetId());
            if (!this.overwrite && currentRecord != null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5f53\u671f\u6570\u636e\u5df2\u5b58\u5728");
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            Map classNameMap = this.codeEntityClassService.getClassNames();
            if (classNameMap.size() == 0) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u672a\u914d\u7f6e\u5b9e\u4f53\u5206\u7c7b");
                this.onImportDataLog("\u672a\u914d\u7f6e\u5b9e\u4f53\u5206\u7c7b");
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            graphDriver = this.graphDatabaseWriter.getNeo4jDriver(this.settingParams.getGraphDbKey());
            this.graphDatabaseWriter.addGraphIndex(graphDriver);
            Map<String, ChangeRow> changeRowMap = this.readChangeTable();
            CodeRecord previousRecord = this.codeRecordService.getCodeRecord(this.settingParams.getPreviousDatasetId());
            if (previousRecord == null || this.overwrite && StringUtil.isEmpty((String)previousRecord.getPreviousDatasetId())) {
                if (this.overwrite) {
                    this.graphDatabaseWriter.deleteNode(graphDriver, this.settingParams.getPreviousDatasetId());
                }
                if (this.importEntityNode(executeResult, graphDriver, classNameMap, false, changeRowMap)) {
                    codeRecord2 = new CodeRecord();
                    codeRecord2.setDatasetId(this.settingParams.getPreviousDatasetId());
                    codeRecord2.setBizClassCode(this.settingParams.getBizCode());
                    codeRecord2.setDataYear(this.settingParams.getPreviousDataYear());
                    codeRecord2.setPreviousDatasetId(null);
                    this.codeRecordService.saveCodeRecord(codeRecord2);
                } else {
                    ExecuteResultDetail codeRecord2 = executeResult;
                    return codeRecord2;
                }
            }
            if (this.overwrite) {
                this.graphDatabaseWriter.deleteNode(graphDriver, this.settingParams.getDatasetId());
            }
            if (!this.importEntityNode(executeResult, graphDriver, classNameMap, true, changeRowMap)) {
                ExecuteResultDetail executeResultDetail = executeResult;
                return executeResultDetail;
            }
            codeRecord2 = new CodeRecord();
            codeRecord2.setDatasetId(this.settingParams.getDatasetId());
            codeRecord2.setBizClassCode(this.settingParams.getBizCode());
            codeRecord2.setDataYear(this.settingParams.getDataYear());
            codeRecord2.setPreviousDatasetId(this.settingParams.getPreviousDatasetId());
            this.codeRecordService.saveCodeRecord(codeRecord2);
            if (this.importRelation(executeResult, graphDriver, changeRowMap)) {
                executeResult.setSuccessCount(1L);
                this.onDataProgress(1L, 1L, 0L);
            } else {
                executeResult.setFailCount(1L);
                this.onDataProgress(1L, 0L, 1L);
            }
        }
        return executeResult;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importEntityNode(ExecuteResultDetail executeResult, Driver graphDriver, Map<String, String> classNameMap, boolean isCurrentDataset, Map<String, ChangeRow> changeRowMap) {
        String dlmcFieldName;
        String entityFieldName;
        String dataYear;
        String datasetId;
        if (isCurrentDataset) {
            datasetId = this.settingParams.getDatasetId();
            dataYear = this.settingParams.getDataYear();
            entityFieldName = this.settingParams.getEntityIdField();
            dlmcFieldName = this.settingParams.getDlmcField();
        } else {
            datasetId = this.settingParams.getPreviousDatasetId();
            dataYear = this.settingParams.getPreviousDataYear();
            entityFieldName = this.settingParams.getPreviousEntityIdField();
            dlmcFieldName = this.settingParams.getPreviousDlmcField();
        }
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
        IFeatureWorkspace workspace = null;
        IFeatureCursor cursor = null;
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        try {
            this.onImportDataLog(String.format("%s(%s)\u5f00\u59cb\u5bfc\u5165", datasetNameInfo.getShortName(), dataYear));
            workspace = this.geoDatabaseService.openGeoWorkspace(datasetNameInfo.getDsKey());
            IFeatureClass dltbTable = workspace.openFeatureClass(datasetNameInfo.getName());
            if (dltbTable == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(datasetNameInfo.getShortName() + " \u6570\u636e\u6253\u5f00\u5931\u8d25");
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            IField dlmcField = dltbTable.getFields().findField(dlmcFieldName);
            if (dlmcField == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5730\u7c7b\u540d\u79f0\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + dlmcFieldName);
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            if (!dltbTable.getFields().contains(entityFieldName)) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5b9e\u4f53\u6807\u8bc6\u7801\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + entityFieldName);
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            session = graphDriver.session();
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseWriter.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter csvWriter = null;
            int fileIndex = 0;
            int entityCount = 0;
            int errorLogCount = 0;
            LinkedHashMap<String, String> nodePropertys = new LinkedHashMap<String, String>();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(dltbTable.getOidFieldName());
            fields.add(entityFieldName);
            fields.add(dlmcFieldName);
            fields.add("bsm");
            if (dltbTable.getFields().contains("tbmj")) {
                fields.add("tbmj");
            }
            if (dltbTable.getFields().contains("dlbm")) {
                fields.add("dlbm");
            }
            if (dltbTable.getFields().contains("tbbh")) {
                fields.add("tbbh");
            }
            String zldwdmField = "zldwdm";
            if (dltbTable.getFields().contains(zldwdmField)) {
                fields.add(zldwdmField);
            }
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(String.join((CharSequence)",", fields));
            cursor = dltbTable.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                if (this.isStopped()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                try {
                    String nodeId = datasetId + "-" + feature.getObjectId();
                    String dlmc = this.valueOf((IRow)feature, dlmcFieldName);
                    String dlbm = this.valueOf((IRow)feature, "dlbm");
                    String bsm = this.valueOf((IRow)feature, "bsm");
                    String tbmj = this.valueOf((IRow)feature, "tbmj");
                    String tbbh = this.valueOf((IRow)feature, "tbbh");
                    String entityID = this.valueOf((IRow)feature, entityFieldName);
                    String xzqdm = null;
                    String zldwdm = this.valueOf((IRow)feature, zldwdmField);
                    if (StringUtil.isNotEmpty((String)zldwdm) && zldwdm.length() >= 6) {
                        xzqdm = zldwdm.substring(0, 6);
                    }
                    if (StringUtil.isEmpty((String)dlmc)) {
                        this.onImportDataLog(feature.getObjectId() + "\u5730\u7c7b\u540d\u79f0\u4e3a\u7a7a", ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    if (StringUtil.isEmpty((String)entityID)) {
                        this.onImportDataLog(feature.getObjectId() + "\u5b9e\u4f53\u6807\u8bc6\u7801\u4e3a\u7a7a", ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    String entityClass = classNameMap.get(dlmc);
                    if (StringUtil.isEmpty((String)entityClass)) {
                        this.onImportDataLog(feature.getObjectId() + "-" + dlmc + " \u672a\u5339\u914d\u5230\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801", ++errorLogCount);
                        ++failCount;
                        continue;
                    }
                    String codeType = "01";
                    if (isCurrentDataset) {
                        if (!changeRowMap.containsKey(entityID)) {
                            codeType = "02";
                        } else if ("\u5c5e\u6027\u6f14\u53d8".equals(changeRowMap.get((Object)entityID).relation)) {
                            codeType = "02";
                        }
                    }
                    nodePropertys.put("node_id", nodeId);
                    nodePropertys.put("node_class", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53");
                    nodePropertys.put("node_name", dlmc);
                    nodePropertys.put("stma", entityID);
                    nodePropertys.put("stfl", entityClass);
                    nodePropertys.put("year", dataYear);
                    nodePropertys.put("xzqdm", xzqdm);
                    nodePropertys.put("ywlx", this.settingParams.getBizCode());
                    nodePropertys.put("bsm", bsm);
                    nodePropertys.put("dlbm", dlbm);
                    nodePropertys.put("tbmj", tbmj);
                    nodePropertys.put("tbbh", tbbh);
                    nodePropertys.put("code_type", codeType);
                    if (csvWriter == null) {
                        File csvFile = new File(csvPath, "entity" + ++fileIndex + ".csv");
                        csvFile.createNewFile();
                        csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                    }
                    this.graphDatabaseWriter.appendEntityNode(csvWriter, nodePropertys);
                    if (++entityCount == 100000) {
                        csvWriter.flush();
                        csvWriter.close();
                        csvWriter = null;
                        entityCount = 0;
                        this.graphDatabaseWriter.importEntityNode(graphDriver, "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    this.log.error(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", (Throwable)e);
                    this.onImportDataLog(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", ++errorLogCount);
                    ++failCount;
                }
                finally {
                    feature = cursor.nextFeature();
                }
            }
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
                csvWriter = null;
                this.graphDatabaseWriter.importEntityNode(graphDriver, "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", datasetId, nodePropertys.keySet(), guid, "entity" + fileIndex);
            }
            if (successCount > 0) {
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", datasetId, "stma"));
            }
            executeResult.setSuccess(Boolean.valueOf(failCount == 0));
            this.onImportDataLog(String.format("%s(%s)\u5bfc\u5165\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", datasetNameInfo.getShortName(), dataYear, successCount, failCount));
            boolean bl = executeResult.getSuccess();
            return bl;
        }
        catch (Exception e) {
            this.log.error(String.format("%s(%s)\u5bfc\u5165\u5931\u8d25", datasetNameInfo.getShortName(), dataYear), (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(String.format("%s(%s)\u5bfc\u5165\u5931\u8d25\uff1a%s", datasetNameInfo.getShortName(), dataYear, e.getMessage()));
            this.onImportDataLog(executeResult.getErrorMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importRelation(ExecuteResultDetail executeResult, Driver graphDriver, Map<String, ChangeRow> changeRowMap) {
        IFeatureWorkspace workspace = null;
        IFeatureCursor cursor = null;
        Session session = null;
        int successCount = 0;
        int failCount = 0;
        int errorLogCount = 0;
        try {
            this.onImportDataLog("\u65f6\u5e8f\u5173\u7cfb\u5f00\u59cb\u5199\u5165");
            DatasetNameInfo datasetNameInfo = new DatasetNameInfo(this.settingParams.getDatasetId());
            workspace = this.geoDatabaseService.openGeoWorkspace(datasetNameInfo.getDsKey());
            IFeatureClass dltbTable = workspace.openFeatureClass(datasetNameInfo.getName());
            if (dltbTable == null) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage(datasetNameInfo.getShortName() + " \u6570\u636e\u6253\u5f00\u5931\u8d25");
                this.onImportDataLog(executeResult.getErrorMessage());
                boolean bl = false;
                return bl;
            }
            DmDictValueDTO relationDictValue = this.dictionaryService.getDictionaryTree("ZRZY_YYGX");
            HashMap<String, String> relationNameMap = new HashMap<String, String>();
            if (relationDictValue != null) {
                for (DmDictValueDTO dictValueDTO : relationDictValue.getChildren()) {
                    if (!"GUOTUDIAOCHA".equalsIgnoreCase(dictValueDTO.getCode())) continue;
                    for (DmDictValueDTO dict : dictValueDTO.getChildren()) {
                        relationNameMap.put(dict.getName(), dict.getCode());
                    }
                }
            }
            session = graphDriver.session();
            String guid = UUID.randomUUID().toString();
            String csvPath = this.graphDatabaseWriter.getTempPath(guid);
            FileUtil.mkdirs((String)csvPath);
            BufferedWriter relationCsvWriter = null;
            int relationFileIndex = 0;
            int relationCount = 0;
            LinkedHashMap<String, String> relationPropertys = new LinkedHashMap<String, String>();
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(this.settingParams.getEntityIdField());
            cursor = dltbTable.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                if (this.isStopped()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                String entityID = this.valueOf((IRow)feature, this.settingParams.getEntityIdField());
                if (StringUtil.isEmpty((String)entityID)) {
                    feature = cursor.nextFeature();
                    continue;
                }
                if (relationCsvWriter == null) {
                    File csvFile = new File(csvPath, "relation" + ++relationFileIndex + ".csv");
                    csvFile.createNewFile();
                    relationCsvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), StandardCharsets.UTF_8), 1024);
                }
                try {
                    ChangeRow changeRow = changeRowMap.get(entityID);
                    if (changeRow == null) {
                        relationPropertys.put("edge_id", IdUtil.getSnowflakeNextIdStr());
                        relationPropertys.put("edge_class", "GUOTUDIAOCHA");
                        relationPropertys.put("edge_name", "\u672a\u6f14\u53d8");
                        relationPropertys.put("yygx", "WEIYANBIAN");
                        this.graphDatabaseWriter.appendEntityRelation(relationCsvWriter, entityID, entityID, relationPropertys);
                        ++relationCount;
                        ++successCount;
                    } else {
                        String[] previousEntityIds;
                        String pentityId = changeRow.pentityId;
                        for (String previousEntityId : previousEntityIds = pentityId.split(",")) {
                            relationPropertys.put("edge_id", IdUtil.getSnowflakeNextIdStr());
                            relationPropertys.put("edge_class", "GUOTUDIAOCHA");
                            relationPropertys.put("edge_name", changeRow.relation);
                            relationPropertys.put("yygx", relationNameMap.get(changeRow.relation) == null ? changeRow.relation : (String)relationNameMap.get(changeRow.relation));
                            this.graphDatabaseWriter.appendEntityRelation(relationCsvWriter, previousEntityId, entityID, relationPropertys);
                            ++relationCount;
                            ++successCount;
                        }
                    }
                    if (relationCount < 100000) continue;
                    relationCsvWriter.flush();
                    relationCsvWriter.close();
                    relationCsvWriter = null;
                    relationCount = 0;
                }
                catch (Exception e) {
                    this.log.error(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", (Throwable)e);
                    this.onImportDataLog(feature.getObjectId() + "\u5904\u7406\u5931\u8d25", ++errorLogCount);
                    ++failCount;
                }
                finally {
                    feature = cursor.nextFeature();
                }
            }
            if (relationCsvWriter != null) {
                relationCsvWriter.flush();
                relationCsvWriter.close();
                relationCsvWriter = null;
                relationCount = 0;
            }
            for (int index = 1; index <= relationFileIndex; ++index) {
                this.graphDatabaseWriter.importEntityRelation(graphDriver, "GUOTUDIAOCHA", this.settingParams.getPreviousDatasetId(), this.settingParams.getDatasetId(), relationPropertys.keySet(), guid, "relation" + index);
            }
            boolean success = failCount == 0;
            executeResult.setSuccess(Boolean.valueOf(success));
            this.onImportDataLog(String.format("\u65f6\u5e8f\u5173\u7cfb\u5199\u5165\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", successCount, failCount));
        }
        catch (Exception e) {
            this.log.error("\u65f6\u5e8f\u5173\u7cfb\u5199\u5165\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage("\u65f6\u5e8f\u5173\u7cfb\u5199\u5165\u5931\u8d25\uff1a" + e.getMessage());
            this.onImportDataLog(executeResult.getErrorMessage());
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
            if (session != null) {
                session.close();
            }
        }
        return executeResult.getSuccess();
    }

    private Map<String, ChangeRow> readChangeTable() {
        try {
            List result = ExcelUtil.readExcelDataList((String)UploadPathConfig.getFileFullPath((String)this.settingParams.getRelationshipTable()));
            if (result.size() <= 1) {
                throw new RuntimeException("\u6253\u5f00\u4e1a\u52a1\u5173\u7cfb\u8868\u5931\u8d25\uff01");
            }
            HashMap<String, ChangeRow> changeRowMap = new HashMap<String, ChangeRow>();
            for (int i = 1; i < result.size(); ++i) {
                String year;
                String pentityid;
                List row = (List)result.get(i);
                String entityid = (String)row.get(0);
                if (StringUtil.isEmpty((String)entityid) || StringUtil.isEmpty((String)(pentityid = (String)row.get(4))) || StringUtil.isEmpty((String)(year = (String)row.get(1))) || !year.equals(this.settingParams.getDataYear())) continue;
                ChangeRow changeRow = new ChangeRow();
                changeRow.entityId = entityid;
                changeRow.pentityId = pentityid;
                changeRow.relation = (String)row.get(2);
                changeRowMap.put(entityid, changeRow);
            }
            return changeRowMap;
        }
        catch (Exception e) {
            throw new RuntimeException(this.settingParams.getRelationshipTable() + " \u65f6\u5e8f\u5173\u7cfb\u8868\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    private void onImportDataLog(String logMsg, int errorLogCount) {
        if (this.currentImportData != null) {
            if (errorLogCount <= this.maxErrorLogCount) {
                ImportLogEventArgs args = new ImportLogEventArgs((Object)this, logMsg, TaskItemTypeEnum.TaskData, this.currentImportData.getId());
                this.onImportLog(args);
            } else {
                this.log.error(logMsg);
            }
        } else {
            this.log.error(logMsg);
        }
    }

    private String valueOf(IRow row, String fld) {
        Object value = row.getValue(fld);
        return value == null ? null : value.toString();
    }

    static class ChangeRow {
        public String entityId;
        public String relation;
        public String pentityId;

        ChangeRow() {
        }
    }
}

