/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support.resolver;

import com.geoway.base.support.listener.FileUploadProgressListener;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class CommonsMultipartResolverExt
extends CommonsMultipartResolver {
    private HttpServletRequest request;
    protected List<String> excludePaths = new ArrayList<String>();

    public void setExcludePaths(List<String> excludePaths) {
        this.excludePaths = excludePaths;
    }

    public boolean isMultipart(HttpServletRequest request) {
        String uri = request.getRequestURI();
        for (String excludePath : this.excludePaths) {
            if (uri.indexOf(excludePath) <= 0) continue;
            return false;
        }
        return super.isMultipart(request);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        ServletFileUpload upload = new ServletFileUpload(fileItemFactory);
        upload.setSizeMax(-1L);
        if (this.request != null) {
            HttpSession session = this.request.getSession();
            String workId = this.request.getParameter("workId") == null ? "upload-progress" : this.request.getParameter("workId").toString();
            FileUploadProgressListener uploadProgressListener = new FileUploadProgressListener(session, workId);
            upload.setProgressListener((ProgressListener)uploadProgressListener);
        }
        return upload;
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        this.request = request;
        return super.resolveMultipart(request);
    }

    public CommonsFileUploadSupport.MultipartParsingResult parseRequest(HttpServletRequest request) throws MultipartException {
        HttpSession session = request.getSession();
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        String workId = request.getParameter("workId") == null ? "upload-progress" : request.getParameter("workId").toString();
        FileUploadProgressListener progressListener = new FileUploadProgressListener(session, workId);
        fileUpload.setProgressListener((ProgressListener)progressListener);
        try {
            List fileItems = ((ServletFileUpload)fileUpload).parseRequest(request);
            return this.parseFileItems(fileItems, encoding);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)ex);
        }
    }
}

