/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 8366942161007559486L;
    private static final int BUFFER_SIZE = 8192;
    private static Logger _log = Logger.getLogger(ProxyServlet.class);
    private Proxy proxy = null;

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String urlString = request.getQueryString();
        urlString = URLDecoder.decode(urlString, "UTF-8");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("proxy handler get request query full url : " + urlString));
        }
        if (urlString.startsWith("url=")) {
            urlString = urlString.substring(4);
        }
        if (urlString.indexOf("requestTime") != -1) {
            urlString = urlString.split("requestTime")[0];
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("proxy handler get request query url : " + urlString));
        }
        urlString = urlString.indexOf("?") != -1 ? urlString + "&charset=utf-8" : urlString + "?charset=utf-8";
        HttpURLConnection conn = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            URL httpURL = new URL(urlString);
            if (httpURL.getProtocol().equalsIgnoreCase("HTTP") || httpURL.getProtocol().equalsIgnoreCase("HTTPS")) {
                conn = this.proxy != null ? (HttpURLConnection)httpURL.openConnection(this.proxy) : (HttpURLConnection)httpURL.openConnection();
                conn.setRequestMethod("GET");
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setConnectTimeout(9000);
                if (urlString.toLowerCase().contains("callbackformat=json")) {
                    response.setContentType("text/json; charset=UTF-8");
                } else {
                    response.setContentType("text/xml; charset=UTF-8");
                }
                in = new BufferedInputStream(conn.getInputStream());
                BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String tempLine = rd.readLine();
                StringBuffer scenarioSb = new StringBuffer();
                while (tempLine != null) {
                    tempLine = tempLine.replace("xmlns=", " xmlns:new=");
                    tempLine = tempLine.replace("xmlns:", " xmlns:");
                    tempLine = tempLine.replace("xsi:", " xsi:");
                    scenarioSb.append(tempLine);
                    tempLine = rd.readLine();
                }
                out = response.getOutputStream();
                String result = scenarioSb.toString();
                out.write(result.getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            response.setStatus(500, e.getLocalizedMessage());
            _log.error((Object)("\u8bbf\u95ee\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e));
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Document inputDocument = null;
        try {
            SAXReader builder = new SAXReader();
            inputDocument = builder.read((Reader)new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("proxy handler post request input document : " + inputDocument.asXML()));
            }
        }
        catch (IOException e) {
            response.setStatus(500, e.getLocalizedMessage());
            _log.error((Object)e);
        }
        catch (DocumentException e) {
            response.setStatus(500, e.getLocalizedMessage());
            _log.error((Object)e);
        }
        String urlString = new String(request.getQueryString().getBytes("ISO-8859-1"), "GBK");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("proxy handler post request query full url : " + urlString));
        }
        if (urlString.startsWith("url=")) {
            urlString = urlString.substring(4);
        }
        if (urlString.indexOf("requestTime") != -1) {
            urlString = urlString.split("requestTime")[0];
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("proxy handler post request query url : " + urlString));
        }
        HttpURLConnection conn = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            URL httpURL = new URL(urlString);
            if (httpURL.getProtocol().equalsIgnoreCase("HTTP") || httpURL.getProtocol().equalsIgnoreCase("HTTPS")) {
                conn = this.proxy != null ? (HttpURLConnection)httpURL.openConnection(this.proxy) : (HttpURLConnection)httpURL.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/xml");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                OutputStream output = conn.getOutputStream();
                OutputFormat format = OutputFormat.createCompactFormat();
                format.setEncoding("UTF-8");
                XMLWriter writer = new XMLWriter(output, format);
                writer.write(inputDocument);
                output.flush();
                output.close();
                output = null;
                in = conn.getInputStream();
                response.setContentType("text/xml; charset=UTF-8");
                out = response.getOutputStream();
                byte[] buffer = new byte[8192];
                int num = in.read(buffer, 0, 8192);
                while (num != -1) {
                    if (_log.isDebugEnabled()) {
                        // empty if block
                    }
                    out.write(buffer, 0, num);
                    num = in.read(buffer, 0, 8192);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            response.setStatus(500, e.getLocalizedMessage());
            _log.error((Object)e);
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }
}

