/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support;

import cn.hutool.core.util.StrUtil;
import com.geoway.base.support.QueryParamRes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class QueryParamManageUtil {
    public static final String complexFindKey = "#";
    private static final String[] keys = new String[]{"select ", "update ", "delete ", "insert ", "drop ", "truncate ", "(select", "(update", "(delete", "(insert", "(drop", "(truncate"};

    public static QueryParamRes parseQueryFilterParams(String filterParam) {
        QueryParamRes queryParamRes = new QueryParamRes();
        if (StringUtils.isEmpty((CharSequence)filterParam)) {
            return queryParamRes;
        }
        if (!QueryParamManageUtil.isComplex(filterParam)) {
            String[] split = filterParam.split(";");
            String where = "  1=1 ";
            ArrayList<Object> objs = new ArrayList<Object>();
            for (String s : split) {
                if (StrUtil.isBlank((CharSequence)s)) continue;
                QueryParamRes res = QueryParamManageUtil.parseMatchParam(s);
                where = where + res.getWhere();
                objs.addAll(res.getValue());
            }
            queryParamRes.setWhere(where);
            queryParamRes.setValues(objs.toArray());
            return queryParamRes;
        }
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(filterParam);
        String finalRes = filterParam;
        int index = 1;
        HashMap<String, String> matchMap = new HashMap<String, String>();
        while (matcher.find()) {
            String group = matcher.group();
            String findKey = complexFindKey + index;
            finalRes = matcher.replaceFirst(findKey);
            matcher.reset(finalRes);
            String innalParam = group.substring(1, group.length() - 1);
            matchMap.put(findKey, innalParam);
            ++index;
        }
        String newFilterParam = finalRes;
        String[] split = newFilterParam.split(";");
        String where = "  1=1 ";
        ArrayList<Object> objs = new ArrayList<Object>();
        QueryParamRes res = null;
        for (int i = 0; i < split.length; ++i) {
            String matchParam = split[i];
            if (StrUtil.isBlank((CharSequence)matchParam)) continue;
            if (matchParam.contains(complexFindKey)) {
                res = QueryParamManageUtil.parseComplexMatchParam(matchParam, matchMap);
                where = where + res.getWhere();
            } else {
                res = QueryParamManageUtil.parseMatchParam(matchParam);
                where = where + res.getWhere();
            }
            objs.addAll(res.getValue());
        }
        queryParamRes.setWhere(where);
        queryParamRes.setValues(objs.toArray());
        return queryParamRes;
    }

    public static String parseSortParams(String sortParam) {
        if (StringUtils.isBlank((CharSequence)sortParam)) {
            return "";
        }
        StringBuilder sbr = new StringBuilder(" order by ");
        String[] paramPairs = sortParam.split(";");
        for (int i = 0; i < paramPairs.length; ++i) {
            String parseParam = paramPairs[i];
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(parseParam.split("_")));
            int index = list.size();
            if (!list.get(0).startsWith("SORT")) continue;
            String type = list.get(index - 1);
            list.remove(index - 1);
            list.remove(0);
            String field = String.join((CharSequence)"_", list);
            QueryParamManageUtil.check(field);
            sbr.append(field + " " + ("ASC".equalsIgnoreCase(type) ? "ASC" : "DESC") + ",");
        }
        sbr.deleteCharAt(sbr.length() - 1);
        return sbr.toString();
    }

    private static QueryParamRes parseMatchParam(String param) {
        QueryParamRes paramRes = new QueryParamRes();
        String[] split = param.split("=");
        if (split.length != 2) {
            throw new RuntimeException("\u53c2\u6570\u63cf\u8ff0\u5f02\u5e38\uff01");
        }
        String exp = split[0];
        String val = split[1];
        ArrayList<String> exps = new ArrayList<String>(Arrays.asList(exp.split("_")));
        int size = exps.size();
        String connect = "";
        if ("Q".equals(exps.get(0)) || "QA".equals(exps.get(0))) {
            connect = " and ";
        } else if ("QOR".equals(exps.get(0))) {
            connect = " or ";
        }
        String fieldType = (String)exps.get(size - 2);
        String condition = (String)exps.get(size - 1);
        exps.remove(size - 1);
        exps.remove(size - 2);
        exps.remove(0);
        String field = String.join((CharSequence)"_", exps);
        QueryParamManageUtil.check(field);
        String where = connect + " " + field + " " + QueryParamManageUtil.getCondition(condition, val);
        List<Object> vals = QueryParamManageUtil.getVal(val, fieldType, condition);
        paramRes.setWhere(where);
        paramRes.setValue(vals);
        return paramRes;
    }

    private static QueryParamRes parseComplexMatchParam(String param, Map<String, String> cacheMap) {
        if (!cacheMap.containsKey(param)) {
            return null;
        }
        String filterParam = cacheMap.get(param);
        String[] paramPairs = filterParam.split(";");
        QueryParamRes queryParamRes = null;
        String where = "";
        ArrayList<Object> objs = new ArrayList<Object>();
        for (int i = 0; i < paramPairs.length; ++i) {
            String subMatchParam = paramPairs[i];
            if (StrUtil.isBlank((CharSequence)subMatchParam)) continue;
            queryParamRes = subMatchParam.contains(complexFindKey) ? QueryParamManageUtil.parseComplexMatchParam(subMatchParam, cacheMap) : QueryParamManageUtil.parseMatchParam(subMatchParam);
            where = where + queryParamRes.getWhere();
            objs.addAll(queryParamRes.getValue());
        }
        where = where.startsWith(" and") ? where.replaceFirst("and", "and (") : where.replaceFirst("or", "or (");
        queryParamRes.setWhere(where + ")");
        queryParamRes.setValue(objs);
        return queryParamRes;
    }

    private static List<Object> getVal(String val, String fieldType, String condition) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object obj = QueryParamManageUtil.compareCondition(condition, val);
        if (fieldType.equals("S")) {
            if ("LK".equals(condition)) {
                obj = "%" + val + "%";
            } else if ("LFK".equals(condition)) {
                obj = val + "%";
            } else if ("RHK".equals(condition)) {
                obj = "%" + val;
            }
        }
        if ((obj = QueryParamManageUtil.typeConversion(obj != null ? obj : val, fieldType)) instanceof List) {
            list.addAll((List)obj);
        } else {
            list.add(obj);
        }
        return list;
    }

    private static Object typeConversion(Object obj, String fieldType) {
        List objs = obj;
        if (obj instanceof List) {
            if (fieldType.equals("D")) {
                objs = ((List)obj).stream().map(m -> QueryParamManageUtil.getDate(m.toString(), "yyyy-MM-dd")).collect(Collectors.toList());
            } else if (fieldType.equals("DT")) {
                objs = ((List)obj).stream().map(m -> QueryParamManageUtil.getDate(m.toString(), "yyyy-MM-dd HH:mm:ss")).collect(Collectors.toList());
            } else if (fieldType.equals("N")) {
                objs = obj.stream().map(m -> Double.valueOf(m.toString())).collect(Collectors.toList());
            }
        } else if (fieldType.equals("D")) {
            objs = QueryParamManageUtil.getDate(obj.toString(), "yyyy-MM-dd");
        } else if (fieldType.equals("DT")) {
            objs = QueryParamManageUtil.getDate(obj.toString(), "yyyy-MM-dd HH:mm:ss");
        } else if (fieldType.equals("N")) {
            objs = Double.valueOf(obj.toString());
        }
        return objs;
    }

    private static Object compareCondition(String condition, String val) {
        List<String> obj = null;
        switch (condition) {
            case "IN": 
            case "NOTIN": 
            case "BTW": {
                List<String> asList;
                obj = asList = Arrays.asList(val.split(","));
                break;
            }
        }
        return obj;
    }

    private static boolean isComplex(String matchParam) {
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(matchParam);
        return matcher.find();
    }

    private static String getCondition(String condition, String val) {
        String res = "";
        switch (condition = condition.toUpperCase()) {
            case "EQ": {
                res = " = ? ";
                break;
            }
            case "NE": {
                res = " != ? ";
                break;
            }
            case "LK": 
            case "LFK": 
            case "RHK": {
                res = " like ? ";
                break;
            }
            case "LT": {
                res = " < ? ";
                break;
            }
            case "GT": {
                res = " > ? ";
                break;
            }
            case "LE": {
                res = " <= ? ";
                break;
            }
            case "GE": {
                res = " >= ? ";
                break;
            }
            case "IN": {
                String inIndex = QueryParamManageUtil.getIndex(val.split(",").length);
                res = " in (" + inIndex + ") ";
                break;
            }
            case "NOTIN": {
                String notinIndex = QueryParamManageUtil.getIndex(val.split(",").length);
                res = " not in (" + notinIndex + ") ";
                break;
            }
            case "BTW": {
                res = " between ? and ? ";
                break;
            }
            default: {
                throw new RuntimeException("\u5f53\u524d\u4e0d\u652f\u6301\u3010" + condition + "\u3011");
            }
        }
        return res;
    }

    private static String getIndex(int index) {
        String res = "?";
        while (index > 1) {
            res = res + ",?";
            --index;
        }
        return res;
    }

    private static Date getDate(String val, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date parse = null;
        try {
            parse = sdf.parse(val);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return parse;
    }

    private static void check(String field) {
        if (field.contains(" ")) {
            throw new RuntimeException("\u5b57\u6bb5\u4e2d\u4e0d\u5141\u8bb8\u51fa\u73b0\u7a7a\u5b57\u7b26\uff01");
        }
        String f = field.toLowerCase();
        for (String key : keys) {
            if (!f.contains(key)) continue;
            throw new RuntimeException("\u5b57\u6bb5\u4e2d\u4e0d\u5141\u8bb8\u51fa\u73b0\u5173\u952e\u5b57,\u8bf7\u68c0\u67e5\u3010" + field + "\u3011\uff01");
        }
    }
}

