/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger logger = Logger.getLogger(PropertyUtil.class);
    private static final Map<String, Properties> cacheProps = new Hashtable<String, Properties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProps(String propName) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = PropertyUtil.class.getClassLoader().getResourceAsStream(propName + ".properties");
            props.load(in);
            cacheProps.put("appSetting", props);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"properties\u6587\u4ef6\u672a\u627e\u5230");
        }
        catch (IOException e) {
            logger.error((Object)"\u51fa\u73b0IOException");
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"jdbc.properties\u6587\u4ef6\u6d41\u5173\u95ed\u51fa\u73b0\u5f02\u5e38");
            }
        }
        logger.info((Object)"\u52a0\u8f7dproperties\u6587\u4ef6\u5185\u5bb9\u5b8c\u6210...........");
        logger.info((Object)("properties\u6587\u4ef6\u5185\u5bb9\uff1a" + props));
    }

    public static String getProperty(String key) {
        Properties props = cacheProps.get("appSetting");
        if (null == props) {
            PropertyUtil.loadProps("appSetting");
            props = cacheProps.get("appSetting");
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        Properties props = cacheProps.get("appSetting");
        if (null == props) {
            PropertyUtil.loadProps("appSetting");
            props = cacheProps.get("appSetting");
        }
        return props.getProperty(key, defaultValue);
    }

    public static String getProperty(String propName, String key, String defaultValue) {
        Properties props = cacheProps.get(propName);
        if (null == props) {
            PropertyUtil.loadProps(propName);
            props = cacheProps.get(propName);
        }
        return props.getProperty(key, defaultValue);
    }

    static {
        PropertyUtil.loadProps("appSetting");
    }
}

