/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DataBaseTimeService {
    @Autowired
    JdbcTemplate jdbcTemplate;
    String myDbType = "";

    public Date getCurrentTime() {
        Date resultDate = null;
        try {
            SqlRowSet rowSet;
            String sql = "select now()";
            String dbType = this.queryDbType();
            if ("postgresql".equalsIgnoreCase(dbType) || "mysql".equalsIgnoreCase(dbType)) {
                sql = "select now()";
                SqlRowSet rowSet2 = this.jdbcTemplate.queryForRowSet(sql);
                if (rowSet2.next()) {
                    Timestamp timestamp = rowSet2.getTimestamp(1);
                    resultDate = new Date(timestamp.getTime());
                }
            } else if ("oracle".equalsIgnoreCase(dbType) && (rowSet = this.jdbcTemplate.queryForRowSet(sql = "select sysdate from dual")).next()) {
                Timestamp timestamp = rowSet.getTimestamp(1);
                resultDate = new Date(timestamp.getTime());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (resultDate == null) {
            resultDate = new Date();
        }
        return resultDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryDbType() {
        String dbType = "postgresql";
        if (StringUtils.isNotBlank((String)this.myDbType)) {
            dbType = this.myDbType;
            return dbType;
        }
        Connection myConn = null;
        try {
            myConn = this.jdbcTemplate.getDataSource().getConnection();
            this.myDbType = dbType = myConn.getMetaData().getDatabaseProductName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (myConn != null) {
                try {
                    myConn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return dbType;
    }
}

