/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import oracle.jdbc.OracleConnection;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;

public class OracleConnectionFinder
implements ConnectionFinder {
    public static Connection getRawConnection(Connection con) {
        return con;
    }

    public OracleConnection find(Connection con) {
        if (con instanceof OracleConnection) {
            return (OracleConnection)con;
        }
        if (con instanceof DruidPooledConnection) {
            DruidPooledConnection drConn = (DruidPooledConnection)con;
            Connection unwrappedCon = null;
            try {
                unwrappedCon = (Connection)drConn.unwrap(OracleConnection.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (unwrappedCon != null && unwrappedCon instanceof OracleConnection) {
                return (OracleConnection)unwrappedCon;
            }
        } else if (con instanceof C3P0ProxyConnection) {
            C3P0ProxyConnection cpCon = (C3P0ProxyConnection)con;
            Connection unwrappedCon = null;
            try {
                Method rawConnectionMethod = this.getClass().getMethod("getRawConnection", Connection.class);
                unwrappedCon = (Connection)cpCon.rawConnectionOperation(rawConnectionMethod, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (unwrappedCon != null && unwrappedCon instanceof OracleConnection) {
                return (OracleConnection)unwrappedCon;
            }
        }
        return null;
    }
}

