/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.metadata.service.ModelFieldsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/modelFields"})
public class ModelFieldsAction {
    @Autowired
    private ModelFieldsService modelFieldsService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page<ModelFields> pages = this.modelFieldsService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveModelFields.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveModelFields(@ModelAttribute ModelFields modelFields) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelFields modelFieldsDb = this.modelFieldsService.saveModelFields(modelFields);
            response.setData((Object)modelFieldsDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delModelFieldsById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse delModelFieldsById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.modelFieldsService.delModelFields(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getModelFieldsById"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getModelFieldsById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelFields modelFields = this.modelFieldsService.findById(id);
            response.setData((Object)modelFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

