/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.service;

import com.geoway.base.metadata.dao.IModelGroupDao;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.metadata.domain.ModelGroup;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelGroupService {
    @Autowired
    private IModelGroupDao iModelGroupDao;

    @Transactional(rollbackFor={Exception.class})
    public ModelGroup saveModelGroup(ModelGroup modelGroup) {
        return (ModelGroup)this.iModelGroupDao.save(modelGroup);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delModelGroup(Long ... id) {
        if (id.length > 1) {
            for (Long tmp : id) {
                this.iModelGroupDao.deleteById(tmp);
            }
        } else {
            this.iModelGroupDao.deleteById(id[0]);
        }
    }

    public ModelGroup findById(Long id) {
        return this.iModelGroupDao.findModelGroupById(id);
    }

    public Page<ModelGroup> findPages(String filterParam, String sortParam, int page, int size) {
        Page results = this.iModelGroupDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List<ModelFields> findModelFields(String tableName, String groupCode) {
        List<ModelGroup> groups = this.iModelGroupDao.findByTableNameAndGroupCodeOrderByFieldOrder(tableName, groupCode);
        return groups.stream().map(group -> {
            ModelFields modelFields = group.getModelFields();
            modelFields.setIsListShow(group.getVisible());
            return modelFields;
        }).collect(Collectors.toList());
    }
}

