/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.domain.ModelObjectinfo;
import com.geoway.base.metadata.service.ModelObjectinfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/modelObjectinfo"})
public class ModelObjectinfoAction {
    @Autowired
    private ModelObjectinfoService modelObjectinfoService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page<ModelObjectinfo> pages = this.modelObjectinfoService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveModelObjectinfo.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveModelObjectinfo(@ModelAttribute ModelObjectinfo modelObjectinfo) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelObjectinfo modelObjectinfoDb = this.modelObjectinfoService.saveModelObjectinfo(modelObjectinfo);
            response.setData((Object)modelObjectinfoDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delModelObjectinfoById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse delModelObjectinfoById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.modelObjectinfoService.delModelObjectinfo(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getModelObjectinfoById"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getModelObjectinfoById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelObjectinfo modelObjectinfo = this.modelObjectinfoService.findById(id);
            response.setData((Object)modelObjectinfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

