/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.service;

import com.geoway.base.metadata.dao.IModelFieldsDao;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelFieldsService {
    @Autowired
    private IModelFieldsDao iModelFieldsDao;

    @Transactional(rollbackFor={Exception.class})
    public ModelFields saveModelFields(ModelFields modelFields) {
        return (ModelFields)this.iModelFieldsDao.save(modelFields);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delModelFields(Long ... id) {
        if (id.length > 1) {
            for (Long tmp : id) {
                this.iModelFieldsDao.deleteById(tmp);
            }
        } else {
            this.iModelFieldsDao.deleteById(id[0]);
        }
    }

    public ModelFields findById(Long id) {
        return this.iModelFieldsDao.findModelFieldsById(id);
    }

    public Page<ModelFields> findPages(String filterParam, String sortParam, int page, int size) {
        Page results = this.iModelFieldsDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List<ModelFields> findByTableId(Long tableId) {
        return this.iModelFieldsDao.findByTableIdOrderByOrder(tableId);
    }

    public List<ModelFields> findByTableName(String tableName) {
        return this.iModelFieldsDao.findByTableNameOrderByOrder(tableName);
    }

    public List<ModelFields> findByIds(List<String> ids) {
        return this.iModelFieldsDao.findByIdInOrderByOrder(ids);
    }

    public ModelFields findByTableNamePrimary(String tableName) {
        return this.iModelFieldsDao.findByTableNamePrimary(tableName);
    }

    public ModelFields findByTableNameGeometry(String tableName) {
        return this.iModelFieldsDao.findByTableNameGeometry(tableName);
    }

    public List<String> findFieldNameByTableName(String tableName) {
        return this.iModelFieldsDao.findFieldByTableName(tableName);
    }
}

