/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.domain.ModelConfig;
import com.geoway.base.metadata.service.ModelConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/modelConfig"})
public class ModelConfigAction {
    @Autowired
    private ModelConfigService modelConfigService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page<ModelConfig> pages = this.modelConfigService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveModelConfig.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveModelConfig(@ModelAttribute ModelConfig modelConfig) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelConfig modelConfigDb = this.modelConfigService.saveModelConfig(modelConfig);
            response.setData((Object)modelConfigDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delModelConfigById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse delModelConfigById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.modelConfigService.delModelConfig(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getModelConfigById"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getModelConfigById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelConfig modelConfig = this.modelConfigService.findById(id);
            response.setData((Object)modelConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

