/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.base.metadata.constant.FieldTypeEnum;
import com.geoway.base.metadata.dao.IModelMapFieldDao;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.metadata.domain.ModelObjectinfo;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelGroupService;
import com.geoway.base.metadata.service.ModelObjectinfoService;
import com.geoway.base.metadata.vo.Gather;
import com.geoway.base.metadata.vo.ModelCheckResult;
import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ModelManageService {
    public static Logger logger = LoggerFactory.getLogger(ModelGroupService.class);
    private static final String PARAM_WHERE = "{where}";
    private static final String PARAM_SORT = "{order by}";
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ModelFieldsService modelFieldsService;
    @Autowired
    ModelGroupService modelGroupService;
    @Autowired
    ModelObjectinfoService modelObjectinfoService;
    @Autowired
    IModelMapFieldDao iModelMapFieldDao;

    public Object saveModel(Map<String, Object> map, String tableName, String userId, boolean check) throws Exception {
        return this.saveModel(map, tableName, null, userId, check);
    }

    public Object saveModel(Map<String, Object> map, String tableName, List<ModelFields> list, String userId, boolean check) throws Exception {
        ModelCheckResult checkResult;
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(tableName);
        sql.append(" (");
        if (list == null || list.size() == 0) {
            list = this.modelFieldsService.findByTableName(tableName);
        }
        if (check && !(checkResult = this.checkValid(tableName, map, list)).isValid()) {
            throw new RuntimeException(checkResult.getMsg());
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> vals = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Object id = null;
        Object obj = null;
        for (ModelFields f : list) {
            if (map.containsKey(f.getFieldName())) {
                names.add(f.getFieldName());
                if (FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.GEOMETRY)) {
                    vals.add("st_GeomFromText(?,4490)");
                } else {
                    vals.add("?");
                }
                obj = this.fieldTypeChange(f, map.get(f.getFieldName()));
                values.add(obj);
            } else if (StringUtils.isNotBlank((CharSequence)f.getDefaultValue()) && 1 == f.getIsMust()) {
                names.add(f.getFieldName());
                vals.add("?");
                obj = this.getFieldsDefaultValue(f, userId);
                values.add(obj);
            }
            if (1 != f.getIsPrimary()) continue;
            id = obj;
        }
        sql.append(StringUtils.join(names, (String)","));
        sql.append(") values (");
        sql.append(StringUtils.join(vals, (String)","));
        sql.append(")");
        this.jdbcTemplate.update(sql.toString(), values.toArray());
        logger.info("insert data:" + sql.toString() + " data[]:" + values.toArray());
        return id;
    }

    public ModelCheckResult checkValid(String tableName, Map<String, Object> map, List<ModelFields> list) {
        ModelCheckResult checkResult = new ModelCheckResult();
        checkResult.setValid(true);
        checkResult.setData(map);
        String checkMsg = "";
        ModelFields uniqueField = this.getUniqueField(list);
        for (ModelFields field : list) {
            String sql1;
            Integer count;
            if (field.getIsMust() != null && 1 == field.getIsMust() && !map.containsKey(field.getFieldName())) {
                checkResult.setValid(false);
                checkMsg = checkMsg + String.format("\u5165\u5e93\u8bb0\u5f55\u3010%s:%s\u3011,\u7f3a\u5c11\u5fc5\u5907\u5b57\u6bb5\u3010%s\u3011\r\n", uniqueField.getFieldName(), map.get(uniqueField.getFieldName()), field.getFieldName());
                checkResult.setMsg(checkMsg);
                return checkResult;
            }
            if ((field.getIsPrimary() != null && 1 == field.getIsPrimary() || field.getNullable() != null && 0 == field.getNullable() || field.getUnique() != null && 1 == field.getUnique()) && ObjectUtil.isEmpty((Object)map.get(field.getFieldName()))) {
                checkResult.setValid(false);
                checkMsg = checkMsg + String.format("\u5165\u5e93\u8bb0\u5f55\u3010%s:%s\u3011,\u5fc5\u586b\u5b57\u6bb5\u3010%s\u3011\u4e3a\u7a7a\r\n", uniqueField.getFieldName(), map.get(uniqueField.getFieldName()), field.getFieldName());
                checkResult.setMsg(checkMsg);
                return checkResult;
            }
            if (field.getUnique() == null || 1 != field.getUnique() || (count = (Integer)this.jdbcTemplate.queryForObject(sql1 = String.format("select count(1) from %s  where  %s=?", tableName, field.getFieldName()), new Object[]{map.get(field.getFieldName())}, Integer.class)) <= 0) continue;
            checkResult.setValid(false);
            checkMsg = checkMsg + String.format("\u5165\u5e93\u8bb0\u5f55\u3010%s:%s\u3011,\u5b57\u6bb5\u3010%s\u3011\u8fdd\u53cd\u4e86\u552f\u4e00\u6027\u8981\u6c42\uff1a%s", uniqueField.getFieldName(), map.get(uniqueField.getFieldName()), field.getFieldName(), map.get(field.getFieldName()));
            checkResult.setMsg(checkMsg);
            return checkResult;
        }
        checkResult.setMsg(checkMsg);
        return checkResult;
    }

    private ModelFields getUniqueField(List<ModelFields> list) {
        ModelFields modelFields = list.stream().filter(f -> f.getUnique() != null && 1 == f.getUnique()).findFirst().orElse(null);
        if (modelFields == null) {
            return list.get(0);
        }
        return modelFields;
    }

    public void updateZBKState(Long id) {
        String sql = "UPDATE tb_project_gdbh_cbbcgd_zbk SET f_ishistory=1 WHERE f_sid = " + id;
        this.jdbcTemplate.update(sql);
    }

    public int update(Map<String, Object> map, String tableName, String whereClause, Object[] v) throws Exception {
        StringBuilder sqlbf = new StringBuilder("UPDATE ");
        sqlbf.append(tableName);
        sqlbf.append(" SET ");
        List<ModelFields> list = this.modelFieldsService.findByTableName(tableName);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ModelFields f : list) {
            if (!map.containsKey(f.getFieldName())) continue;
            if (FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.GEOMETRY)) {
                names.add(f.getFieldName() + "=st_GeomFromText(?,4490)");
            }
            if (FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.DATE) || FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.TIMESTAMP)) {
                names.add(f.getFieldName() + "=to_timestamp(?,'yyyy-MM-dd hh24:mi:ss')");
            } else {
                names.add(f.getFieldName() + "=?");
            }
            values.add(this.fieldTypeChange(f, map.get(f.getFieldName())));
        }
        sqlbf.append(StringUtils.join(names, (String)", "));
        sqlbf.append(" WHERE ");
        sqlbf.append(whereClause);
        values.addAll(Arrays.stream(v).collect(Collectors.toList()));
        logger.info("update data:" + sqlbf.toString() + " data[]:" + values.toArray());
        return this.jdbcTemplate.update(sqlbf.toString(), values.toArray());
    }

    public Object updateModel(Map<String, Object> map, List<ModelFields> list, String tableName) throws Exception {
        StringBuilder sqlbf = new StringBuilder("UPDATE ");
        sqlbf.append(tableName);
        sqlbf.append(" SET ");
        if (list == null || list.size() == 0) {
            list = this.modelFieldsService.findByTableName(tableName);
        }
        String key = "";
        String value = "";
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ModelFields f : list) {
            if (!map.containsKey(f.getFieldName())) continue;
            if (1 == f.getIsPrimary()) {
                key = f.getFieldName();
                if (map.get(f.getFieldName()) == null) continue;
                value = map.get(f.getFieldName()).toString();
                continue;
            }
            if (FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.GEOMETRY)) {
                names.add(f.getFieldName() + "=st_GeomFromText(?,4490)");
            }
            if (FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.DATE) || FieldTypeEnum.valueOf(f.getFieldType().toUpperCase()).equals((Object)FieldTypeEnum.TIMESTAMP)) {
                names.add(f.getFieldName() + "=to_timestamp(?,'yyyy-MM-dd hh24:mi:ss')");
            } else {
                names.add(f.getFieldName() + "=?");
            }
            values.add(this.fieldTypeChange(f, map.get(f.getFieldName())));
        }
        sqlbf.append(StringUtils.join(names, (String)", "));
        sqlbf.append(" WHERE ");
        sqlbf.append(key);
        sqlbf.append("='").append(value).append("'");
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            throw new Exception("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.jdbcTemplate.update(sqlbf.toString(), values.toArray());
        logger.info("update data:" + sqlbf.toString() + " data[]:" + values.toArray());
        return value;
    }

    public Object updateModel(Map<String, Object> map, String tableName) throws Exception {
        return this.updateModel(map, null, tableName);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchCheckJHKProject(List<String> ids, Integer state, String remark, String userName) {
        StringBuilder sql = new StringBuilder("update tb_project_gdbh_cbbcgd_jhk set ");
        sql.append("f_check_state=").append(state).append(",");
        sql.append("f_check_user_name='").append(userName).append("',");
        sql.append("f_check_remark='").append(remark).append("',");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sql.append("f_check_time='").append(df.format(new Date())).append("'");
        sql.append(" where f_id in ('").append(StringUtils.join(ids, (String)",")).append("')");
        this.jdbcTemplate.update(sql.toString());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProcessId(String tableName, String id, String processId, Integer checkState, Integer state) {
        try {
            List<String> fields = this.modelFieldsService.findFieldNameByTableName(tableName);
            if (fields != null) {
                String sql;
                if (fields.contains("f_process_id")) {
                    StringBuilder sqlbf = new StringBuilder("UPDATE ");
                    sqlbf.append(tableName);
                    sqlbf.append(" SET f_process_id=? WHERE f_id=?");
                    int count = this.jdbcTemplate.update(sqlbf.toString(), (Object[])new String[]{processId, id});
                    System.out.println(count);
                }
                if (fields.contains("f_check_state") && checkState != null) {
                    sql = "update " + tableName + " set f_check_state=" + checkState + "  where f_id=?";
                    this.jdbcTemplate.update(sql, (Object[])new String[]{id});
                }
                if (fields.contains("f_state") && state != null) {
                    sql = "update " + tableName + " set f_state=" + state + "  where f_id=?";
                    this.jdbcTemplate.update(sql, (Object[])new String[]{id});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object fieldTypeChange(ModelFields field, Object object) throws Exception {
        Object obj;
        block13: {
            block12: {
                obj = null;
                if (object == null || !StringUtils.isNotBlank((CharSequence)object.toString())) break block12;
                switch (FieldTypeEnum.valueOf(field.getFieldType().toUpperCase())) {
                    case VARCHAR: {
                        obj = object.toString();
                        break block13;
                    }
                    case TEXT: {
                        obj = object.toString();
                        break block13;
                    }
                    case INT2: {
                        obj = this.toInt(object);
                        break block13;
                    }
                    case INT4: {
                        obj = this.toInt(object);
                        break block13;
                    }
                    case INT8: {
                        obj = Long.parseLong(object.toString());
                        break block13;
                    }
                    case NUMERIC: {
                        obj = Double.parseDouble(object.toString());
                        break block13;
                    }
                    case TIMESTAMP: {
                        obj = this.obj2Date(object);
                        break block13;
                    }
                    case DATE: {
                        obj = this.obj2Date(object);
                        break block13;
                    }
                    case GEOMETRY: {
                        obj = object.toString();
                        break block13;
                    }
                    default: {
                        throw new Exception("\u6ca1\u6709\u8be5\u7c7b\u578b\uff1a" + field.getFieldType());
                    }
                }
            }
            if (1 == field.getIsPrimary()) {
                obj = UUID.randomUUID();
            }
        }
        return obj;
    }

    private Date obj2Date(Object obj) throws ParseException {
        Date date = null;
        try {
            if (obj instanceof Long || ModelManageService.isNumeric(obj.toString())) {
                date = new Date(Long.parseLong(obj.toString()));
            } else if (obj.toString().contains("-")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String foo = obj.toString();
                if (foo.contains("T")) {
                    sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                }
                date = sdf.parse(foo);
            } else if (obj.toString().contains("/")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                String foo = obj.toString();
                if (foo.contains("T")) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss.SSSZ");
                }
                date = sdf.parse(foo);
            } else {
                date = new Date(obj.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public Object getFieldsDefaultValue(ModelFields field, String userId) throws Exception {
        Object obj = null;
        switch (FieldTypeEnum.valueOf(field.getFieldType().toUpperCase())) {
            case VARCHAR: {
                if ("currentUser".equals(field.getDefaultValue())) {
                    obj = userId;
                    break;
                }
                if ("uuid".equals(field.getDefaultValue())) {
                    obj = UUID.randomUUID();
                    break;
                }
                obj = field.getDefaultValue();
                break;
            }
            case INT2: {
                if (field.getDefaultValue() == null) break;
                obj = Integer.parseInt(field.getDefaultValue());
                break;
            }
            case INT4: {
                if (field.getDefaultValue() == null) break;
                obj = Integer.parseInt(field.getDefaultValue());
                break;
            }
            case NUMERIC: {
                if (field.getDefaultValue() == null) break;
                obj = Double.parseDouble(field.getDefaultValue());
                break;
            }
            case TIMESTAMP: {
                if (!"currentTime".equals(field.getDefaultValue())) break;
                obj = new Date();
                break;
            }
            case DATE: {
                if (!"currentTime".equals(field.getDefaultValue())) break;
                obj = new Date();
                break;
            }
            default: {
                throw new Exception("\u6ca1\u6709\u8be5\u7c7b\u578b\uff1a" + field.getFieldType());
            }
        }
        return obj;
    }

    public Page<Map<String, Object>> findPageList(String tableName, String groupCode, String where, Object[] values, String sort, int size, int page) {
        Long number = this.countAll(tableName, where, values);
        List<Map<String, Object>> list = this.findListPage(tableName, groupCode, where, values, sort, size, page);
        PageImpl pager = new PageImpl(list, (Pageable)PageRequest.of((int)(page - 1), (int)size), number.longValue());
        return pager;
    }

    public Page<Map<String, Object>> findPageList(String tableName, String groupCode, String where, String sort, int size, int page) {
        return this.findPageList(tableName, groupCode, where, new Object[0], sort, size, page);
    }

    public Long countAll(String tableName, String where, Object[] values) {
        ModelObjectinfo objectinfo;
        String sql = " select count(*) from " + tableName + " where 1=1 ";
        if (StringUtils.isNotEmpty((CharSequence)where) && !(where = where.trim()).startsWith("and") && !where.startsWith("AND")) {
            where = " and " + where;
        }
        if ((objectinfo = this.modelObjectinfoService.findByTableName(tableName)) == null || StrUtil.isBlank((CharSequence)objectinfo.getViewSql())) {
            sql = sql + where;
        } else {
            String viewSql = objectinfo.getViewSql();
            viewSql = viewSql.replace(PARAM_WHERE, " where 1=1 " + where);
            viewSql = viewSql.replace(PARAM_SORT, "");
            String subQuery = String.format(" with %s as (%s) ", tableName, viewSql);
            sql = subQuery + sql;
        }
        return (Long)this.jdbcTemplate.queryForObject(sql, values, Long.class);
    }

    public Long countModelFeildsAll(String tableName) {
        String sql = " select count(*) from tb_model_fields  where f_tablename='" + tableName + "'";
        logger.info("countModelFeildsAll,sql:" + sql);
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        logger.info("countModelFeildsAll,count:" + count);
        return count;
    }

    public List<Map<String, Object>> findListPage(String tableName, List<ModelFields> fields, String where, Object[] values, String sort) {
        String sql = this.getQueryFields(tableName, fields);
        if (StringUtils.isNotEmpty((CharSequence)where) && !(where = where.trim()).startsWith("and") && !where.startsWith("AND")) {
            where = " and " + where;
        }
        List objList = this.jdbcTemplate.queryForList(sql + where + sort, values);
        logger.info("query list:" + sql + where + sort);
        return objList;
    }

    public List<Map<String, Object>> findListPage(String tableName, String groupCode, String where, Object[] values, String sort) {
        return this.findListPage(tableName, groupCode, where, values, sort, -1, -1);
    }

    public List<Map<String, Object>> findListPage(String tableName, String groupCode, String where, Object[] values, String sort, int size, int page) {
        List<ModelFields> list = StringUtils.isNotBlank((CharSequence)groupCode) ? this.modelGroupService.findModelFields(tableName, groupCode) : this.modelFieldsService.findByTableName(tableName);
        return this.findListPage(tableName, list, where, values, sort, size, page);
    }

    public List<Map<String, Object>> findListPage(String tableName, List<ModelFields> modelFields, String where, Object[] values, String sort, int size, int page) {
        if (StringUtils.isNotEmpty((CharSequence)where) && !(where = where.trim()).startsWith("and") && !where.startsWith("AND")) {
            where = " and " + where;
        }
        String sql = this.getQueryFields(tableName, modelFields);
        ModelObjectinfo objectinfo = this.modelObjectinfoService.findByTableName(tableName);
        if (objectinfo == null || StrUtil.isBlank((CharSequence)objectinfo.getViewSql())) {
            sql = sql + where + sort;
        } else {
            String viewSql = objectinfo.getViewSql();
            viewSql = viewSql.replace(PARAM_WHERE, " where 1=1 " + where);
            viewSql = viewSql.replace(PARAM_SORT, sort);
            String subQuery = String.format(" with %s as (%s) ", tableName, viewSql);
            sql = subQuery + sql;
        }
        List objList = null;
        if (size > 0 && page > -1) {
            objList = this.jdbcTemplate.queryForList(sql + " LIMIT " + size + " OFFSET " + (page - 1) * size, values);
            logger.info("query list:" + sql + " LIMIT " + size + " OFFSET " + (page - 1) * size);
        } else {
            objList = this.jdbcTemplate.queryForList(sql, values);
            logger.info("query list:" + sql);
        }
        return objList;
    }

    public List<Map<String, Object>> findListPage(String tableName, String groupCode, String where, String sort, int size, int page) {
        return this.findListPage(tableName, groupCode, where, new Object[0], sort, size, page);
    }

    public List<Map<String, Object>> findListPage(String tableName, String groupCode, int size, int page) {
        return this.findListPage(tableName, groupCode, "", new Object[0], "", size, page);
    }

    public List<Map<String, Object>> findListPage2(String tableName, String groupCode, String where, int size, int page) {
        return this.findListPage(tableName, groupCode, where, new Object[0], "", size, page);
    }

    public List<Map<String, Object>> findFieldList(String tableName, String where, String ... fields) {
        String sql = this.getQueryAllFields(tableName, fields);
        List list = this.jdbcTemplate.queryForList(sql + where);
        return list;
    }

    public List<Map<String, Object>> findList(String sql, Object[] args) {
        return this.jdbcTemplate.queryForList(sql, args);
    }

    public List<Map<String, Object>> findList(String tableName, String groupCode, String where) {
        return this.findListPage(tableName, groupCode, where, new Object[0], "", -1, -1);
    }

    public Map<String, Object> findOne(String tableName, String groupCode, String where, Object[] values) {
        List<Map<String, Object>> list = this.findListPage(tableName, groupCode, where, values, "", -1, -1);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u4e00\u4e2a\uff01");
        }
        return list.get(0);
    }

    public Map<String, Object> findOne(String tableName, String where, Object[] values) {
        return this.findOne(tableName, "", where, values);
    }

    public Map<String, Object> findOne(String tableName, String where) {
        return this.findOne(tableName, where, new Object[0]);
    }

    public <T> List<T> findList(String tableName, String groupCode, String where, Class<T> clazz) {
        List<Map<String, Object>> list = this.findListPage(tableName, groupCode, where, "", -1, -1);
        return list.stream().map(m -> {
            Map<String, Object> map = ModelManageService.removePrefix(m, "f_");
            return BeanUtil.mapToBean(map, (Class)clazz, (boolean)true);
        }).collect(Collectors.toList());
    }

    public Map<String, Object> findObject(String tableName, String id, String groupCode) {
        ModelFields mf = this.modelFieldsService.findByTableNamePrimary(tableName);
        String where = mf.getFieldName() + "=?";
        return this.findOne(tableName, groupCode, where, new Object[]{id});
    }

    public String calcObjExtent(String tableName, String where) {
        ModelFields modelFields = this.modelFieldsService.findByTableNameGeometry(tableName);
        if (modelFields != null) {
            String fieldCode = modelFields.getFieldName();
            String sql = "SELECT ST_Extent(" + fieldCode + ")  FROM " + tableName + " where 1=1 ";
            if (!Strings.isNullOrEmpty((String)where)) {
                sql = sql + "  and  " + where;
            }
            String boxWkt = (String)this.jdbcTemplate.queryForObject(sql, String.class);
            return boxWkt;
        }
        return null;
    }

    public AbstractMap.SimpleEntry<String[], String[]> getFieldsTitle(String tableName, String groupCode) {
        String[] templateNameArray;
        String[] templateTitleArray;
        StringBuilder sb = new StringBuilder("select ");
        ArrayList fields = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)groupCode)) {
            List<ModelFields> list = this.modelGroupService.findModelFields(tableName, groupCode);
            templateTitleArray = new String[list.size()];
            templateNameArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                templateTitleArray[i] = list.get(i).getFieldName();
                templateNameArray[i] = list.get(i).getAlias();
            }
        } else {
            List<ModelFields> list = this.modelFieldsService.findByTableName(tableName);
            templateTitleArray = new String[list.size()];
            templateNameArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                templateTitleArray[i] = list.get(i).getFieldName();
                templateNameArray[i] = list.get(i).getAlias();
            }
        }
        return new AbstractMap.SimpleEntry<String[], String[]>(templateTitleArray, templateNameArray);
    }

    private String getQueryAllFields(String tableName, String ... fields) {
        StringBuilder sb = new StringBuilder("select ");
        sb.append(StringUtils.join((Object[])fields, (String)","));
        sb.append(" from ");
        sb.append(tableName);
        sb.append(" where 1=1 ");
        return sb.toString();
    }

    private String getQueryFields(String tableName, List<ModelFields> list) {
        StringBuilder sb = new StringBuilder("select ");
        ArrayList<String> fields = new ArrayList<String>();
        if (list != null) {
            for (ModelFields mf : list) {
                fields.add(this.getFieldSql(mf.getFieldName(), mf.getFieldType()));
            }
        }
        if (fields.size() > 0) {
            sb.append(StringUtils.join(fields, (String)","));
        } else {
            sb.append("*");
        }
        sb.append(" from ");
        sb.append(tableName);
        sb.append(" where 1=1 ");
        return sb.toString();
    }

    private String getQueryFields(String tableName, String groupCode) {
        List<ModelFields> list = StringUtils.isNotBlank((CharSequence)groupCode) ? this.modelGroupService.findModelFields(tableName, groupCode) : this.modelFieldsService.findByTableName(tableName);
        return this.getQueryFields(tableName, list);
    }

    private String getFieldSql(String fieldName, String fieldType) {
        String sql = "";
        sql = FieldTypeEnum.GEOMETRY.equals((Object)FieldTypeEnum.valueOf(fieldType.toUpperCase())) ? "ST_AsText(" + fieldName + ") as wkt " : fieldName;
        return sql;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delObjectById(String tableName, String id) {
        ModelFields mf = this.modelFieldsService.findByTableNamePrimary(tableName);
        if (mf != null) {
            String[] ids = id.split(",");
            ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
            for (String one : ids) {
                Object[] objects = new Object[]{one};
                batchArgs.add(objects);
            }
            String sql = "DELETE FROM " + tableName + " WHERE " + mf.getFieldName() + " = ?";
            this.jdbcTemplate.batchUpdate(sql, batchArgs);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delObject(String tableName, String where) {
        this.jdbcTemplate.execute("DELETE FROM " + tableName + " WHERE 1=1 " + where);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delObject(String tableName, String where, Object[] values) {
        if (StrUtil.isBlank((CharSequence)where)) {
            this.jdbcTemplate.update("DELETE FROM " + tableName, values);
        } else if (where.toUpperCase().trim().startsWith("AND")) {
            this.jdbcTemplate.update("DELETE FROM " + tableName + " WHERE 1=1" + where, values);
        } else {
            this.jdbcTemplate.update("DELETE FROM " + tableName + " WHERE " + where, values);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void checkFHKProject(Map<String, Object> map, String userId) throws Exception {
        if (!map.containsKey("f_id")) {
            throw new Exception("\u5bf9\u8c61id\u4e3a\u7a7a");
        }
        String tableName = "tb_project_gdbh_cbbcgd_fhk";
        this.updateModel(map, tableName);
        Object result = map.get("f_check_result");
        if (result != null && "1".equals(result.toString())) {
            this.saveFHK2ZBK(map, tableName, userId);
        }
    }

    private void saveFHK2ZBK(Map<String, Object> map, String tableName, String userId) throws Exception {
        Map<String, Object> dbMap = this.findObject(tableName, map.get("f_id").toString(), null);
        Double bcgdmj = dbMap.get("f_bcgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_bcgdmj").toString());
        Double jzgdmj = dbMap.get("f_jzgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_jzgdmj").toString());
        Double jzstmj = dbMap.get("f_jzstmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_jzstmj").toString());
        Double tzgzgdmj = dbMap.get("f_tzgzgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_tzgzgdmj").toString());
        Double tzgzstmj = dbMap.get("f_tzgzstmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_tzgzstmj").toString());
        Integer bcgdpjzldb = dbMap.get("f_bcgdpjzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_bcgdpjzldb").toString());
        Integer tzgzqzldb = dbMap.get("f_tzgzqzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_tzgzqzldb").toString());
        Integer tzgzhzldb = dbMap.get("f_tzgzhzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_tzgzhzldb").toString());
        HashMap<String, Object> zbk = new HashMap<String, Object>();
        zbk.put("f_gdmj", jzgdmj);
        zbk.put("f_stmj", jzstmj + tzgzstmj);
        zbk.put("f_cnzb", bcgdmj * (double)(16 - bcgdpjzldb) * 1500.0 + tzgzgdmj * (double)(tzgzqzldb - tzgzhzldb) * 1500.0);
        zbk.put("xzqdm", dbMap.get("f_xzqhdm"));
        zbk.put("xzqmc", dbMap.get("f_xzqmc"));
        zbk.put("f_type", "\u590d\u6838\u9879\u76ee\u5165\u5e93");
        zbk.put("f_zy", String.format("\u6307\u6807\u6765\u6e90\uff1a\u590d\u6838\u5e93\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", dbMap.get("f_code"), dbMap.get("f_name")));
        zbk.put("f_state", "1");
        zbk.put("f_isprovince", 1);
        zbk.put("f_iscountry", 0);
        zbk.put("f_userid", userId);
        this.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", userId, true);
    }

    public List gatherData(String tableName, Gather gather) {
        ModelFields idenMeta;
        String where = gather.getWhere();
        String wkt = gather.getWkt();
        Integer type = gather.getType();
        List<ModelFields> orderIdens = gather.getOrderIdens();
        List<ModelFields> groupIdens = gather.getGroupIdens();
        List<ModelFields> sumIdens = gather.getSumIdens();
        List<ModelFields> appendIdens = gather.getAppendIdens();
        String innerSql = " select  * from " + tableName + "  where 1=1 ";
        String extField = gather.getExtfield();
        if (!Strings.isNullOrEmpty((String)extField)) {
            innerSql = " select  * ," + extField + " from " + tableName + "  where 1=1 ";
        }
        if (where != null && !where.trim().isEmpty()) {
            innerSql = innerSql + " and " + where;
        }
        StringBuilder gBuilder = new StringBuilder();
        StringBuilder gBuilder2 = new StringBuilder();
        int size = groupIdens.size();
        for (int i = 0; i < size; ++i) {
            ModelFields idenMeta2 = groupIdens.get(i);
            String idenCode = idenMeta2.getFieldName();
            String idenName = idenMeta2.getAlias();
            gBuilder.append(idenCode);
            gBuilder2.append(idenCode);
            gBuilder.append(" as ");
            gBuilder.append(idenName);
            if (i == size - 1) continue;
            gBuilder.append(",");
            gBuilder2.append(",");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        if (type == 1) {
            StringBuilder stringBuilder3 = null;
            if (appendIdens != null && appendIdens.size() > 0) {
                stringBuilder3 = new StringBuilder();
                int size2 = appendIdens.size();
                for (int i = 0; i < size2; ++i) {
                    String idencode = appendIdens.get(i).getFieldName();
                    String idenName = appendIdens.get(i).getAlias();
                    stringBuilder3.append("string_agg(");
                    stringBuilder3.append(idencode);
                    stringBuilder3.append(",',')");
                    stringBuilder3.append(" as ");
                    stringBuilder3.append(idenName);
                    if (i == size2 - 1) continue;
                    stringBuilder3.append(",");
                }
            }
            sqlBuilder.append(" select   ");
            sqlBuilder.append(gBuilder.toString());
            if (stringBuilder3 != null) {
                sqlBuilder.append("," + stringBuilder3.toString());
            }
            sqlBuilder.append(" ,count(*) as \u4e2a\u6570  ");
            sqlBuilder.append(" from (");
            sqlBuilder.append(innerSql);
            sqlBuilder.append(") as innertable");
            sqlBuilder.append(" group by  ");
            sqlBuilder.append(gBuilder2.toString());
        } else if (type == 2) {
            StringBuilder sumBuilder = new StringBuilder();
            int size3 = sumIdens.size();
            for (int i = 0; i < size3; ++i) {
                idenMeta = sumIdens.get(i);
                String idenCode = idenMeta.getFieldName();
                String idenName = idenMeta.getAlias();
                sumBuilder.append("sum(");
                sumBuilder.append(idenCode);
                sumBuilder.append(")");
                sumBuilder.append(" as ");
                sumBuilder.append(idenName);
                if (i == size3 - 1) continue;
                sumBuilder.append(",");
            }
            String extgather = gather.getExtgather();
            if (!Strings.isNullOrEmpty((String)extgather)) {
                sumBuilder.append(",");
                sumBuilder.append(extgather);
            }
            sqlBuilder.append(" select   ");
            sqlBuilder.append(gBuilder.toString());
            sqlBuilder.append(",");
            sqlBuilder.append((CharSequence)sumBuilder);
            sqlBuilder.append(" from ( ");
            sqlBuilder.append(innerSql);
            sqlBuilder.append(" ) as innertable ");
            sqlBuilder.append(" group by  ");
            sqlBuilder.append(gBuilder2.toString());
        }
        if (orderIdens != null) {
            StringBuilder orderBuilder = new StringBuilder();
            int size4 = orderIdens.size();
            for (int i = 0; i < size4; ++i) {
                idenMeta = orderIdens.get(i);
                String code = idenMeta.getFieldName();
                if (Strings.isNullOrEmpty((String)code)) continue;
                if (i == 0) {
                    orderBuilder.append(" order by ");
                }
                orderBuilder.append(code);
                if (i == size4 - 1) continue;
                orderBuilder.append(",");
            }
            sqlBuilder.append(orderBuilder.toString());
        }
        String sql = sqlBuilder.toString();
        logger.info(String.format("\u7edf\u8ba1\u6c47\u603bSQL\u3010%s\u3011", sql));
        List re = this.jdbcTemplate.queryForList(sqlBuilder.toString());
        return re;
    }

    public void updateJhkAnalState(String projectId, int state) throws Exception {
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        String sql = "UPDATE tb_project_gdbh_cbbcgd_jhk SET f_state=" + state + "WHERE f_id = '" + projectId + "'";
        this.jdbcTemplate.update(sql);
    }

    public List<Map<String, Object>> statByField(String tableName, List<String> wheres, Map<String, String> fieldMap) {
        StringBuilder sbr = new StringBuilder();
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String field = entry.getKey();
            String statType = entry.getValue();
            sbr.append(field);
            switch (statType) {
                case "count": {
                    sbr.append(String.format(",count(%s) as %s_count,", field, field));
                    break;
                }
                case "max": {
                    sbr.append(String.format(",max(%s) as %s_max,", field, field));
                    break;
                }
                case "min": {
                    sbr.append(String.format(",min(%s) as %s_min,", field, field));
                    break;
                }
                case "avg": {
                    sbr.append(String.format(",avg(%s) as %s_avg,", field, field));
                    break;
                }
                case "sum": {
                    sbr.append(String.format(",sum(%s) as %s_sum,", field, field));
                }
            }
        }
        sbr.deleteCharAt(sbr.length() - 1);
        String where = "";
        if (wheres != null && !wheres.isEmpty()) {
            for (String item : wheres) {
                where = where + " and " + item;
            }
        }
        String string = String.format(" select %s from %s where 1=1 %s group by %s ", sbr.toString(), tableName, where, String.join((CharSequence)",", fieldMap.keySet()));
        List list = this.jdbcTemplate.queryForList(string);
        return list;
    }

    public static Map<String, Object> removePrefix(Map<String, Object> originalMap, String prefix) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String key : originalMap.keySet()) {
            if (key.startsWith(prefix)) {
                String newKey = key.substring(prefix.length());
                newMap.put(newKey, originalMap.get(key));
                continue;
            }
            newMap.put(key, originalMap.get(key));
        }
        return newMap;
    }

    private int toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return Integer.parseInt(String.valueOf(obj));
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff01");
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ModelFieldsService getModelFieldsService() {
        return this.modelFieldsService;
    }

    public ModelGroupService getModelGroupService() {
        return this.modelGroupService;
    }

    public ModelObjectinfoService getModelObjectinfoService() {
        return this.modelObjectinfoService;
    }

    public IModelMapFieldDao getIModelMapFieldDao() {
        return this.iModelMapFieldDao;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setModelFieldsService(ModelFieldsService modelFieldsService) {
        this.modelFieldsService = modelFieldsService;
    }

    public void setModelGroupService(ModelGroupService modelGroupService) {
        this.modelGroupService = modelGroupService;
    }

    public void setModelObjectinfoService(ModelObjectinfoService modelObjectinfoService) {
        this.modelObjectinfoService = modelObjectinfoService;
    }

    public void setIModelMapFieldDao(IModelMapFieldDao iModelMapFieldDao) {
        this.iModelMapFieldDao = iModelMapFieldDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelManageService)) {
            return false;
        }
        ModelManageService other = (ModelManageService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        ModelFieldsService this$modelFieldsService = this.getModelFieldsService();
        ModelFieldsService other$modelFieldsService = other.getModelFieldsService();
        if (this$modelFieldsService == null ? other$modelFieldsService != null : !this$modelFieldsService.equals(other$modelFieldsService)) {
            return false;
        }
        ModelGroupService this$modelGroupService = this.getModelGroupService();
        ModelGroupService other$modelGroupService = other.getModelGroupService();
        if (this$modelGroupService == null ? other$modelGroupService != null : !this$modelGroupService.equals(other$modelGroupService)) {
            return false;
        }
        ModelObjectinfoService this$modelObjectinfoService = this.getModelObjectinfoService();
        ModelObjectinfoService other$modelObjectinfoService = other.getModelObjectinfoService();
        if (this$modelObjectinfoService == null ? other$modelObjectinfoService != null : !this$modelObjectinfoService.equals(other$modelObjectinfoService)) {
            return false;
        }
        IModelMapFieldDao this$iModelMapFieldDao = this.getIModelMapFieldDao();
        IModelMapFieldDao other$iModelMapFieldDao = other.getIModelMapFieldDao();
        return !(this$iModelMapFieldDao == null ? other$iModelMapFieldDao != null : !this$iModelMapFieldDao.equals(other$iModelMapFieldDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelManageService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        ModelFieldsService $modelFieldsService = this.getModelFieldsService();
        result = result * 59 + ($modelFieldsService == null ? 43 : $modelFieldsService.hashCode());
        ModelGroupService $modelGroupService = this.getModelGroupService();
        result = result * 59 + ($modelGroupService == null ? 43 : $modelGroupService.hashCode());
        ModelObjectinfoService $modelObjectinfoService = this.getModelObjectinfoService();
        result = result * 59 + ($modelObjectinfoService == null ? 43 : $modelObjectinfoService.hashCode());
        IModelMapFieldDao $iModelMapFieldDao = this.getIModelMapFieldDao();
        result = result * 59 + ($iModelMapFieldDao == null ? 43 : $iModelMapFieldDao.hashCode());
        return result;
    }

    public String toString() {
        return "ModelManageService(jdbcTemplate=" + this.getJdbcTemplate() + ", modelFieldsService=" + this.getModelFieldsService() + ", modelGroupService=" + this.getModelGroupService() + ", modelObjectinfoService=" + this.getModelObjectinfoService() + ", iModelMapFieldDao=" + this.getIModelMapFieldDao() + ")";
    }
}

