/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.web.config;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration
public class FileUploadConfiguration {
    @Value(value="${fileUpload.allowFileTypes:}")
    private String allowFileTypes;
    @Value(value="${fileUpload.maxFileSize:100MB}")
    private String maxFileSize;

    public List<String> getAllowFileTypes() {
        List<String> allowFileTypeList = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.allowFileTypes)) {
            allowFileTypeList.add("all");
        } else {
            String[] fileTypesArr = this.allowFileTypes.split(",");
            allowFileTypeList = Arrays.asList(fileTypesArr).stream().map(String::trim).collect(Collectors.toList());
        }
        return allowFileTypeList;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.parse((CharSequence)this.maxFileSize.trim()));
        return factory.createMultipartConfig();
    }
}

