/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.web.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

public class SwaggerConfig {
    public static final String VERSION = "0.0.1";

    @Bean
    public Docket customImplementation() {
        System.out.println("===================EnableSwagger2======================");
        return new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"^(?!auth).*$")).build().securityContexts(this.securityContexts()).apiInfo(this.apiInfo());
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> list = new ArrayList<SecurityContext>();
        list.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return list;
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> list = new ArrayList<SecurityReference>();
        list.add(new SecurityReference("Authorization", authorizationScopes));
        return list;
    }

    private List<ApiKey> securitySchemes() {
        ArrayList<ApiKey> list = new ArrayList<ApiKey>();
        list.add(new ApiKey("Authorization", "Authorization", "header"));
        return list;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Land api").description("api\u6587\u6863").license("Apache 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html").termsOfServiceUrl("").version(VERSION).contact(new Contact("\u5409\u5a01", "http://www.geoway.com.cn", "")).build();
    }
}

