package com.geoway.web.listener;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class LoadMessageListener implements ApplicationListener<ContextRefreshedEvent>, Ordered {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日 HH:mm:ss");

    private String msg = "";

    public LoadMessageListener(String msg){
        this.msg = msg;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        ApplicationContext context =  contextRefreshedEvent.getApplicationContext();
        if(context.getParent()==null){
            long start = context.getStartupDate();
            long eat  = System.currentTimeMillis() - start;
            System.out.println( sdf.format(Calendar.getInstance().getTime()) + msg +  " 接口启动成功！！！  耗时 " + eat/1000 + "s" );
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}
