/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.aop;

import com.geoway.onemap.biz.aop.ValidPermission;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.ValidPermissionService;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Aspect
@Service
public class ValidPermissionAspect {
    private Logger logger = Logger.getLogger(ValidPermissionAspect.class);
    @Autowired
    ValidPermissionService validPermissionService;
    @Autowired
    LoginServiceUIS loginServiceUIS;

    @Before(value="@within(com.geoway.onemap.biz.aop.ValidPermission)")
    public void before(JoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = request.getHeader("access_token");
        }
        ValidPermission validPermission = null;
        Method[] methods = joinPoint.getTarget().getClass().getMethods();
        String methodName = joinPoint.getSignature().getName();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            validPermission = method.getAnnotation(ValidPermission.class);
            break;
        }
        if (validPermission == null) {
            validPermission = joinPoint.getTarget().getClass().getAnnotation(ValidPermission.class);
        }
        if (validPermission != null && validPermission.enable()) {
            if (this.loginServiceUIS.isUISEnable()) {
                this.loginServiceUIS.validPermission(token, validPermission.menu(), validPermission.systemId());
            } else {
                this.validPermissionService.validPermission(token, validPermission.menu(), validPermission.systemId());
            }
        }
    }

    @Before(value="@annotation(com.geoway.onemap.biz.aop.ValidPermission)")
    public void beforeMethod(JoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains("multipart/form-data")) {
            CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            MultipartHttpServletRequest multipartRequest = resolver.resolveMultipart(request);
            request = multipartRequest;
        }
        String token = request.getParameter("token");
        Class<?> clazz = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        String targetName = clazz.getSimpleName();
        Class<?>[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes();
        Method methdo = clazz.getMethod(methodName, parameterTypes);
        ValidPermission validPermission = methdo.getAnnotation(ValidPermission.class);
        if (validPermission != null && validPermission.enable()) {
            if (this.loginServiceUIS.isUISEnable()) {
                this.loginServiceUIS.validPermission(token, validPermission.menu(), validPermission.systemId());
            } else {
                this.validPermissionService.validPermission(token, validPermission.menu(), validPermission.systemId());
            }
        }
    }
}

