/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.support;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.exception.PermissionException;
import com.geoway.onemap.core.exception.TokenInvalidException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class DefaultExceptionHandler
implements HandlerExceptionResolver {
    private Logger logger = Logger.getLogger(DefaultExceptionHandler.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView mv = new ModelAndView();
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        try {
            BaseResponse baseResopnse = new BaseResponse();
            if (ex instanceof TokenInvalidException) {
                baseResopnse.markNoLogin();
            } else if (ex instanceof PermissionException) {
                baseResopnse.markNoPermisson();
            } else {
                baseResopnse.markFailure();
            }
            baseResopnse.setMessage(ex.getMessage());
            String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
            response.getOutputStream().write(jsonResult.getBytes());
        }
        catch (IOException e) {
            this.logger.error((Object)("\u4e0e\u5ba2\u6237\u7aef\u901a\u8baf\u5f02\u5e38:" + e.getMessage()), (Throwable)e);
        }
        this.logger.debug((Object)("\u5f02\u5e38:" + ex.getMessage()), (Throwable)ex);
        return mv;
    }
}

