/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.geoway.onemap.stxf.utils.ExcelSheet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger mLogger = LoggerFactory.getLogger(ExcelUtil.class);

    public static List<List<Object>> readExcel(File file) throws IOException {
        Workbook wb;
        List<List<Object>> list = new ArrayList<List<Object>>();
        if (file.exists() && file.isFile() && (wb = ExcelUtil.getWorkbook(file)) != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, 0);
            list = ExcelUtil.getSheetData(wb, sheet);
        }
        return list;
    }

    public static List<List<Object>> readExcel(File file, int sheetIndex) throws IOException {
        Workbook wb;
        List<List<Object>> list = new ArrayList<List<Object>>();
        if (file.exists() && file.isFile() && (wb = ExcelUtil.getWorkbook(file)) != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetIndex);
            list = ExcelUtil.getSheetData(wb, sheet);
        }
        return list;
    }

    public static List<List<Object>> readExcel(File file, int sheetIndex, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws IOException {
        List<List<Object>> list = new ArrayList<List<Object>>();
        Workbook wb = ExcelUtil.getWorkbook(file);
        if (wb != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetIndex);
            list = ExcelUtil.getSheetData(wb, sheet, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex);
        }
        return list;
    }

    public static List<List<Object>> readExcel(File file, String sheetName) throws IOException {
        List<List<Object>> list = new ArrayList<List<Object>>();
        Workbook wb = ExcelUtil.getWorkbook(file);
        if (wb != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetName);
            list = ExcelUtil.getSheetData(wb, sheet);
        }
        return list;
    }

    public static List<List<Object>> readExcel(File file, String sheetName, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws IOException {
        List<List<Object>> list = new ArrayList<List<Object>>();
        Workbook wb = ExcelUtil.getWorkbook(file);
        if (wb != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetName);
            list = ExcelUtil.getSheetData(wb, sheet, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex);
        }
        return list;
    }

    public static List<List<Object>> readExcelBody(File file, int sheetIndex) throws IOException {
        Workbook wb;
        List<List<Object>> list = new ArrayList<List<Object>>();
        if (file.exists() && file.isFile() && (wb = ExcelUtil.getWorkbook(file)) != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetIndex);
            list = ExcelUtil.getSheetBodyData(wb, sheet);
        }
        return list;
    }

    public static List<List<Object>> readExcelBody(File file, String sheetName) throws IOException {
        Workbook wb;
        List<List<Object>> list = new ArrayList<List<Object>>();
        if (file.exists() && file.isFile() && (wb = ExcelUtil.getWorkbook(file)) != null) {
            Sheet sheet = ExcelUtil.getSheet(wb, sheetName);
            list = ExcelUtil.getSheetBodyData(wb, sheet);
        }
        return list;
    }

    public static List<List<Object>> readExcel(String filePath) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcel(file);
    }

    public static List<List<Object>> readExcel(String filePath, int sheetIndex) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcel(file, sheetIndex);
    }

    public static List<List<Object>> readExcel(String filePath, int sheetIndex, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcel(file, sheetIndex, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex);
    }

    public static List<List<Object>> readExcel(String filePath, String sheetName) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcel(file, sheetName);
    }

    public static List<List<Object>> readExcel(String filePath, String sheetName, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcel(file, sheetName, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex);
    }

    public static List<List<Object>> readExcelBody(String filePath, int sheetIndex) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcelBody(file, sheetIndex);
    }

    public static List<List<Object>> readExcelBody(String filePath, String sheetName) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.readExcelBody(file, sheetName);
    }

    public static List<Sheet> getAllSheets(Workbook wb) {
        int numOfSheets = wb.getNumberOfSheets();
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        for (int i = 0; i < numOfSheets; ++i) {
            sheets.add(wb.getSheetAt(i));
        }
        return sheets;
    }

    public static Workbook getWorkbook(File file) throws IOException {
        HSSFWorkbook wb = null;
        if (file.exists() && file.isFile()) {
            String extension;
            String fileName = file.getName();
            String string = extension = fileName.lastIndexOf(".") == -1 ? "" : fileName.substring(fileName.lastIndexOf(".") + 1);
            if ("xls".equals(extension)) {
                wb = new HSSFWorkbook((InputStream)new FileInputStream(file));
            } else if ("xlsx".equals(extension)) {
                wb = new XSSFWorkbook((InputStream)new FileInputStream(file));
            } else {
                throw new IOException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
        }
        return wb;
    }

    public static Workbook getWorkbook(String filePath) throws IOException {
        File file = new File(filePath);
        return ExcelUtil.getWorkbook(file);
    }

    public static Workbook getExportWorkbook(String filePath) throws IOException {
        String extension;
        HSSFWorkbook wb = null;
        File file = new File(filePath);
        String fileName = file.getName();
        String string = extension = fileName.lastIndexOf(".") == -1 ? "" : fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("xls".equals(extension)) {
            wb = new HSSFWorkbook();
        } else if ("xlsx".equals(extension)) {
            wb = new SXSSFWorkbook(5000);
        } else {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        return wb;
    }

    public static Sheet getSheet(Workbook wb, int sheetIndex) {
        return wb.getSheetAt(sheetIndex);
    }

    public static Sheet getSheet(Workbook wb, String sheetName) {
        return wb.getSheet(sheetName);
    }

    public static List<List<Object>> getSheetData(Workbook wb, Sheet sheet) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            boolean allRowIsBlank = ExcelUtil.isBlankRow(wb, row);
            if (allRowIsBlank) continue;
            List<Object> rowData = ExcelUtil.getRowData(wb, row);
            list.add(rowData);
        }
        return list;
    }

    public static List<List<Object>> getSheetBodyData(Workbook wb, Sheet sheet) throws IOException {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        int rowNum = sheet.getPhysicalNumberOfRows();
        Row headerRow = sheet.getRow(0);
        int colNum = headerRow.getPhysicalNumberOfCells();
        list.addAll(ExcelUtil.getSheetData(wb, sheet, 1, rowNum, 0, colNum));
        return list;
    }

    public static List<List<Object>> getSheetData(Workbook wb, Sheet sheet, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws IOException {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        if (startRowIndex > endRowIndex || startColumnIndex > endColumnIndex) {
            return list;
        }
        int rowNum = sheet.getPhysicalNumberOfRows();
        Row headerRow = sheet.getRow(0);
        int colNum = headerRow.getPhysicalNumberOfCells();
        if (endRowIndex > rowNum) {
            throw new IOException("\u884c\u7684\u6700\u5927\u4e0b\u6807\u7d22\u5f15\u8d85\u8fc7\u4e86\u8be5sheet\u5b9e\u9645\u603b\u884c\u6570(\u5305\u62ec\u6807\u9898\u884c)" + rowNum);
        }
        if (endColumnIndex > colNum) {
            throw new IOException("\u5217\u7684\u6700\u5927\u4e0b\u6807\u7d22\u5f15\u8d85\u8fc7\u4e86\u5b9e\u9645\u6807\u9898\u603b\u5217\u6570" + colNum);
        }
        for (int i = startRowIndex; i < endRowIndex; ++i) {
            Row row = sheet.getRow(i);
            boolean allRowIsBlank = ExcelUtil.isBlankRow(wb, row);
            if (allRowIsBlank) continue;
            List<Object> rowData = ExcelUtil.getRowData(wb, row, startColumnIndex, endColumnIndex);
            list.add(rowData);
        }
        return list;
    }

    public static List<Object> getRowData(Workbook wb, Row row, int startColumnIndex, int endColumnIndex) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        for (int j = startColumnIndex; j < endColumnIndex; ++j) {
            Cell cell = row.getCell(j);
            rowData.add(ExcelUtil.getCellValue(wb, cell));
        }
        return rowData;
    }

    public static boolean isBlankRow(Workbook wb, Row row) {
        boolean allRowIsBlank = true;
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Object cellValue = ExcelUtil.getCellValue(wb, (Cell)cellIterator.next());
            if (cellValue == null || "".equals(cellValue)) continue;
            allRowIsBlank = false;
            break;
        }
        return allRowIsBlank;
    }

    public static List<Object> getRowData(Workbook wb, Row row) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            Object cellValue = ExcelUtil.getCellValue(wb, cell);
            rowData.add(cellValue);
        }
        return rowData;
    }

    public static Object getCellValue(Workbook wb, Cell cell) {
        if (cell == null || cell.getCellType() == 1 && StringUtils.isBlank((String)cell.getStringCellValue())) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("0");
        DecimalFormat nf = new DecimalFormat("0");
        int cellType = cell.getCellType();
        switch (cellType) {
            case 3: {
                return null;
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
            case 2: {
                return cell.getNumericCellValue();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                if ("@".equals(cell.getCellStyle().getDataFormatString())) {
                    String value = df.format(cell.getNumericCellValue());
                    if (StringUtils.isBlank((String)value)) {
                        return null;
                    }
                    return value;
                }
                if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                    Double value = cell.getNumericCellValue();
                    return value;
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                String value = cell.getStringCellValue();
                if (StringUtils.isBlank((String)value)) {
                    return null;
                }
                return value;
            }
        }
        return null;
    }

    public static int getSheetPhysicalRowNum(Sheet sheet) {
        int rowNum = sheet.getPhysicalNumberOfRows();
        return rowNum;
    }

    public static int getSheetDataPhysicalRowNum(int startRowIndex, int endRowIndex) {
        int rowNum = -1;
        if (startRowIndex >= 0 && endRowIndex >= 0 && startRowIndex <= endRowIndex) {
            rowNum = endRowIndex - startRowIndex + 1;
        }
        return rowNum;
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, String filePath) {
        ExcelUtil.exportExcel(headers, dataset, filePath, null);
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, String filePath, String pattern) {
        try {
            Workbook workbook = ExcelUtil.getExportWorkbook(filePath);
            if (workbook != null) {
                Sheet sheet = workbook.createSheet();
                ExcelUtil.write2Sheet(sheet, headers, dataset, pattern);
                FileOutputStream out = new FileOutputStream(new File(filePath));
                workbook.write((OutputStream)out);
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            mLogger.error(e.toString(), (Throwable)e);
        }
    }

    public static void exportExcel(String[][] dataList, String filePath) {
        try {
            Workbook workbook = ExcelUtil.getExportWorkbook(filePath);
            if (workbook != null) {
                Sheet sheet = workbook.createSheet();
                for (int i = 0; i < dataList.length; ++i) {
                    String[] r = dataList[i];
                    Row row = sheet.createRow(i);
                    for (int j = 0; j < r.length; ++j) {
                        Cell cell = row.createCell(j);
                        if (r[j].length() > Short.MAX_VALUE) {
                            mLogger.warn("\u5f02\u5e38\u5904\u7406", (Object)("--\u6b64\u5b57\u6bb5\u8fc7\u957f(\u8d85\u8fc732767),\u5df2\u88ab\u622a\u65ad--" + r[j]));
                            r[j] = r[j].substring(0, 32766);
                        }
                        cell.setCellValue(r[j]);
                    }
                }
                if (dataList.length > 0) {
                    int colcount = dataList[0].length;
                    for (int i = 0; i < colcount; ++i) {
                        sheet.autoSizeColumn(i);
                    }
                }
                FileOutputStream out = new FileOutputStream(new File(filePath));
                workbook.write((OutputStream)out);
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            mLogger.error(e.toString(), (Throwable)e);
        }
    }

    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, String filePath) {
        ExcelUtil.exportExcel(sheets, filePath, null);
    }

    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, String filePath, String pattern) {
        if (CollectionUtils.isEmpty(sheets)) {
            return;
        }
        try {
            Workbook workbook = ExcelUtil.getExportWorkbook(filePath);
            if (workbook != null) {
                for (ExcelSheet<T> sheetInfo : sheets) {
                    Sheet sheet = workbook.createSheet(sheetInfo.getSheetName());
                    ExcelUtil.write2Sheet(sheet, sheetInfo.getHeaders(), sheetInfo.getDataset(), pattern);
                }
                FileOutputStream out = new FileOutputStream(new File(filePath));
                workbook.write((OutputStream)out);
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            mLogger.error(e.toString(), (Throwable)e);
        }
    }

    public static <T> void write2Sheet(Sheet sheet, String[] headers, Collection<T> dataset, String pattern) {
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            Cell cell;
            int i;
            row = sheet.createRow(++index);
            T t = it.next();
            if (t instanceof Map) {
                Map map = (Map)t;
                int cellNum = 0;
                for (String k : headers) {
                    if (!map.containsKey(k)) {
                        mLogger.error("Map \u4e2d \u4e0d\u5b58\u5728 key [" + k + "]");
                        continue;
                    }
                    Cell cell2 = row.createCell(cellNum);
                    Object value = map.get(k);
                    if (value == null) {
                        cell2.setCellValue("");
                    } else {
                        cell2.setCellValue(String.valueOf(value));
                    }
                    ++cellNum;
                }
                continue;
            }
            if (t instanceof Object[]) {
                Object[] tObjArr = (Object[])t;
                for (i = 0; i < tObjArr.length; ++i) {
                    cell = row.createCell(i);
                    Object value = tObjArr[i];
                    if (value == null) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(String.valueOf(value));
                }
                continue;
            }
            if (t instanceof List) {
                List rowData = (List)t;
                for (i = 0; i < rowData.size(); ++i) {
                    cell = row.createCell(i);
                    Object value = rowData.get(i);
                    if (value == null) {
                        cell.setCellValue("");
                        continue;
                    }
                    cell.setCellValue(String.valueOf(value));
                }
                continue;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                cell = row.createCell(i);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tClazz = t.getClass();
                    Method getMethod = tClazz.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        cell.setCellValue((double)fValue);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        cell.setCellValue(dValue);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Boolean) {
                        boolean bValue = (Boolean)value;
                        cell.setCellValue(bValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue != null) {
                        cell.setCellValue(textValue);
                        continue;
                    }
                    cell.setCellValue("");
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        for (int i = 0; i < headers.length; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    public static void download(String path, HttpServletResponse response) {
        try {
            File file = new File(path);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=gb2312");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ArrayList sheetsData = new ArrayList();
        int sheetRowNum = 50000;
        for (int i = 0; i < 3; ++i) {
            ExcelSheet sheetData = new ExcelSheet();
            String[] headers = new String[]{"\u59d3\u540d", "\u624b\u673a\u53f7\u7801", "\u6027\u522b", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u5bb6\u5ead\u4f4f\u5740"};
            String sheetName = "\u7b2c" + (i + 1) + "\u4e2asheet";
            ArrayList sheetDataList = new ArrayList();
            for (int j = 0; j < sheetRowNum; ++j) {
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add("\u5c0f\u660e");
                rowData.add("18888888888");
                rowData.add("\u7537");
                rowData.add("123123123123123123");
                rowData.add("\u5e7f\u5dde\u5e02");
                sheetDataList.add(rowData);
            }
            sheetData.setSheetName(sheetName);
            sheetData.setHeaders(headers);
            sheetData.setDataset(sheetDataList);
            sheetsData.add(sheetData);
        }
        String filePath = "d://out_" + System.currentTimeMillis() + ".xlsx";
        ExcelUtil.exportExcel(sheetsData, filePath);
        System.out.println("-----end-----");
    }

    public static HSSFCellStyle createHeadCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        HSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        headerFont.setFontName("\u9ed1\u4f53");
        headerFont.setFontHeightInPoints((short)12);
        cellStyle.setFont(headerFont);
        return cellStyle;
    }

    public static HSSFCellStyle createContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        HSSFFont font = wb.createFont();
        font.setColor((short)8);
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }
}

