/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class FileUnZipRar {
    public static String zipRarToFile(String fileName, String sourceFile, String toFolder) throws Exception {
        int pos = fileName.lastIndexOf(".");
        String extName = fileName.substring(pos + 1).toLowerCase();
        File pushFile = new File(sourceFile);
        File descFile = new File(toFolder);
        if (!descFile.exists()) {
            descFile.mkdirs();
        }
        String descDir = toFolder + "\\" + fileName.substring(0, pos) + "\\";
        if (extName.equals("zip")) {
            FileUnZipRar.unZipFiles(pushFile, descDir);
        } else if (extName.equals("rar")) {
            FileUnZipRar.unRarFile(pushFile.getAbsolutePath(), descDir);
        }
        return "";
    }

    public static List<File> getFileList(List<File> filelist, String strPath) {
        File dir = new File(strPath);
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (files[i].isDirectory()) {
                    FileUnZipRar.getFileList(filelist, files[i].getAbsolutePath());
                    continue;
                }
                filelist.add(files[i]);
            }
        }
        return filelist;
    }

    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        FileUnZipRar.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile, "gbk");
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String zipEntryName = entry.getName();
            InputStream in = zip.getInputStream(entry);
            String outPath = (descDir + File.separator + zipEntryName).replaceAll("\\*", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
        zip.close();
    }

    public static void unRarFile(String srcRarPath, String dstDirectoryPath) {
        block11: {
            if (!srcRarPath.toLowerCase().endsWith(".rar")) {
                System.out.println("\u975erar\u6587\u4ef6\uff01");
                return;
            }
            File dstDiretory = new File(dstDirectoryPath);
            if (!dstDiretory.exists()) {
                dstDiretory.mkdirs();
            }
            Archive a = null;
            try {
                a = new Archive(new File(srcRarPath));
                if (a == null) break block11;
                a.getMainHeader().print();
                FileHeader fh = a.nextFileHeader();
                while (fh != null) {
                    if (fh.isDirectory()) {
                        File fol = new File(dstDirectoryPath + File.separator + fh.getFileNameString());
                        fol.mkdirs();
                    } else {
                        File out = new File(dstDirectoryPath + File.separator + fh.getFileNameString().trim());
                        try {
                            if (!out.exists()) {
                                if (!out.getParentFile().exists()) {
                                    out.getParentFile().mkdirs();
                                }
                                out.createNewFile();
                            }
                            FileOutputStream os = new FileOutputStream(out);
                            a.extractFile(fh, (OutputStream)os);
                            os.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    fh = a.nextFileHeader();
                }
                a.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String seachFirstFileBySuffix(File dir) {
        File[] subFiles;
        String fileName = "";
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().contains(".shp")) continue;
                fileName = subFile.getAbsolutePath();
                break;
            }
            fileName = FileUnZipRar.seachFirstFileBySuffix(subFile);
            if (StringUtils.isNotBlank((String)fileName)) break;
        }
        return fileName;
    }

    public static String seachFirstPrjBySuffix(File dir) {
        File[] subFiles;
        String fileName = "";
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().contains(".prj")) continue;
                fileName = subFile.getAbsolutePath();
                break;
            }
            fileName = FileUnZipRar.seachFirstPrjBySuffix(subFile);
            if (StringUtils.isNotBlank((String)fileName)) break;
        }
        return fileName;
    }

    public static String seachFirstCpgBySuffix(File dir) {
        File[] subFiles;
        String fileName = "";
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().contains(".cpg")) continue;
                fileName = subFile.getAbsolutePath();
                break;
            }
            fileName = FileUnZipRar.seachFirstCpgBySuffix(subFile);
            if (StringUtils.isNotBlank((String)fileName)) break;
        }
        return fileName;
    }
}

