/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.alibaba.fastjson.JSONArray;
import com.geoway.base.support.SnowflakeIdWorker;
import com.geoway.onemap.stxf.utils.EncodingDetect;
import com.geoway.onemap.stxf.utils.ExcelUtil;
import com.geoway.onemap.stxf.utils.GaussXY2BL;
import com.geoway.onemap.stxf.utils.GeoJsonUtil;
import com.geoway.onemap.stxf.utils.SRWKTTemplate;
import com.geoway.onemap.zbph.supoort.ShpUtil;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.PrjFileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.util.StringUtils;

public class ShpUtils {
    private static final String DEFAULT_CHARSET = "gb2312";
    private static final List<String> propKeyList = new ArrayList<String>();
    private static final Map<String, Charset> ENCODING_MAPPING = new HashMap<String, Charset>();

    public static Map readShp(String shpPath) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        try {
            ArrayList<Geometry> lists = new ArrayList<Geometry>();
            HashMap<String, JSONObject> geoJsonMap = new HashMap<String, JSONObject>();
            ShpFiles sf = new ShpFiles(new File(shpPath));
            ShapefileReader r = new ShapefileReader(sf, false, false, new GeometryFactory());
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            double[] bounds = new double[4];
            int i = 0;
            while (r.hasNext()) {
                Geometry shape = (Geometry)r.nextRecord().shape();
                Envelope envelope = shape.getEnvelopeInternal();
                if (++i == 1) {
                    bounds[0] = envelope.getMinX();
                    bounds[1] = envelope.getMinX();
                }
                bounds[0] = envelope.getMinX() < bounds[0] ? envelope.getMinX() : bounds[0];
                bounds[1] = envelope.getMinY() < bounds[1] ? envelope.getMinY() : bounds[1];
                bounds[2] = envelope.getMaxX() > bounds[2] ? envelope.getMaxX() : bounds[2];
                bounds[3] = envelope.getMaxY() > bounds[3] ? envelope.getMaxY() : bounds[3];
                JSONObject jsonObject = GeoJsonUtil.parsePolygon2Geojson(shape);
                geoJsonMap.put(worker.nextId() + "", jsonObject);
                lists.add(shape);
            }
            r.close();
            rtnMap.put("bounds", bounds);
            rtnMap.put("geos", geoJsonMap);
            rtnMap.put("status", "OK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtnMap;
    }

    public static Map readShp2WKT(String shpPath) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        try {
            ArrayList<Geometry> lists = new ArrayList<Geometry>();
            HashMap<String, String> geoJsonMap = new HashMap<String, String>();
            ShpFiles sf = new ShpFiles(new File(shpPath));
            ShapefileReader r = new ShapefileReader(sf, false, false, new GeometryFactory());
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            double[] bounds = new double[4];
            int i = 0;
            ShapefileReader.Record record = null;
            while (r.hasNext()) {
                record = r.nextRecord();
                Geometry shape = (Geometry)record.shape();
                Envelope envelope = shape.getEnvelopeInternal();
                if (++i == 1) {
                    bounds[0] = envelope.getMinX();
                    bounds[1] = envelope.getMinX();
                }
                bounds[0] = envelope.getMinX() < bounds[0] ? envelope.getMinX() : bounds[0];
                bounds[1] = envelope.getMinY() < bounds[1] ? envelope.getMinY() : bounds[1];
                bounds[2] = envelope.getMaxX() > bounds[2] ? envelope.getMaxX() : bounds[2];
                bounds[3] = envelope.getMaxY() > bounds[3] ? envelope.getMaxY() : bounds[3];
                geoJsonMap.put(worker.nextId() + "", shape.toText());
                lists.add(shape);
            }
            r.close();
            rtnMap.put("bounds", bounds);
            rtnMap.put("geos", geoJsonMap);
            rtnMap.put("fileType", "shp");
            rtnMap.put("status", "OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtnMap;
    }

    public static Map readValidShp2WKT2(String shpPath, String prjpath, String cpgPath, List<String> requiredPropList) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        String[] fieldIgnoreArr = new String[]{"Shape_Area", "the_geom", "Shape_Le_1"};
        try {
            List<String> notValidProps;
            ArrayList<String> geoJsonMap = new ArrayList<String>();
            ArrayList attrsMap = new ArrayList();
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            File shpFile = new File(shpPath);
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(shpFile.toURI().toURL());
            Charset charset = null;
            if (cpgPath != null) {
                charset = ShpUtils.getCharsetFromCpg(cpgPath);
            }
            if (charset == null) {
                charset = ShpUtil.getShapeFileCharsetName(shpPath);
            }
            shpDataStore.setCharset(charset);
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource();
            SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            double[] bounds = new double[4];
            int i = 0;
            if (requiredPropList == null || requiredPropList.size() == 0) {
                requiredPropList = propKeyList;
            }
            if ((notValidProps = ShpUtils.validatePropKeys((SimpleFeatureSource)featureSource, requiredPropList)).size() > 0) {
                String errMsg = String.join((CharSequence)"\u3001", notValidProps);
                throw new Exception(String.format("\u5bfc\u5165\u7684shape\u6570\u636e\u7f3a\u5c11\u3010 %s \u3011\u7b49\u5fc5\u987b\u5c5e\u6027\u5b57\u6bb5!", errMsg));
            }
            SimpleFeature feature = null;
            while (itertor.hasNext()) {
                ++i;
                feature = (SimpleFeature)itertor.next();
                Geometry shape1 = (Geometry)feature.getDefaultGeometry();
                Geometry shape = ShpUtils.lonlat2WebMactor(shape1, prjpath);
                HashMap<String, String> plotAttr = new HashMap<String, String>();
                Envelope envelope = shape.getEnvelopeInternal();
                if (i == 1) {
                    bounds[0] = envelope.getMinX();
                    bounds[1] = envelope.getMinX();
                }
                bounds[0] = envelope.getMinX() < bounds[0] ? envelope.getMinX() : bounds[0];
                bounds[1] = envelope.getMinY() < bounds[1] ? envelope.getMinY() : bounds[1];
                bounds[2] = envelope.getMaxX() > bounds[2] ? envelope.getMaxX() : bounds[2];
                bounds[3] = envelope.getMaxY() > bounds[3] ? envelope.getMaxY() : bounds[3];
                Collection properties = feature.getProperties();
                Iterator iterator = properties.iterator();
                plotAttr.put("wkt", shape.toText());
                while (iterator.hasNext()) {
                    String propvalue;
                    Property property = (Property)iterator.next();
                    String propName = property.getName().getLocalPart();
                    String string = propvalue = property.getValue() == null ? "" : property.getValue().toString();
                    if (Arrays.asList(fieldIgnoreArr).contains(propName)) continue;
                    plotAttr.put(propName, propvalue);
                }
                geoJsonMap.add(shape.toText());
                attrsMap.add(plotAttr);
            }
            itertor.close();
            shpDataStore.dispose();
            rtnMap.put("bounds", bounds);
            rtnMap.put("geos", geoJsonMap);
            rtnMap.put("properties", attrsMap);
            rtnMap.put("fileType", "zip");
            rtnMap.put("status", "OK");
            rtnMap.put("message", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", e.getMessage());
        }
        return rtnMap;
    }

    public static Map readShp2WKT2(String shpPath, String prjpath) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        String[] fieldIgnoreArr = new String[]{"Shape_Area", "the_geom", "Shape_Le_1"};
        try {
            ArrayList<String> geoJsonMap = new ArrayList<String>();
            ArrayList attrsMap = new ArrayList();
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            File shpFile = new File(shpPath);
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(shpFile.toURI().toURL());
            shpDataStore.setCharset(Charset.forName(DEFAULT_CHARSET));
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource();
            SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            double[] bounds = new double[4];
            int i = 0;
            SimpleFeature feature = null;
            while (itertor.hasNext()) {
                ++i;
                feature = (SimpleFeature)itertor.next();
                Geometry shape1 = (Geometry)feature.getDefaultGeometry();
                Geometry shape = ShpUtils.lonlat2WebMactor(shape1, prjpath);
                double akArea = shape1.getArea();
                HashMap<String, String> plotAttr = new HashMap<String, String>();
                Envelope envelope = shape.getEnvelopeInternal();
                if (i == 1) {
                    bounds[0] = envelope.getMinX();
                    bounds[1] = envelope.getMinX();
                }
                bounds[0] = envelope.getMinX() < bounds[0] ? envelope.getMinX() : bounds[0];
                bounds[1] = envelope.getMinY() < bounds[1] ? envelope.getMinY() : bounds[1];
                bounds[2] = envelope.getMaxX() > bounds[2] ? envelope.getMaxX() : bounds[2];
                bounds[3] = envelope.getMaxY() > bounds[3] ? envelope.getMaxY() : bounds[3];
                Collection properties = feature.getProperties();
                Iterator iterator = properties.iterator();
                plotAttr.put("wkt", shape.toText());
                while (iterator.hasNext()) {
                    String propvalue;
                    Property property = (Property)iterator.next();
                    String propName = property.getName().getLocalPart();
                    String string = propvalue = property.getValue() == null ? "" : property.getValue().toString();
                    if (Arrays.asList(fieldIgnoreArr).contains(propName)) continue;
                    plotAttr.put(propName, propvalue);
                }
                geoJsonMap.add(shape.toText());
                attrsMap.add(plotAttr);
            }
            itertor.close();
            shpDataStore.dispose();
            rtnMap.put("bounds", bounds);
            rtnMap.put("geos", geoJsonMap);
            rtnMap.put("properties", attrsMap);
            rtnMap.put("fileType", "zip");
            rtnMap.put("status", "OK");
            rtnMap.put("message", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", e.getMessage());
        }
        return rtnMap;
    }

    public static List<Map> readShpInfo(String shpPath, String prjpath) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        try {
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(new File(shpPath).toURI().toURL());
            shpDataStore.setCharset(Charset.forName(DEFAULT_CHARSET));
            String chasetStr = shpDataStore.getCharset().toString();
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource();
            SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            int i = 0;
            SimpleFeature feature = null;
            while (itertor.hasNext()) {
                ++i;
                feature = (SimpleFeature)itertor.next();
                Geometry shape1 = (Geometry)feature.getDefaultGeometry();
                double akArea = shape1.getArea();
                HashMap<String, Object> plotAttr = new HashMap<String, Object>();
                plotAttr.put("f_shape", shape1);
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    plotAttr.put(property.getName().getLocalPart(), property.getValue());
                }
                rtnList.add(plotAttr);
            }
            itertor.close();
            shpDataStore.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtnList;
    }

    public static List<Map<String, Object>> getNoGeoProperties(String shpPath) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            URL path = new File(shpPath).toURI().toURL();
            ShapefileDataStore shpDataStore = new ShapefileDataStore(path);
            shpDataStore.setCharset(Charset.forName("GBK"));
            String typeName = shpDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = null;
            featureSource = shpDataStore.getFeatureSource(typeName);
            FeatureCollection result = featureSource.getFeatures();
            FeatureIterator itertor = result.features();
            while (itertor.hasNext()) {
                SimpleFeature feature = (SimpleFeature)itertor.next();
                Iterator iterator = feature.getValue().iterator();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    Name name = property.getName();
                    Object value = property.getValue();
                    if ("the_geom".equals(name.toString())) continue;
                    map.put(name.toString(), value);
                }
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Map<String, Object>> getShpProperties(String shpPath, List<String> names) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            URL path = new File(shpPath).toURI().toURL();
            ShapefileDataStore shpDataStore = new ShapefileDataStore(path);
            shpDataStore.setCharset(Charset.forName("GBK"));
            String typeName = shpDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = null;
            featureSource = shpDataStore.getFeatureSource(typeName);
            FeatureCollection result = featureSource.getFeatures();
            FeatureIterator itertor = result.features();
            while (itertor.hasNext()) {
                SimpleFeature feature = (SimpleFeature)itertor.next();
                Iterator iterator = feature.getValue().iterator();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    Name name = property.getName();
                    Object value = property.getValue();
                    if (names != null) {
                        if (!names.contains(name.toString())) continue;
                        map.put(name.toString(), value);
                        continue;
                    }
                    map.put(name.toString(), value);
                }
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Map<String, Object>> getShpGCSProperties(String shpPath) {
        ArrayList list = null;
        try {
            URL path = new File(URLDecoder.decode(shpPath, "utf-8")).toURI().toURL();
            ShapefileDataStore shpDataStore = new ShapefileDataStore(path);
            shpDataStore.setCharset(Charset.forName("GBK"));
            String typeName = shpDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = null;
            featureSource = shpDataStore.getFeatureSource(typeName);
            FeatureCollection result = featureSource.getFeatures();
            FeatureIterator itertorF = result.features();
            SimpleFeature feature = (SimpleFeature)itertorF.next();
            GeometryAttribute geometryAttribute = feature.getDefaultGeometryProperty();
            CoordinateReferenceSystem coordinateReferenceSystem = geometryAttribute.getDescriptor().getCoordinateReferenceSystem();
            MathTransform transform = null;
            if (coordinateReferenceSystem != null && coordinateReferenceSystem.toWKT().startsWith("PROJCS")) {
                String prjName = coordinateReferenceSystem.getName().getCode();
                String[] splits = prjName.split("_");
                transform = SRWKTTemplate.findTransFormByLon(Integer.parseInt(splits[splits.length - 1]));
            }
            list = new ArrayList();
            while (feature != null) {
                Iterator iterator = feature.getValue().iterator();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    Name name = property.getName();
                    Object value = property.getValue();
                    if ("the_geom".equals(name.toString())) {
                        Object geo = value;
                        if (transform != null) {
                            geo = JTS.transform((Geometry)((Geometry)value), (MathTransform)transform);
                        }
                        map.put(name.toString(), geo);
                        continue;
                    }
                    map.put(name.toString(), value);
                }
                list.add(map);
                feature = itertorF.hasNext() ? (SimpleFeature)itertorF.next() : null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map readTxt(File file) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, EncodingDetect.detect(file.getPath()));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        com.alibaba.fastjson.JSONObject xmxx = new com.alibaba.fastjson.JSONObject();
        JSONArray dkList = new JSONArray();
        xmxx.put("geometries", (Object)dkList);
        com.alibaba.fastjson.JSONObject curDk = null;
        JSONArray curRing = null;
        String curRingIndex = null;
        String text = null;
        while ((text = reader.readLine()) != null) {
            if ("".equals(text = text.trim())) continue;
            if (text.indexOf("=") > 0) {
                String[] pArry = text.split("=");
                if (pArry.length == 0) continue;
                String key = pArry[0];
                String value = null;
                if (pArry.length == 2) {
                    value = pArry[1];
                }
                xmxx.put(key, (Object)(value == null ? null : value.trim()));
                continue;
            }
            String[] pointArry = text.split(",");
            if (pointArry.length < 4) continue;
            boolean bLandStart = text.endsWith("@");
            if (bLandStart) {
                curRingIndex = "-1";
                curDk = new com.alibaba.fastjson.JSONObject();
                curDk.put("\u5730\u5757\u9762\u79ef", (Object)pointArry[1]);
                curDk.put("\u5730\u5757\u7f16\u53f7", (Object)pointArry[2]);
                curDk.put("\u5730\u5757\u540d\u79f0", (Object)pointArry[3]);
                curDk.put("\u56fe\u5f62\u7279\u5f81", (Object)pointArry[4]);
                curDk.put("\u56fe\u5e45\u53f7", (Object)pointArry[5]);
                curDk.put("\u571f\u5730\u7528\u9014", (Object)pointArry[6]);
                curDk.put("rings", (Object)new JSONArray());
                dkList.add((Object)curDk);
                continue;
            }
            String ringIndex = pointArry[1];
            String zbx = xmxx.get((Object)"\u5750\u6807\u7cfb").toString();
            int num = GaussXY2BL.Beijing54;
            num = zbx.contains("80") ? GaussXY2BL.Xian80 : num;
            num = zbx.contains("2000") ? GaussXY2BL.CGCS2000 : num;
            int mZoneWide = new Integer(xmxx.get((Object)"\u51e0\u5ea6\u5206\u5e26").toString());
            double[] cordinate = GaussXY2BL.GaussToBL(new Double(pointArry[3]), new Double(pointArry[2]), num, mZoneWide);
            if (!ringIndex.equals(curRingIndex)) {
                curRing = new JSONArray();
                JSONArray rings = curDk.getJSONArray("rings");
                rings.add((Object)curRing);
                curRingIndex = ringIndex;
            }
            curRing.add((Object)cordinate);
        }
        rtnMap.put("geoJsonMap", xmxx);
        rtnMap.put("status", "OK");
        return rtnMap;
    }

    public static Map readTxt2WKT(File file) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, EncodingDetect.detect(file.getPath()));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        com.alibaba.fastjson.JSONObject xmxx = new com.alibaba.fastjson.JSONObject();
        JSONArray dkList = new JSONArray();
        xmxx.put("geometries", (Object)dkList);
        com.alibaba.fastjson.JSONObject curDk = null;
        JSONArray curRing = null;
        String curRingIndex = null;
        String text = null;
        while ((text = reader.readLine()) != null) {
            if ("".equals(text = text.trim())) continue;
            if (text.indexOf("=") > 0) {
                String[] pArry = text.split("=");
                if (pArry.length == 0) continue;
                String key = pArry[0];
                String value = null;
                if (pArry.length == 2) {
                    value = pArry[1];
                }
                xmxx.put(key, (Object)(value == null ? null : value.trim()));
                continue;
            }
            String[] pointArry = text.split(",");
            if (pointArry.length < 4) continue;
            boolean bLandStart = text.endsWith("@");
            if (bLandStart) {
                curRingIndex = "-1";
                curDk = new com.alibaba.fastjson.JSONObject();
                curDk.put("jzds", (Object)(StringUtils.isEmpty((Object)pointArry[0]) ? 0 : Integer.parseInt(pointArry[0])));
                curDk.put("dkmj", (Object)(StringUtils.isEmpty((Object)pointArry[1]) ? 0.0 : Double.parseDouble(pointArry[1])));
                curDk.put("dkbh", (Object)pointArry[2]);
                curDk.put("dkmc", (Object)pointArry[3]);
                curDk.put("txsx", (Object)pointArry[4]);
                curDk.put("tfh", (Object)pointArry[5]);
                curDk.put("dkyt", (Object)pointArry[6]);
                if (pointArry.length > 9) {
                    curDk.put("yuliu", (Object)pointArry[7]);
                    curDk.put("tblx", (Object)pointArry[8]);
                    curDk.put("dlbm", (Object)pointArry[9]);
                    curDk.put("gzqpjzldb", (Object)(StringUtils.isEmpty((Object)pointArry[10]) ? 0.0 : Double.parseDouble(pointArry[10])));
                    curDk.put("gzhpjzldb", (Object)(StringUtils.isEmpty((Object)pointArry[11]) ? 0.0 : Double.parseDouble(pointArry[11])));
                    if (pointArry.length > 13) {
                        curDk.put("gddb", StringUtils.isEmpty((Object)pointArry[12]) ? null : Double.valueOf(Double.parseDouble(pointArry[12])));
                    }
                } else {
                    curDk.put("bz", (Object)pointArry[7]);
                }
                curDk.put("rings", (Object)new JSONArray());
                dkList.add((Object)curDk);
                continue;
            }
            String ringIndex = pointArry[1];
            String zbx = xmxx.get((Object)"\u5750\u6807\u7cfb").toString();
            double[] cordinate = new double[]{new Double(pointArry[2]), new Double(pointArry[3])};
            if (!zbx.contains("\u5730\u7406\u5750\u6807\u7cfb")) {
                int num = GaussXY2BL.Beijing54;
                num = zbx.contains("80") ? GaussXY2BL.Xian80 : num;
                num = zbx.contains("2000") ? GaussXY2BL.CGCS2000 : num;
                int mZoneWide = new Integer(xmxx.get((Object)"\u51e0\u5ea6\u5206\u5e26").toString());
                cordinate = GaussXY2BL.GaussToBL(new Double(pointArry[3]), new Double(pointArry[2]), num, mZoneWide);
            }
            if (!ringIndex.equals(curRingIndex)) {
                curRing = new JSONArray();
                JSONArray rings = curDk.getJSONArray("rings");
                rings.add((Object)curRing);
                curRingIndex = ringIndex;
            }
            curRing.add((Object)cordinate);
        }
        com.alibaba.fastjson.JSONObject curJSONOject = null;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        for (int i = 0; i < dkList.size(); ++i) {
            curJSONOject = (com.alibaba.fastjson.JSONObject)dkList.get(i);
            Geometry geo = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
            double akArea = geo.getArea();
            String wkt = geo.toText();
            curJSONOject.put("wkt", (Object)wkt);
            curJSONOject.put("DKAREA", (Object)akArea);
        }
        rtnMap.put("geoJsonMap", xmxx);
        rtnMap.put("fileType", "txt");
        rtnMap.put("status", "OK");
        return rtnMap;
    }

    public static Map readExcel2Wkt(File file) {
        Map<String, String> rtnMap = new HashMap<String, String>();
        List<List<Object>> excelDataList = null;
        try {
            excelDataList = ExcelUtil.readExcel(file, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", "Excel\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        if (!ShpUtils._validateExcel(excelDataList)) {
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", "Excel\u6a21\u677f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e\u518d\u5bfc\u5165\uff01");
        } else {
            rtnMap = ShpUtils._generateRecord(excelDataList);
        }
        return rtnMap;
    }

    private static Map _generateRecord(List<List<Object>> excelDataList) {
        com.alibaba.fastjson.JSONObject xmxx = new com.alibaba.fastjson.JSONObject();
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        JSONArray dkList = new JSONArray();
        xmxx.put("geometries", (Object)dkList);
        com.alibaba.fastjson.JSONObject curDk = null;
        JSONArray curRing = null;
        String curRingIndex = null;
        int num = GaussXY2BL.Beijing54;
        try {
            block7: for (int i = 0; i < excelDataList.size(); ++i) {
                List<Object> row = excelDataList.get(i);
                int colSize = row.size();
                if (colSize == 0) continue;
                String[] arr1 = null;
                String[] arr2 = null;
                String[] arr3 = null;
                switch (i) {
                    case 0: 
                    case 3: {
                        continue block7;
                    }
                    case 1: {
                        arr1 = row.get(0).toString().split("=");
                        arr2 = row.get(2).toString().split("=");
                        arr3 = row.get(4).toString().split("=");
                        if (arr1.length == 2) {
                            xmxx.put(arr1[0], (Object)arr1[1].trim());
                        }
                        if (arr2.length == 2) {
                            xmxx.put(arr2[0], (Object)arr2[1].trim());
                        }
                        if (arr3.length == 2) {
                            xmxx.put(arr3[0], (Object)arr3[1].trim());
                        }
                        xmxx.put(row.get(6).toString(), (Object)row.get(7).toString());
                        xmxx.put(row.get(8).toString(), (Object)row.get(9).toString());
                        continue block7;
                    }
                    case 2: {
                        xmxx.put(row.get(0).toString(), (Object)row.get(1).toString());
                        xmxx.put(row.get(2).toString(), (Object)row.get(3).toString());
                        xmxx.put(row.get(4).toString(), (Object)row.get(5).toString());
                        xmxx.put(row.get(6).toString(), (Object)row.get(7).toString());
                        continue block7;
                    }
                    default: {
                        if (colSize == 1) {
                            String[] pointArry = row.get(0).toString().split(",");
                            curRingIndex = "-1";
                            curDk = new com.alibaba.fastjson.JSONObject();
                            curDk.put("\u5730\u5757\u9762\u79ef", (Object)pointArry[1]);
                            curDk.put("\u5730\u5757\u7f16\u53f7", (Object)pointArry[2]);
                            curDk.put("\u5730\u5757\u540d\u79f0", (Object)pointArry[3]);
                            curDk.put("\u56fe\u5f62\u7279\u5f81", (Object)pointArry[4]);
                            curDk.put("\u56fe\u5e45\u53f7", (Object)pointArry[5]);
                            curDk.put("\u571f\u5730\u7528\u9014", (Object)pointArry[6]);
                            curDk.put("rings", (Object)new JSONArray());
                            dkList.add((Object)curDk);
                            continue block7;
                        }
                        if (colSize != 4) continue block7;
                        String ringIndex = "1";
                        String zbx = xmxx.get((Object)"\u5750\u6807\u7cfb").toString();
                        double[] cordinate = new double[]{new Double(row.get(2).toString()), new Double(row.get(3).toString())};
                        if (!zbx.contains("\u5730\u7406\u5750\u6807\u7cfb")) {
                            num = zbx.contains("80") ? GaussXY2BL.Xian80 : num;
                            num = zbx.contains("2000") ? GaussXY2BL.CGCS2000 : num;
                            int mZoneWide = new Integer(xmxx.get((Object)"\u51e0\u5ea6\u5206\u5e26").toString());
                            cordinate = GaussXY2BL.GaussToBL(new Double(row.get(3).toString()), new Double(row.get(2).toString()), num, mZoneWide);
                        }
                        if (!ringIndex.equals(curRingIndex)) {
                            curRing = new JSONArray();
                            JSONArray rings = curDk.getJSONArray("rings");
                            rings.add((Object)curRing);
                            curRingIndex = ringIndex;
                        }
                        curRing.add((Object)cordinate);
                    }
                }
            }
            com.alibaba.fastjson.JSONObject curJSONOject = null;
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            for (int i = 0; i < dkList.size(); ++i) {
                curJSONOject = (com.alibaba.fastjson.JSONObject)dkList.get(i);
                Geometry geo = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
                String wkt = geo.toText();
                curJSONOject.put("wkt", (Object)wkt);
            }
            rtnMap.put("geoJsonMap", xmxx);
            rtnMap.put("fileType", "txt");
            rtnMap.put("status", "OK");
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            rtnMap.put("status", "FAILURE");
            if (errMsg.indexOf("LinearRing") > 0) {
                rtnMap.put("message", "\u9762\u72b6\u56fe\u5f62\u5750\u6807\u6709\u4e0d\u5c01\u95ed\u60c5\u51b5\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            rtnMap.put("message", "Excel\u5750\u6807\u683c\u5f0f\u6709\u8bef\u3001\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        return rtnMap;
    }

    private static boolean _validateExcel(List<List<Object>> excelDataList) {
        boolean result = true;
        for (int i = 0; i < excelDataList.size(); ++i) {
            List<Object> row = excelDataList.get(i);
            if (i == 2 && row.size() != 10) {
                result = false;
                continue;
            }
            if (i == 4 && row.size() != 1) {
                result = false;
                continue;
            }
            if (i != 5 || row.size() == 4) continue;
            result = false;
        }
        return result;
    }

    private static Geometry dk2Geometry(com.alibaba.fastjson.JSONObject dkJSONObj, GeometryFactory geometryFactory) {
        JSONArray dkRings = (JSONArray)dkJSONObj.get((Object)"rings");
        Object dkGeometry = null;
        for (int j = 0; j < dkRings.size(); ++j) {
            JSONArray ring = (JSONArray)dkRings.get(j);
            Coordinate[] coords = new Coordinate[ring.size()];
            for (int k = 0; k < ring.size(); ++k) {
                Coordinate coord;
                double[] cordinate = (double[])ring.get(k);
                coords[k] = coord = new Coordinate(cordinate[0], cordinate[1]);
            }
            Polygon polygon = geometryFactory.createPolygon(coords);
            dkGeometry = dkGeometry == null ? polygon : (dkGeometry.contains((Geometry)polygon) ? dkGeometry.difference((Geometry)polygon) : dkGeometry.union((Geometry)polygon));
        }
        return dkGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry lonlat2WebMactor(Geometry geom, String prjpath) {
        try {
            CoordinateReferenceSystem crs = null;
            File prjFile = new File(prjpath);
            if (prjFile.exists()) {
                try (FileInputStream instream = null;){
                    instream = new FileInputStream(prjFile);
                    FileChannel channel = instream.getChannel();
                    PrjFileReader reader = new PrjFileReader((ReadableByteChannel)channel);
                    crs = reader.getCoordinateReferenceSystem();
                    reader.close();
                }
            }
            CoordinateReferenceSystem crs2000 = CRS.parseWKT((String)"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]");
            MathTransform transform = CRS.findMathTransform(crs, (CoordinateReferenceSystem)crs2000);
            return JTS.transform((Geometry)geom, (MathTransform)transform);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map readTxt2WKTWithoutProj(File file) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, EncodingDetect.detect(file.getPath()));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        com.alibaba.fastjson.JSONObject xmxx = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        JSONArray dkList = new JSONArray();
        xmxx.put("geometries", (Object)dkList);
        xmxx.put("spatialInfo", (Object)jsonObject);
        com.alibaba.fastjson.JSONObject curDk = null;
        JSONArray curRing = null;
        String curRingIndex = null;
        String text = null;
        Integer cordCount = 0;
        while ((text = reader.readLine()) != null) {
            Integer rings;
            if ("".equals(text = text.trim())) continue;
            if (text.indexOf("=") > 0) {
                String[] pArry = text.split("=");
                if (pArry.length == 0) continue;
                String key = pArry[0];
                String value = null;
                if (pArry.length == 2) {
                    value = pArry[1];
                }
                jsonObject.put(key, (Object)(value == null ? null : value.trim()));
                continue;
            }
            String[] pointArry = text.split(",");
            if (pointArry.length < 4) continue;
            boolean bLandStart = text.endsWith("@");
            if (bLandStart) {
                curRingIndex = "-1";
                curDk = new com.alibaba.fastjson.JSONObject();
                curDk.put("\u5730\u5757\u9762\u79ef", (Object)pointArry[1]);
                curDk.put("\u5730\u5757\u53f7", (Object)pointArry[2]);
                curDk.put("\u5730\u5757\u540d\u79f0", (Object)pointArry[3]);
                curDk.put("\u56fe\u5f62\u5c5e\u6027", (Object)pointArry[4]);
                curDk.put("\u56fe\u5e45\u53f7", (Object)pointArry[5]);
                curDk.put("\u7528\u9014", (Object)pointArry[6]);
                curDk.put("\u5907\u6ce8", (Object)pointArry[7]);
                curDk.put("\u56fe\u6591\u7c7b\u578b", (Object)pointArry[8]);
                curDk.put("\u5730\u7c7b", (Object)pointArry[9]);
                curDk.put("\u5e73\u5747\u8d28\u91cf\u7b49\u522b", (Object)pointArry[10]);
                curDk.put("\u6539\u9020\u540e\u5e73\u5747\u8d28\u91cf\u7b49\u522b", (Object)pointArry[11]);
                curDk.put("rings", (Object)new JSONArray());
                dkList.add((Object)curDk);
                continue;
            }
            String ringIndex = pointArry[1];
            String zbx = jsonObject.get((Object)"\u5750\u6807\u7cfb").toString();
            double[] cordinate = new double[]{new Double(pointArry[2]), new Double(pointArry[3])};
            if (!ringIndex.equals(curRingIndex)) {
                curRing = new JSONArray();
                rings = curDk.getJSONArray("rings");
                rings.add(curRing);
                curRingIndex = ringIndex;
            }
            curRing.add((Object)cordinate);
            rings = cordCount;
            Integer n = cordCount = Integer.valueOf(cordCount + 1);
        }
        xmxx.put("cordCount", (Object)cordCount);
        String prjType = jsonObject.getString("\u6295\u5f71\u7c7b\u578b");
        Integer projNo = jsonObject.getInteger("\u5e26\u53f7");
        MathTransform transform = null;
        if (prjType != null && projNo != null) {
            transform = SRWKTTemplate.findTransFormByLon(projNo);
        }
        com.alibaba.fastjson.JSONObject curJSONOject = null;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        for (int i = 0; i < dkList.size(); ++i) {
            curJSONOject = (com.alibaba.fastjson.JSONObject)dkList.get(i);
            Geometry geo = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
            double akArea = geo.getArea();
            JSONArray rings = curJSONOject.getJSONArray("rings");
            JSONArray ringsNew = new JSONArray();
            for (int m = 0; m < rings.size(); ++m) {
                JSONArray ring = rings.getJSONArray(m);
                JSONArray ringNew = new JSONArray();
                for (int n = 0; n < ring.size(); ++n) {
                    double[] cord = (double[])ring.get(n);
                    Point sourcePoint = geometryFactory.createPoint(new Coordinate(cord[1], cord[0]));
                    Point targetPoint = (Point)JTS.transform((Geometry)sourcePoint, (MathTransform)transform);
                    ringNew.add((Object)new double[]{targetPoint.getX(), targetPoint.getY()});
                }
                ringsNew.add((Object)ringNew);
            }
            curJSONOject.put("rings", (Object)ringsNew);
            Geometry geoCGS = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
            String wkt = geoCGS.toText();
            curJSONOject.put("wkt", (Object)wkt);
            curJSONOject.put("DKAREA", (Object)akArea);
        }
        rtnMap.put("geoJsonMap", xmxx);
        rtnMap.put("fileType", "txt");
        rtnMap.put("status", "OK");
        return rtnMap;
    }

    public static void deleteFile(File ... files) {
        for (File file : files) {
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public static Map<String, Object> getShpCRSInfo(String pathName) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            File file = new File(pathName);
            FileDataStore dataStore = FileDataStoreFinder.getDataStore((File)file);
            SimpleFeatureSource simpleFeatureSource = dataStore.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = simpleFeatureSource.getFeatures();
            SimpleFeatureIterator featureIterator = simpleFeatureCollection.features();
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            GeometryAttribute geometryAttribute = feature.getDefaultGeometryProperty();
            CoordinateReferenceSystem coordinateReferenceSystem = geometryAttribute.getDescriptor().getCoordinateReferenceSystem();
            if (coordinateReferenceSystem == null) {
                return result;
            }
            String srcStr = coordinateReferenceSystem.toWKT();
            String projcs = null;
            String protype = "\u65e0";
            String degress = "N/A";
            String degressno = "N/A";
            if (srcStr.startsWith("PROJCS")) {
                int i = srcStr.indexOf(",");
                projcs = srcStr.substring(8, i - 1);
                String[] projcsSpt = projcs.split("_");
                degress = projcsSpt[1];
                degressno = projcsSpt[5];
                int j = srcStr.indexOf("PROJECTION");
                String sub1 = srcStr.substring(j);
                protype = sub1.substring(12, sub1.indexOf(",") - 2);
            }
            int m = srcStr.indexOf("Greenwich");
            String sub2 = srcStr.substring(m);
            String Greenwich = sub2.substring(sub2.indexOf(",") + 1, sub2.indexOf("]"));
            int n = srcStr.indexOf("degree");
            String sub3 = srcStr.substring(n);
            String degree = sub3.substring(sub3.indexOf(",") + 1, sub3.indexOf("]"));
            result.put("protype", protype);
            result.put("srcname", coordinateReferenceSystem.getName().getCode());
            result.put("degress", degress);
            result.put("degressno", degressno);
            result.put("greenwich", Greenwich);
            result.put("degree", degree);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> validatePropKeys(SimpleFeatureSource featureSource, List<String> requiredKeyList) {
        ArrayList<String> result = new ArrayList<String>();
        try (SimpleFeatureIterator itertor = featureSource.getFeatures().features();){
            if (!itertor.hasNext()) return result;
            SimpleFeature feature = (SimpleFeature)itertor.next();
            Collection propsCollection = feature.getProperties();
            List<String> propKeyList = propsCollection.stream().map(i -> i.getName().toString()).collect(Collectors.toList());
            List<String> list2 = ShpUtils.subList2(requiredKeyList, propKeyList);
            itertor.close();
            List<String> list = list2;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static List<String> subList2(List<String> list1, List<String> list2) {
        Map tempMap = list2.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
        return list1.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
    }

    public static Charset getCharsetFromCpg(String cpgPath) {
        Path path = Paths.get(cpgPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return Charset.defaultCharset();
        }
        try {
            String encoding = new String(Files.readAllBytes(path), StandardCharsets.UTF_8).trim();
            if (encoding.isEmpty()) {
                return null;
            }
            Charset charset = ENCODING_MAPPING.get(encoding.toUpperCase());
            if (charset != null) {
                return charset;
            }
            if (encoding.startsWith("ANSI")) {
                return Charset.forName("GBK");
            }
            return Charset.forName(encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ENCODING_MAPPING.put("UTF-8", StandardCharsets.UTF_8);
        ENCODING_MAPPING.put("UTF-16", StandardCharsets.UTF_16);
        ENCODING_MAPPING.put("ISO-8859-1", StandardCharsets.ISO_8859_1);
        ENCODING_MAPPING.put("GBK", Charset.forName("GBK"));
        ENCODING_MAPPING.put("GB2312", Charset.forName("GB2312"));
        ENCODING_MAPPING.put("GB18030", Charset.forName("GB18030"));
        ENCODING_MAPPING.put("936", Charset.forName("GBK"));
        ENCODING_MAPPING.put("CP936", Charset.forName("GBK"));
        ENCODING_MAPPING.put("ANSI 936", Charset.forName("GBK"));
        ENCODING_MAPPING.put("1252", Charset.forName("Windows-1252"));
        ENCODING_MAPPING.put("1251", Charset.forName("Windows-1251"));
        ENCODING_MAPPING.put("1250", Charset.forName("Windows-1250"));
    }
}

