/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelGroupService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.metadata.vo.ModelCheckResult;
import com.geoway.base.support.QueryParamManageUtil;
import com.geoway.base.support.QueryParamRes;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumStatType;
import com.geoway.onemap.zbph.domain.base.EntityCheckResult;
import com.geoway.onemap.zbph.domain.base.ExcelTemplate;
import com.geoway.onemap.zbph.service.base.AbstractEntityService;
import com.geoway.onemap.zbph.service.base.ExcelTemplateService;
import com.geoway.onemap.zbph.supoort.EasyExcelUtil;
import com.geoway.onemap.zbph.supoort.EasyShpUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class AbstractEntityServiceImpl<T extends HashMap>
implements AbstractEntityService<T> {
    @Override
    public abstract String getTableName();

    @Override
    public List<String> findPreCurNextIds(String filterParam, String sortParam, String curId) {
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        ModelFields field = modelFieldsService.findByTableNamePrimary(this.getTableName());
        if (field == null) {
            throw new RuntimeException("\u672a\u5b9a\u4e49\u4e3b\u952e\u5b57\u6bb5", new Exception());
        }
        String primaryFieldName = field.getFieldName();
        return this.findPreCurNextIds(filterParam, sortParam, curId, primaryFieldName);
    }

    @Override
    public void deleteByid(String xmid) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        modelManageService.delObjectById(this.getTableName(), xmid);
    }

    @Override
    public void deleteByFilter(String filter) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        QueryParamRes paramRes = this.praseFilterParam(filter);
        modelManageService.delObject(this.getTableName(), paramRes.getWhere(), paramRes.getValues());
    }

    protected List<String> findPreCurNextIds(String filterParam, String sortParam, String curId, String primaryFieldName) {
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        if (StrUtil.isBlank((CharSequence)(sortParam = this.praseSortParam(sortParam)))) {
            sortParam = "order by " + primaryFieldName;
        }
        String where = "where 1=1";
        if (StrUtil.isNotBlank((CharSequence)paramRes.getWhere())) {
            where = where + "  and  " + paramRes.getWhere();
        }
        String idRowNumberSql = String.format("select %s,row_number() OVER (%s) from  %s %s", primaryFieldName, sortParam, this.getTableName(), where);
        String curSql = String.format("select %s from (%s) t where %s='%s' ", primaryFieldName, idRowNumberSql, primaryFieldName, curId);
        String preSql = String.format("select s.%s from (%s) s  where s.row_number in (select row_number-1 as  row_number from (%s) t where t.%s='%s')  ", primaryFieldName, idRowNumberSql, idRowNumberSql, primaryFieldName, curId);
        String nextSql = String.format("select s.%s from (%s) s where s.row_number in (select row_number+1 as  row_number from (%s) t where t.%s='%s') ", primaryFieldName, idRowNumberSql, idRowNumberSql, primaryFieldName, curId);
        String querySql = preSql + "  union  all  " + curSql + "  union all  " + nextSql;
        ArrayList objects = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            objects.addAll(Arrays.stream(paramRes.getValues()).collect(Collectors.toList()));
        }
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        List results = modelManageService.findList(querySql, objects.toArray());
        return results.stream().map(f -> f.values().stream().findFirst().orElse(null).toString()).collect(Collectors.toList());
    }

    @Override
    public void exportExcel(HttpServletResponse response, String fileName, String filterParam, String sortParam, String groupCode, Map<String, Map> map, String templateName) {
        this.exportExcel(response, fileName, filterParam, sortParam, groupCode, map, templateName, new LinkedHashMap<String, String>());
    }

    @Override
    public void exportExcel(HttpServletResponse response, String fileName, String filterParam, String sortParam, String groupCode, Map<String, Map> map, String templateName, LinkedHashMap<String, String> fieldMap) {
        try {
            String templatePath;
            ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
            ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
            ModelGroupService groupService = (ModelGroupService)SpringContextUtil.getBean(ModelGroupService.class);
            String tableName = this.getTableName();
            if (StrUtil.isBlank((CharSequence)templateName) && FileUtil.exist((String)(templatePath = ConfigConstant.FileConfig.templateDir + File.separator + tableName + ".xlsx"))) {
                templateName = tableName;
            }
            if (StrUtil.isNotBlank((CharSequence)templateName)) {
                ExcelTemplateService excelTemplateService = (ExcelTemplateService)SpringContextUtil.getBean(ExcelTemplateService.class);
                ExcelTemplate excelTemplate = excelTemplateService.findByName(templateName);
                tableName = excelTemplate != null && StrUtil.isNotBlank((CharSequence)excelTemplate.getTableName()) ? excelTemplate.getTableName() : tableName;
                groupCode = "";
            }
            if (fieldMap != null && fieldMap.size() > 0) {
                groupCode = "";
            }
            QueryParamRes paramRes = this.praseFilterParam(filterParam);
            List<Map<String, Object>> list = modelManageService.findListPage(tableName, groupCode, paramRes.getWhere(), paramRes.getValues(), this.praseSortParam(sortParam));
            list = this.resetObjects(list, map);
            if (StrUtil.isBlank((CharSequence)templateName)) {
                List<ModelFields> fields = null;
                if (fieldMap != null && fieldMap.size() > 0) {
                    fields = new ArrayList();
                    for (Map.Entry<String, String> kv : fieldMap.entrySet()) {
                        ModelFields modelFields = new ModelFields();
                        modelFields.setAlias(kv.getValue());
                        modelFields.setFieldName(kv.getKey());
                        fields.add(modelFields);
                    }
                } else {
                    fields = groupService.findModelFields(tableName, groupCode);
                    if (fields.size() == 0) {
                        fields = modelFieldsService.findByTableName(tableName);
                    }
                }
                ArrayList<List<String>> heads = new ArrayList<List<String>>();
                ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
                for (ModelFields modelFields : fields) {
                    ArrayList<String> temp = new ArrayList<String>();
                    if (fieldMap != null && fieldMap.containsKey(modelFields.getFieldName())) {
                        temp.add(fieldMap.get(modelFields.getFieldName()));
                    } else {
                        temp.add(modelFields.getAlias());
                    }
                    if (temp.size() <= 0) continue;
                    heads.add(temp);
                }
                for (Map map2 : list) {
                    ArrayList objects = new ArrayList();
                    for (ModelFields field : fields) {
                        Object object = map2.get(field.getFieldName());
                        if (fieldMap == null) {
                            objects.add(object);
                            continue;
                        }
                        objects.add(object);
                    }
                    datas.add(objects);
                }
                EasyExcelUtil.createExcel(response, fileName, heads, datas);
            } else {
                String templatePath2 = ConfigConstant.FileConfig.templateDir + File.separator + templateName + ".xlsx";
                if (!FileUtil.exist((String)templatePath2)) {
                    throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", new Exception());
                }
                EasyExcelUtil.createExcel(response, fileName, templatePath2, list);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private List<Map<String, Object>> resetObjects(List<Map<String, Object>> list, Map<String, Map> map) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> objectMap : list) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            for (Map.Entry<String, Object> kv : objectMap.entrySet()) {
                Object object = kv.getValue();
                if (ObjectUtil.isNotNull((Object)object) && map != null && map.containsKey(kv.getKey())) {
                    if (object instanceof String) {
                        String[] strs = object.toString().split(",");
                        ArrayList<String> repalceResults = new ArrayList<String>();
                        for (String str : strs) {
                            if (map.get(kv.getKey()).containsKey(str)) {
                                repalceResults.add(map.get(kv.getKey()).get(str).toString());
                                continue;
                            }
                            repalceResults.add(str);
                        }
                        object = String.join((CharSequence)",", repalceResults);
                    } else if (map.get(kv.getKey()).containsKey(object)) {
                        object = map.get(kv.getKey()).get(object);
                    }
                }
                if (object instanceof Date) {
                    temp.put(kv.getKey(), DateUtil.format((Date)((Date)object), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                temp.put(kv.getKey(), object);
            }
            results.add(temp);
        }
        return results;
    }

    @Override
    public void exportShp(HttpServletResponse response, String fileName, String filterParam, String sortParam, String groupCode, Map<String, Map> map) {
        this.exportShp(response, fileName, filterParam, sortParam, groupCode, map, null);
    }

    @Override
    public void exportShp(HttpServletResponse response, String fileName, String filterParam, String sortParam, String groupCode, Map<String, Map> valueMap, Map<String, String> fieldMap) {
        try {
            ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
            ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
            ModelGroupService groupService = (ModelGroupService)SpringContextUtil.getBean(ModelGroupService.class);
            QueryParamRes paramRes = this.praseFilterParam(filterParam);
            List list = modelManageService.findListPage(this.getTableName(), groupCode, paramRes.getWhere(), paramRes.getValues(), this.praseSortParam(sortParam));
            List fields = null;
            fields = StringUtils.isNotBlank((CharSequence)groupCode) ? groupService.findModelFields(this.getTableName(), groupCode) : modelFieldsService.findByTableName(this.getTableName());
            if (fields.size() == 0) {
                fields = modelFieldsService.findByTableName(this.getTableName());
            }
            for (Map objectMap : list) {
                for (ModelFields field : fields) {
                    Object object = objectMap.get(field.getFieldName());
                    if (!ObjectUtil.isNotNull(object) || valueMap == null || !valueMap.containsKey(field.getFieldName()) || !valueMap.get(field.getFieldName()).containsKey(object)) continue;
                    objectMap.put(field.getFieldName(), valueMap.get(field.getFieldName()).get(object));
                }
            }
            EasyShpUtil easyShpUtil = new EasyShpUtil();
            if (fieldMap == null) {
                fieldMap = new HashMap<String, String>();
            }
            easyShpUtil.write(list, "wkt", fields, fieldMap, fileName, response);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public List<Map<String, Object>> stat(String filterParam, Map<String, EnumStatType> statFields, String ... groupField) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        ArrayList<String> selectFields = new ArrayList<String>();
        List<Object> groupFields = new ArrayList();
        if (groupField.length > 0) {
            groupFields = Arrays.stream(groupField).collect(Collectors.toList());
        }
        selectFields.addAll(Arrays.stream(groupField).collect(Collectors.toList()));
        for (Map.Entry<String, EnumStatType> statField : statFields.entrySet()) {
            switch (statField.getValue()) {
                case Count: {
                    selectFields.add(String.format("count(%s)::int4 as %s_count", statField.getKey(), statField.getKey()));
                    break;
                }
                case Max: {
                    selectFields.add(String.format("max(%s) as %s_max", statField.getKey(), statField.getKey()));
                    break;
                }
                case Min: {
                    selectFields.add(String.format("min(%s) as %s_min", statField.getKey(), statField.getKey()));
                    break;
                }
                case Avg: {
                    selectFields.add(String.format("avg(%s) as %s_avg", statField.getKey(), statField.getKey()));
                    break;
                }
                case Sum: {
                    selectFields.add(String.format("sum(%s) as %s_sum", statField.getKey(), statField.getKey()));
                    break;
                }
                case WeightAvg: {
                    String[] fields = statField.getKey().split(",");
                    if (fields.length != 2) {
                        throw new RuntimeException("\u52a0\u6743\u5e73\u5747\u5fc5\u987b\u5f97\u914d\u7f6e\u4e24\u4e2a\u5b57\u6bb5");
                    }
                    selectFields.add(String.format("case sum(%s) when 0 then 0 else sum(%s*%s)/sum(%s) end as \"%s_weigthavg\"", fields[1], fields[0], fields[1], fields[1], statField.getKey()));
                }
            }
        }
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        String where = "";
        if (!StrUtil.isBlank((CharSequence)paramRes.getWhere()) && !paramRes.getWhere().startsWith("and")) {
            where = " and " + paramRes.getWhere();
        }
        String sql = "";
        selectFields.removeIf(f -> StrUtil.isBlank((CharSequence)f));
        groupFields.removeIf(f -> StrUtil.isBlank((CharSequence)f));
        sql = groupFields.size() == 0 ? String.format("select %s from %s where 1=1 %s", String.join((CharSequence)",", selectFields), this.getTableName(), where) : String.format("select %s from %s where 1=1 %s group by %s", String.join((CharSequence)",", selectFields), this.getTableName(), where, String.join((CharSequence)",", groupFields));
        return modelManageService.findList(sql, paramRes.getValues());
    }

    @Override
    public Long queryTotal(String filterParam) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        return modelManageService.countAll(this.getTableName(), paramRes.getWhere(), paramRes.getValues());
    }

    @Override
    public List<ModelFields> findGroupFields(String groupCode) {
        if (StrUtil.isNotBlank((CharSequence)groupCode)) {
            ModelGroupService groupService = (ModelGroupService)SpringContextUtil.getBean(ModelGroupService.class);
            return groupService.findModelFields(this.getTableName(), groupCode);
        }
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        return list;
    }

    @Override
    public List<ModelFields> findFields() {
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        return list;
    }

    protected QueryParamRes praseFilterParam(String filterParam) {
        return QueryParamManageUtil.parseQueryFilterParams((String)filterParam);
    }

    protected String praseSortParam(String sortParam) {
        return QueryParamManageUtil.parseSortParams((String)sortParam);
    }

    private String saveOrUpdate(T xmxx, SysUser sysUser, List<ModelFields> list, String primaryFieldName, Boolean checkValid) {
        try {
            ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
            if (((HashMap)xmxx).containsKey(primaryFieldName) && ((HashMap)xmxx).get(primaryFieldName) != null) {
                modelManageService.updateModel(xmxx, list, this.getTableName());
                return ((HashMap)xmxx).get(primaryFieldName).toString();
            }
            ((HashMap)xmxx).put((String)primaryFieldName, (String)UUID.randomUUID().toString());
            Object object = modelManageService.saveModel(xmxx, this.getTableName(), list, sysUser.getId(), checkValid.booleanValue());
            return object.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public void saveOrUpdate(T xmxx, SysUser sysUser) {
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        ModelFields primaryField = list.stream().filter(f -> f.getIsPrimary() == 1).findAny().orElse(null);
        if (primaryField == null) {
            throw new RuntimeException(String.format("\u3010%s\u3011\u8868\u672a\u914d\u7f6e\u4e3b\u952e", this.getTableName()));
        }
        this.saveOrUpdate(xmxx, sysUser, list, primaryField.getFieldName(), false);
    }

    @Override
    public void batchSaveOrUpdate(Iterable<T> xmxxs, SysUser sysUser) {
        this.batchSaveOrUpdate(xmxxs, sysUser, false);
    }

    @Override
    public void batchSaveOrUpdate(Iterable<T> xmxxs, SysUser sysUser, boolean checkValid) {
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        ModelFields primaryField = list.stream().filter(f -> f.getIsPrimary() == 1).findAny().orElse(null);
        if (primaryField == null) {
            throw new RuntimeException(String.format("\u3010%s\u3011\u8868\u672a\u914d\u7f6e\u4e3b\u952e", this.getTableName()));
        }
        for (HashMap xmxx : xmxxs) {
            this.saveOrUpdate(xmxx, sysUser, list, primaryField.getFieldName(), checkValid);
        }
    }

    @Override
    public EntityCheckResult checkValid(T xmxx) {
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        return this.checkValid(xmxx, (List<ModelFields>)list);
    }

    @Override
    public EntityCheckResult checkValid(T xmxx, List<ModelFields> list) {
        EntityCheckResult<T> entityCheckResult = new EntityCheckResult<T>();
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        ModelCheckResult modelCheckResult = modelManageService.checkValid(this.getTableName(), xmxx, list);
        entityCheckResult.setData(xmxx);
        entityCheckResult.setMsg(modelCheckResult.getMsg());
        entityCheckResult.setValid(modelCheckResult.isValid());
        return entityCheckResult;
    }

    @Override
    public Page<T> findPageByFilter(String filterParam, String sortParam, String groupCode, int start, int limit) {
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        Page pageList = modelManageService.findPageList(this.getTableName(), groupCode, paramRes.getWhere(), paramRes.getValues(), this.praseSortParam(sortParam), limit, start);
        ArrayList convertResult = new ArrayList();
        pageList.getContent().forEach(f -> convertResult.add(this.convertFromMap((Map<String, Object>)f)));
        PageImpl pageResult = new PageImpl(convertResult, (Pageable)PageRequest.of((int)pageList.getNumber(), (int)pageList.getSize()), pageList.getTotalElements());
        return pageResult;
    }

    @Override
    public T findOne(String filterParam) {
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        Map objectMap = modelManageService.findOne(this.getTableName(), " and " + paramRes.getWhere(), paramRes.getValues());
        return (T)((HashMap)this.convertFromMap(objectMap));
    }

    @Override
    public T findById(String xmid) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        Map mapObject = modelManageService.findObject(this.getTableName(), xmid, "");
        if (mapObject == null) {
            return null;
        }
        return (T)((HashMap)this.convertFromMap(mapObject));
    }

    @Override
    public List<T> findByFilter(String filterParam) {
        return this.findByFilter(filterParam, null);
    }

    @Override
    public List<T> findByFilter(String filterParam, List<String> fields) {
        ArrayList result = new ArrayList();
        ModelFieldsService modelFieldsService = (ModelFieldsService)SpringContextUtil.getBean(ModelFieldsService.class);
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        List list = modelFieldsService.findByTableName(this.getTableName());
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        if (fields != null && fields.size() > 0) {
            list = list.stream().filter(f -> fields.stream().filter(g -> g.toLowerCase().equals(f.getFieldName().toLowerCase())).count() > 0L).collect(Collectors.toList());
        }
        List resultList = modelManageService.findListPage(this.getTableName(), list, paramRes.getWhere(), paramRes.getValues(), "");
        for (Map mapObject : resultList) {
            result.add(this.convertFromMap(mapObject));
        }
        return result;
    }

    @Override
    public List<T> findByFilter(String filterParam, String sortParam, String groupCode) {
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        ArrayList result = new ArrayList();
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        List list = modelManageService.findListPage(this.getTableName(), groupCode, paramRes.getWhere(), paramRes.getValues(), this.praseSortParam(sortParam));
        for (Map mapObject : list) {
            result.add(this.convertFromMap(mapObject));
        }
        return result;
    }
}

