/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.geoway.onemap.zbph.dao.base.SpaceBaseRepository;
import com.geoway.onemap.zbph.domain.base.BaseSpaceBlock;
import com.geoway.onemap.zbph.service.base.SpaceBaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSpaceBaseServiceImpl<T extends BaseSpaceBlock, R extends SpaceBaseRepository>
implements SpaceBaseService<T> {
    private R repository;

    public AbstractSpaceBaseServiceImpl(R repository) {
        this.repository = repository;
    }

    @Override
    public List findByPid(String pid) {
        return this.repository.findByXmid(pid);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCover(List list, String pid) {
        ArrayList saveList = new ArrayList();
        if (list != null) {
            list.forEach(f -> {
                BaseSpaceBlock t = (BaseSpaceBlock)f;
                if (StringUtils.isEmpty((CharSequence)t.getId())) {
                    t.setId(UUID.randomUUID().toString());
                    saveList.add(t);
                }
            });
        }
        if (!saveList.isEmpty()) {
            this.repository.deleteByXmid(pid);
            this.repository.saveAll(saveList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPid(String pid) {
        this.repository.deleteByXmid(pid);
    }
}

