/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkhandler.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbtj.Zbhj;
import com.geoway.onemap.zbph.domain.zbtj.ZbhjMx;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkSubtractionHandler;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbtj.hj.impl.ZbhjMxServiceImpl;
import com.geoway.onemap.zbph.service.zbtj.hj.impl.ZbhjServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZbkSubtractionHandlerImpl
implements ZbkSubtractionHandler {
    private static final Logger log = LoggerFactory.getLogger(ZbkSubtractionHandlerImpl.class);
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private ZbhjServiceImpl zbhjService;
    @Autowired
    private ZbhjMxServiceImpl zbhjMxService;

    @Override
    public String subtraction(List<ZbhjMx> zbhjmxs, Zbhj zbhj, SysUser sysUser) {
        log.info("\u6307\u6807\u6838\u51cf\u903b\u8f91");
        ArrayList<ZBKOutputDTO> outputDTOS = new ArrayList<ZBKOutputDTO>();
        for (ZbhjMx zbhjMx : zbhjmxs) {
            ZBKOutputDTO zbkOutputDTO = new ZBKOutputDTO();
            ZBKDKDetail zbkdkDetail = this.zbkdkDetailService.findById(zbhjMx.getZbid(), false);
            zbkOutputDTO.setCzlx(EnumZBKOutputType.BCGDHJCK.toValue());
            zbkOutputDTO.setCzxzqdm(sysUser.getXzqdm());
            zbkOutputDTO.setCzxzqmc(sysUser.getFullXzqmc());
            zbkOutputDTO.setUserid(sysUser.getId());
            zbkOutputDTO.setUsername(sysUser.getAlisname());
            zbkOutputDTO.setXmbh(zbkdkDetail.getXmbh());
            zbkOutputDTO.setXmmc(zbkdkDetail.getXmmc());
            zbkOutputDTO.setGdmj(zbhjMx.getHjzbgm());
            zbkOutputDTO.setStmj(zbhjMx.getHjstgm());
            zbkOutputDTO.setCnzb(zbhjMx.getHjlscn());
            zbkOutputDTO.setZbid(zbhjMx.getZbid());
            zbkOutputDTO.setZbkdkDetail(zbkdkDetail);
            outputDTOS.add(zbkOutputDTO);
        }
        String lsh = this.zbkManagerService.output(outputDTOS);
        zbhj.setHjlsh(lsh);
        this.zbhjService.saveOrUpdate(zbhj, sysUser);
        for (ZbhjMx zbhjMx : zbhjmxs) {
            zbhjMx.setSid(lsh);
        }
        this.zbhjMxService.batchInsertOrUpdate(zbhj.getXmid(), zbhjmxs);
        return lsh;
    }

    @Override
    public String revert(Zbhj zbhj, SysUser sysUser) {
        return "";
    }
}

