/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbtj.hj.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetailGC;
import com.geoway.onemap.zbph.domain.zbtj.Zbhj;
import com.geoway.onemap.zbph.domain.zbtj.ZbhjMx;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.dto.zbtj.ZbtjZbhjDTO;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOperateDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailGCService;
import com.geoway.onemap.zbph.service.zbtj.hj.ZbhjManageService;
import com.geoway.onemap.zbph.service.zbtj.hj.ZbhjService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbhjManageServiceImpl
extends AbstractXmxxManagerServiceImpl<ZbtjZbhjDTO, Zbhj, ZbhjService>
implements ZbhjManageService {
    private static final Logger log = LoggerFactory.getLogger(ZbhjManageServiceImpl.class);
    @Autowired
    protected ZBKOutputDetailGCService zbkOutputDetailGCService;
    @Autowired
    protected ZBKOperateDetailService zbkOperateDetailService;
    @Autowired
    private ZBKManagerService zbkManagerService;

    public ZbhjManageServiceImpl(ZbhjService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(ZbtjZbhjDTO xmxxDto, SysUser sysUser) {
        long start = System.currentTimeMillis();
        this.unlockZbk(((Zbhj)xmxxDto.getXmxx()).getHjlsh(), (Zbhj)xmxxDto.getXmxx(), false);
        ((Zbhj)xmxxDto.getXmxx()).setXmmc(UUID.randomUUID().toString());
        String lockLsh = this.lockZbk(xmxxDto);
        Zbhj zbhj = (Zbhj)xmxxDto.getXmxx();
        zbhj.setHjlsh(lockLsh);
        xmxxDto.setXmxx(zbhj);
        ArrayList<ZbhjMx> newHjmxList = new ArrayList<ZbhjMx>();
        List<ZbhjMx> hjmxList = xmxxDto.getHjmx();
        if (hjmxList.size() > 0) {
            for (ZbhjMx hjmx : hjmxList) {
                hjmx.setSid(lockLsh);
                newHjmxList.add(hjmx);
            }
            xmxxDto.setHjmx(newHjmxList);
        }
        log.error("\u51fa\u5e93\u8017\u65f63:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        super.saveOrUpdate(xmxxDto, sysUser);
        log.error("\u51fa\u5e93\u8017\u65f64:" + (System.currentTimeMillis() - start));
        return ((Zbhj)xmxxDto.getXmxx()).getXmid();
    }

    @Override
    public void unlockZbk(String lsh, Zbhj zbhj, boolean output) {
        if (StrUtil.isEmpty((CharSequence)lsh)) {
            return;
        }
        if (output) {
            List<ZBKOutputDetailGC> outputDetailGCList = this.zbkOutputDetailGCService.findListBySid(lsh);
            List<ZBKOutputDetail> outputDetails = outputDetailGCList.stream().map(f -> {
                ZBKOutputDetail zbkOutputDetail = new ZBKOutputDetail();
                f.setXmbh(zbhj.getXmbh());
                f.setXmmc(zbhj.getXmmc());
                BeanUtil.copyProperties((Object)f, (Object)zbkOutputDetail, (String[])new String[0]);
                return zbkOutputDetail;
            }).collect(Collectors.toList());
            List<ZBKOperateDetail> operateDetailList = this.zbkOperateDetailService.getOutputOperateDetail(outputDetails);
            this.zbkManagerService.unLock2Output(lsh, output, operateDetailList);
        } else {
            this.zbkManagerService.unLock2Output(lsh, output);
        }
    }

    private String lockZbk(ZbtjZbhjDTO zbhjDTO) {
        ArrayList<ZBKOutputDTO> lockDetails = new ArrayList<ZBKOutputDTO>();
        if (zbhjDTO.getHjmx() == null || zbhjDTO.getHjmx().size() == 0) {
            return "";
        }
        for (ZbhjMx bcgdDetail : zbhjDTO.getHjmx()) {
            ZBKOutputDTO zbkOutputDTO = new ZBKOutputDTO();
            Zbhj fnZygdXmxx = (Zbhj)zbhjDTO.getXmxx();
            zbkOutputDTO.setCnzb(bcgdDetail.getHjlscn());
            zbkOutputDTO.setCkxzqdm(fnZygdXmxx.getXmXzqdm());
            zbkOutputDTO.setCkxzqmc(fnZygdXmxx.getXmXzqmc());
            zbkOutputDTO.setCzxzqdm(fnZygdXmxx.getXzqdm());
            zbkOutputDTO.setCzxzqmc(fnZygdXmxx.getXzqmc());
            zbkOutputDTO.setStmj(bcgdDetail.getHjstgm());
            zbkOutputDTO.setGdmj(bcgdDetail.getHjzbgm());
            zbkOutputDTO.setXmbh(fnZygdXmxx.getXmbh());
            zbkOutputDTO.setXmmc(fnZygdXmxx.getXmmc());
            zbkOutputDTO.setUserid(fnZygdXmxx.getUserId());
            zbkOutputDTO.setUsername(fnZygdXmxx.getUserName());
            zbkOutputDTO.setZbid(bcgdDetail.getZbid());
            zbkOutputDTO.setCzlx(EnumZBKOutputType.BCGDHJCK.toValue());
            lockDetails.add(zbkOutputDTO);
        }
        return this.zbkManagerService.lock(((Zbhj)zbhjDTO.getXmxx()).getLsh(), lockDetails);
    }
}

