/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbtj.kj.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.RegionServiceUtil;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.domain.zbkkj.ZbkkjXmxx;
import com.geoway.onemap.zbph.dto.zbkkj.ZbkkjDTO;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.BaseXmfjService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkReduceHandler;
import com.geoway.onemap.zbph.service.zbtj.kj.ZbkkjManagerService;
import com.geoway.onemap.zbph.service.zbtj.kj.ZbkkjXmxxService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbkkjManagerServiceImpl
extends AbstractXmxxManagerServiceImpl<ZbkkjDTO, ZbkkjXmxx, ZbkkjXmxxService>
implements ZbkkjManagerService {
    @Autowired
    private ZbkkjXmxxService xmxxService;
    @Autowired
    private BaseLshService baseSidService;
    @Autowired
    private ZbkReduceHandler zbkReduceHandler;
    @Autowired
    private BaseXmfjService baseXmfjService;
    @Value(value="${project.fnzbk:true}")
    protected boolean fnzbk;

    public ZbkkjManagerServiceImpl(ZbkkjXmxxService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bacthSaveOrUpdate(List<ZbkkjDTO> zbkkjDTOS, SysUser sysUser) {
        String sid = this.baseSidService.generateLsh(sysUser.getXzqdm(), EnumLshType.ZBKJ);
        for (ZbkkjDTO zbkkjDTO : zbkkjDTOS) {
            if (StrUtil.isBlank((CharSequence)((ZbkkjXmxx)zbkkjDTO.getXmxx()).getLsh())) {
                ((ZbkkjXmxx)zbkkjDTO.getXmxx()).setLsh(sid);
            }
            this.saveOrUpdate(zbkkjDTO, sysUser);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(ZbkkjDTO zbkkjDTO, SysUser sysUser) {
        if (StrUtil.isBlank((CharSequence)((ZbkkjXmxx)zbkkjDTO.getXmxx()).getXmid())) {
            ((ZbkkjXmxx)zbkkjDTO.getXmxx()).setKjXzqmc(RegionServiceUtil.getFullRegionName((String)((ZbkkjXmxx)zbkkjDTO.getXmxx()).getKjXzqdm()));
            if (this.fnzbk) {
                this.zbkReduceHandler.reduce((ZbkkjXmxx)zbkkjDTO.getXmxx(), sysUser);
            }
        }
        super.saveOrUpdate(zbkkjDTO, sysUser);
        return ((ZbkkjXmxx)zbkkjDTO.getXmxx()).getXmid();
    }

    @Override
    public void lock(ZbkkjDTO xmxxDto) {
        LockUtil lockUtil = (LockUtil)SpringContextUtil.getBean(LockUtil.class);
        lockUtil.getLock(((ZbkkjXmxx)xmxxDto.getXmxx()).getLshType() + ((ZbkkjXmxx)xmxxDto.getXmxx()).getXmmc() + ((ZbkkjXmxx)xmxxDto.getXmxx()).getXmbh());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchRevert(List<ZbkkjDTO> zbkkjDTOs, SysUser sysUser) {
        for (ZbkkjDTO zbkkjDTO : zbkkjDTOs) {
            if (this.fnzbk) {
                this.zbkReduceHandler.reduce((ZbkkjXmxx)zbkkjDTO.getXmxx(), sysUser);
            }
            this.xmxxService.revert((ZbkkjXmxx)zbkkjDTO.getXmxx(), sysUser);
            this.baseXmfjService.deleteByXmIdAndRelateType(((ZbkkjXmxx)zbkkjDTO.getXmxx()).getXmid(), "\u64a4\u56de\u9644\u4ef6");
            if (zbkkjDTO.getCxfjDetails() == null) continue;
            zbkkjDTO.getCxfjDetails().forEach(f -> f.setRelation_type("\u64a4\u56de\u9644\u4ef6"));
            zbkkjDTO.getCxfjDetails().forEach(f -> f.setXmid(((ZbkkjXmxx)zbkkjDTO.getXmxx()).getXmid()));
            this.baseXmfjService.batchInsert(zbkkjDTO.getCxfjDetails(), sysUser);
        }
    }
}

