/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.util.ZipUtil;
import com.alibaba.excel.util.IoUtils;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.stxf.utils.FileUnZipRar;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.supoort.ShpUtil;
import com.geoway.onemap.zbph.supoort.TempFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileUtil;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.multipart.MultipartFile;

public class EasyShpUtil<T> {
    private static final String DEFAULT_CHARSET = "gb2312";

    public Iterator<T> read(MultipartFile mfile, Class classT) {
        try {
            TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
            File tempFile = tempFileUtil.getTempFile(mfile.getOriginalFilename());
            mfile.transferTo(tempFile);
            File file = ZipUtil.unzip((String)tempFile.getPath(), (Charset)Charset.forName("GBK"));
            File dir = file.getParentFile();
            String shpPath = FileUnZipRar.seachFirstFileBySuffix(dir);
            return this.read(shpPath, classT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean write(List<T> objs, String fileName, String tempfilePath) throws Exception {
        String filePath = tempfilePath + File.separator + fileName + ".shp";
        ShpUtil<T> easyShpUtil = new ShpUtil<T>();
        boolean result = easyShpUtil.writeToShpFromGeoJSON(objs, filePath);
        this.addShapeCpg(tempfilePath + File.separator + fileName + ".cpg");
        return result;
    }

    public boolean write(List<T> objs, String fileName, HttpServletResponse response) throws Exception {
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        String filePath = tempFile.getPath() + File.separator + fileName + ".shp";
        ShpUtil<T> easyShpUtil = new ShpUtil<T>();
        boolean result = easyShpUtil.writeToShpFromGeoJSON(objs, filePath);
        this.addShapeCpg(tempFile.getPath() + File.separator + fileName + ".cpg");
        File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + fileName + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
        response.setContentType("application/zip");
        response.setCharacterEncoding("utf-8");
        String utf8fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".zip");
        ServletOutputStream myout = response.getOutputStream();
        FileInputStream input = new FileInputStream(zipFile);
        myout.write(IoUtils.toByteArray((InputStream)input));
        ((InputStream)input).close();
        myout.flush();
        myout.close();
        FileUtil.deleteDir((File)tempFile);
        FileUtil.deleteFile((String)(tempFile.getPath() + fileName + ".zip"));
        return result;
    }

    public boolean write(List<Map<String, Object>> objs, String geometryField, List<ModelFields> fields, Map<String, String> fieldMap, String fileName, HttpServletResponse response) throws Exception {
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        String filePath = tempFile.getPath() + File.separator + fileName + ".shp";
        ShpUtil easyShpUtil = new ShpUtil();
        boolean result = easyShpUtil.writeToShpFromGeoJSON(objs, geometryField, fields, fieldMap, filePath);
        this.addShapeCpg(tempFile.getPath() + File.separator + fileName + ".cpg");
        File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + fileName + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
        response.setContentType("application/zip");
        response.setCharacterEncoding("utf-8");
        String utf8fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".zip");
        ServletOutputStream myout = response.getOutputStream();
        FileInputStream input = new FileInputStream(zipFile);
        myout.write(IoUtils.toByteArray((InputStream)input));
        ((InputStream)input).close();
        myout.flush();
        myout.close();
        FileUtil.deleteDir((File)tempFile);
        FileUtil.deleteFile((String)(tempFile.getPath() + fileName + ".zip"));
        return result;
    }

    private void addShapeCpg(String path) {
        File file = new File(path);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(path));){
            writer.write(ConfigConstant.TbrkConfig.cpgText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Iterator<T> read(String shpPath, Class classT) {
        try {
            ShpUtil easyShpUtil = new ShpUtil();
            return easyShpUtil.readShp(shpPath, easyShpUtil.useDefaultBuilder(classT));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Feature> read(MultipartFile mfile) {
        try {
            TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
            File tempFile = tempFileUtil.getTempFile(mfile.getOriginalFilename());
            mfile.transferTo(tempFile);
            File file = ZipUtil.unzip((String)tempFile.getPath(), (Charset)Charset.forName("GBK"));
            File dir = file.getParentFile();
            String shpPath = FileUnZipRar.seachFirstFileBySuffix(dir);
            return this.read(shpPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Feature> readByFile(String path) throws Exception {
        File file = ZipUtil.unzip((String)path, (Charset)Charset.forName("GBK"));
        try {
            String shpPath = FileUnZipRar.seachFirstFileBySuffix(file);
            return this.read(shpPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteReadFile(String path) {
        try {
            int index = path.lastIndexOf(".");
            String dir = path.substring(0, index);
            File file = new File(dir);
            boolean delete = file.delete();
            if (!delete) {
                EasyShpUtil.deleteDirectory(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u3010" + path + "\u3011\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    EasyShpUtil.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static Geometry getGeo(String wkt) {
        WKTReader reader = new WKTReader();
        try {
            Geometry geometry = reader.read(wkt);
            geometry.setSRID(4490);
            return geometry;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Feature> read(String shpPath) {
        try {
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            File shpFile = new File(shpPath);
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(shpFile.toURI().toURL());
            shpDataStore.setCharset(ShpUtil.getShapeFileCharsetName(shpPath));
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource();
            final SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            return new Iterator<Feature>(){

                @Override
                public boolean hasNext() {
                    return itertor.hasNext();
                }

                @Override
                public Feature next() {
                    Feature feature = new Feature();
                    SimpleFeature simpleFeature = (SimpleFeature)itertor.next();
                    Collection properties = simpleFeature.getProperties();
                    for (Property property : properties) {
                        String propName = property.getName().getLocalPart().toLowerCase();
                        if (propName.equals("the_geom")) {
                            Geometry shape = EasyShpUtil.getGeo(property.getValue().toString());
                            feature.setGeometry(shape);
                            continue;
                        }
                        String propvalue = property.getValue() == null ? "" : property.getValue().toString();
                        feature.attrs.put(propName, propvalue);
                    }
                    return feature;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static class Feature {
        private Map<String, Object> attrs = new CaseInsensitiveKeyMap();
        private Geometry geometry;

        public Map<String, Object> getAttrs() {
            return this.attrs;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public void setAttrs(Map<String, Object> attrs) {
            this.attrs = attrs;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Feature)) {
                return false;
            }
            Feature other = (Feature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$attrs = this.getAttrs();
            Map<String, Object> other$attrs = other.getAttrs();
            if (this$attrs == null ? other$attrs != null : !((Object)this$attrs).equals(other$attrs)) {
                return false;
            }
            Geometry this$geometry = this.getGeometry();
            Geometry other$geometry = other.getGeometry();
            return !(this$geometry == null ? other$geometry != null : !this$geometry.equals(other$geometry));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Feature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $attrs = this.getAttrs();
            result = result * 59 + ($attrs == null ? 43 : ((Object)$attrs).hashCode());
            Geometry $geometry = this.getGeometry();
            result = result * 59 + ($geometry == null ? 43 : $geometry.hashCode());
            return result;
        }

        public String toString() {
            return "EasyShpUtil.Feature(attrs=" + this.getAttrs() + ", geometry=" + this.getGeometry() + ")";
        }
    }
}

