/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import com.geoway.onemap.biz.service.system.RedisService;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.supoort.MinioUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileUploadUtil {
    @Autowired
    private MinioUtil minioUtil;
    @Autowired
    RedisService redisService;

    public String upload(MultipartFile mfile) {
        String path = null;
        try {
            path = "minio".equals(ConfigConstant.FileConfig.type) ? this.minioUtil.uploadFile(mfile) : this.uploadFile(mfile);
            return path.replace("\\", "/");
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public File getFile(String path) {
        try {
            if ("minio".equals(ConfigConstant.FileConfig.type)) {
                // empty if block
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u9644\u4ef6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public String downloadUrl(String path) {
        String url = null;
        try {
            url = "minio".equals(ConfigConstant.FileConfig.type) ? this.minioUtil.getUrl(path) : this.getUrl(path);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5730\u5740\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public Map<String, String> batchDownloadUrl(Map<String, String> map) {
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String url = null;
                url = "minio".equals(ConfigConstant.FileConfig.type) ? this.minioUtil.getUrl(entry.getValue()) : this.getUrl(entry.getValue());
                map.put(entry.getKey(), url);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5730\u5740\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String uploadFile(MultipartFile mfile) throws IOException {
        String relFolder = File.separator + "temp" + File.separator + UUID.randomUUID();
        String destDir = ConfigConstant.FileConfig.uploadDir + relFolder;
        new File(destDir).mkdirs();
        String fileName = mfile.getOriginalFilename();
        String fileFullName = destDir + File.separator + fileName;
        File dest = new File(fileFullName);
        mfile.transferTo(dest);
        return relFolder + File.separator + fileName;
    }

    private String getUrl(String path) {
        return ConfigConstant.FileConfig.Share_Endpoint + path;
    }
}

