/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.net.NetUtil;
import com.geoway.onemap.zbph.constant.base.EnumLockType;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Service
public class LockUtil
implements ApplicationListener<ServletRequestHandledEvent> {
    private static final Logger log = LoggerFactory.getLogger(LockUtil.class);
    private ThreadLocal<List<RLock>> threadLocks = new ThreadLocal();
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private ThreadLocal<Boolean> isLockEventPublish = new ThreadLocal();

    public boolean getLock(String lockId, EnumLockType lockType) {
        lockId = lockType.toValue() + "_" + lockId;
        return this.getLock(lockId);
    }

    public boolean getLock(String lockId) {
        RLock rLock;
        if (this.threadLocks.get() == null) {
            this.threadLocks.set(new ArrayList());
        }
        if (this.isLockEventPublish.get() == null) {
            this.isLockEventPublish.set(false);
        }
        if (this.threadLocks.get().stream().filter(f -> f.getName().equals(lockId)).count() > 0L) {
            return true;
        }
        if (!this.isLockEventPublish.get().booleanValue()) {
            this.isLockEventPublish.set(true);
            this.eventPublisher.publishEvent((ApplicationEvent)new ZbLockEvent(this.threadLocks));
        }
        if ((rLock = this.redissonClient.getLock("RLOCK_" + lockId)).tryLock()) {
            this.threadLocks.get().add(rLock);
            return true;
        }
        log.error("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff1aRLOCK_" + lockId);
        throw new RuntimeException("\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
    }

    private static String getMacAddress() {
        try {
            return NetUtil.getMacAddress((InetAddress)InetAddress.getLocalHost());
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    private void forceUnlock() {
        long start = System.currentTimeMillis();
        try {
            if (this.threadLocks.get() == null) {
                return;
            }
            for (RLock lock : this.threadLocks.get()) {
                lock.forceUnlock();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        finally {
            this.threadLocks.set(new ArrayList());
            this.isLockEventPublish.set(false);
            System.out.println("\u79fb\u9664\u9501\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={ZbLockEvent.class})
    public void onZbLockCommitEvent(ZbLockEvent event) {
        this.forceUnlock();
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_ROLLBACK, classes={ZbLockEvent.class})
    public void onZbLockRollbackEvent(ZbLockEvent event) {
        this.forceUnlock();
    }

    public void onApplicationEvent(ServletRequestHandledEvent servletRequestHandledEvent) {
        this.forceUnlock();
    }

    public static class ZbLockEvent
    extends ApplicationEvent {
        public ZbLockEvent(Object source) {
            super(source);
        }
    }
}

