/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.biz.service.system.RedisService;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.stxf.utils.FileTypeUtils;
import com.geoway.onemap.stxf.utils.FileUtils2;
import com.geoway.onemap.stxf.utils.VideoUtil;
import com.geoway.onemap.zbph.supoort.FileUploadUtil;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.dao.IBaseFileDownloadDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.BaseFileDownload;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseFileService {
    @Autowired
    RedisService redisService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private IBaseFileDao iBaseFileDao;
    @Autowired
    private IBaseFileDownloadDao iBaseFileDownloadDao;
    @Value(value="${project.templateDir}")
    protected String templateDir;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @Transactional(rollbackFor={Exception.class})
    public BaseFile saveBaseFile(BaseFile baseFile) {
        return (BaseFile)this.iBaseFileDao.save((Object)baseFile);
    }

    @Transactional(rollbackFor={Exception.class})
    public Iterable<BaseFile> saveBaseFile(List<BaseFile> files) {
        return this.iBaseFileDao.saveAll(files);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delBaseFile(String ... id) {
        if (id.length > 1) {
            for (String tmp : id) {
                this.delete(tmp);
            }
        } else {
            this.delete(id[0]);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.iBaseFileDownloadDao.deleteByFileId(id);
        this.iBaseFileDao.deleteById((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRelationIdAndRelationType(String relationId, String relationType) {
        List list = this.iBaseFileDao.findByRelationIdAndRelationType(relationId, relationType);
        for (BaseFile file : list) {
            this.delete(file.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRelationId(String relationId) {
        this.iBaseFileDao.deleteByRelationId(relationId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRelationIds(List<String> relationIds) {
        this.iBaseFileDao.deleteByRelationIds(relationIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRelationIds(List<String> relationIds, String relationType) {
        this.iBaseFileDao.deleteByRelationIds(relationIds, relationType);
    }

    public List<BaseFile> findAll(String filterParam, String sortParam) {
        return this.iBaseFileDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
    }

    public BaseFile findById(String id) {
        return this.iBaseFileDao.findBaseFileById(id);
    }

    public Page<BaseFile> findPages(String filterParam, String sortParam, int page, int size) {
        Page results = this.iBaseFileDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        List content = results.getContent();
        for (BaseFile file : content) {
            String url = this.fileUploadUtil.downloadUrl(file.getCreatePath());
            file.setCreatePath(url);
        }
        return results;
    }

    public BaseFile uploadFile2(File file, String relationId, String relationType, SysUser user, String mediaType) {
        BaseFile baseFile = this.uploadFile(file, relationId, relationType, user);
        baseFile.setMediaType(mediaType);
        return (BaseFile)this.iBaseFileDao.save((Object)baseFile);
    }

    public BaseFile uploadFile(File file, String relationId, String relationType, SysUser user) {
        BaseFile result = null;
        try {
            File file2 = file;
            String name = file.getName();
            Long length = file.length();
            File uploadDirFile = new File(this.uploadDir);
            if (!file.getAbsolutePath().contains(uploadDirFile.getAbsolutePath())) {
                Calendar a = Calendar.getInstance();
                String year = a.get(1) + "";
                String month = a.get(2) + 1 + "";
                UUID uuid = UUID.randomUUID();
                String storePath = File.separator + year + File.separator + month + File.separator + uuid + File.separator;
                String upFilePath = this.uploadDir + storePath;
                File filedir = new File(upFilePath);
                if (!filedir.exists()) {
                    filedir.mkdirs();
                }
                File file3 = new File(upFilePath, name);
                FileUtils.copyInputStreamToFile((InputStream)new FileInputStream(file), (File)file3);
                file.delete();
                file2 = file3;
            }
            BaseFile baseFile = new BaseFile();
            if (user != null) {
                baseFile.setUploadEmplId(user.getId());
            } else {
                baseFile.setUploadEmplId("");
            }
            String path = file2.getAbsolutePath().replace(uploadDirFile.getAbsolutePath(), "").trim();
            String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            String thumbPath = null;
            if ("jpg".equals(suffix) || "png".equals(suffix)) {
                thumbPath = file2.getAbsolutePath().substring(0, file2.getAbsolutePath().lastIndexOf(name)) + "thumb-" + name;
                Thumbnails.of((String[])new String[]{file2.getAbsolutePath()}).size(80, 80).toFile(thumbPath);
            } else if ("mp4".equals(suffix)) {
                thumbPath = VideoUtil.randomGrabberFFmpegImage(file2.getAbsolutePath(), 2);
            }
            baseFile.setCreatePath(path);
            baseFile.setRelationId(relationId);
            baseFile.setFileName(name);
            baseFile.setFileSize(Double.valueOf(Double.parseDouble(length.toString())));
            baseFile.setRelationType(relationType);
            baseFile.setFileType(this.getFileType(name));
            baseFile.setFileFormat(suffix);
            baseFile.setUploadTime(new Date());
            if (StringUtils.isNotBlank((CharSequence)thumbPath)) {
                baseFile.setThumbPath(thumbPath.replace(uploadDirFile.getAbsolutePath(), ""));
            }
            result = (BaseFile)this.iBaseFileDao.save((Object)baseFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Integer getFileType(String name) {
        Integer type = 1;
        if (FileTypeUtils.isVedioFile(name)) {
            type = 3;
        } else if (".mp3".equals(name.substring(name.lastIndexOf(".")))) {
            type = 2;
        } else if (name.endsWith(".pdf")) {
            type = 4;
        }
        return type;
    }

    public BaseFile downLoadFile(String fileId, String userId) {
        BaseFile baseFile = null;
        try {
            baseFile = this.iBaseFileDao.findBaseFileById(fileId);
            BaseFileDownload baseFileDownload = new BaseFileDownload();
            baseFileDownload.setFileId(fileId);
            baseFileDownload.setDownloadEmplId(userId);
            baseFileDownload.setDownloadTime(new Date());
            this.iBaseFileDownloadDao.save((Object)baseFileDownload);
            return baseFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return baseFile;
        }
    }

    public List<BaseFile> saveUUIDFiles(String relationId, List<BaseFile> baseFiles, List<String> uuids, SysUser user) throws IOException {
        for (int i = 0; i < uuids.size(); ++i) {
            String uuid = uuids.get(i);
            String filePath = this.redisService.get(uuid);
            File file = new File(filePath);
            String destFolder = file.getParent().replace("temp", "result");
            FileUtils2.copyDir(file.getParent(), destFolder);
            FileUtils2.delFile(file.getParentFile());
            String destPath = destFolder + File.separator + file.getName();
            String relationPath = destPath.substring(this.uploadDir.length());
            BaseFile baseFile = (BaseFile)baseFiles.get(i);
            baseFile.setRelationId(relationId);
            baseFile.setCreatePath(relationPath);
            baseFile.setUploadEmplId(user.getId());
            baseFile.setUploadTime(new Date());
        }
        baseFiles = (List)this.iBaseFileDao.saveAll(baseFiles);
        return baseFiles;
    }

    public JSONObject convertHJUpPropName(JSONObject origin) {
        JSONObject target = new JSONObject();
        for (String key : origin.keySet()) {
            String newKey = null;
            if ("\u5750\u6807\u7cfb".equals(key)) {
                newKey = "srcname";
            } else if ("\u51e0\u5ea6\u5206\u5e26".equals(key)) {
                newKey = "degress";
            } else if ("\u6295\u5f71\u7c7b\u578b".equals(key)) {
                newKey = "protype";
            } else if ("\u5e26\u53f7".equals(key)) {
                newKey = "degressno";
            } else if ("\u7cbe\u5ea6".equals(key)) {
                newKey = "greenwich";
            }
            if (newKey == null) continue;
            target.put(newKey, origin.get((Object)key));
        }
        return target;
    }

    public List<File> searchTemplateFile(String fileName) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils2.findFiles(this.templateDir, fileName, files);
        return files;
    }

    public List<BaseFile> findByRelationId(String relationId, String relateType) {
        return this.iBaseFileDao.findByRelationIdAndRelationType(relationId, relateType);
    }

    public List<BaseFile> findByRelationId(String relationId) {
        return this.iBaseFileDao.findByRelationId(relationId);
    }

    public BaseFile fileManage(BaseFile baseFile, SysUser user) {
        String path = baseFile.getCreatePath();
        if (user != null) {
            baseFile.setUploadEmplId(user.getId());
        } else {
            baseFile.setUploadEmplId("");
        }
        int index = path.lastIndexOf(File.separator);
        String name = path.substring(index + 1);
        baseFile.setFileName(name);
        baseFile.setUploadTime(new Date());
        baseFile.setFileType(this.getFileType(name));
        baseFile.setFileFormat(path.substring(path.lastIndexOf(".") + 1).toLowerCase());
        return baseFile;
    }

    public void saveCover(List<BaseFile> baseFiles) {
        baseFiles = baseFiles.stream().filter(f -> StringUtils.isEmpty((CharSequence)f.getId())).collect(Collectors.toList());
        for (BaseFile baseFile : baseFiles) {
            this.iBaseFileDao.deleteByRelationIdAndRelationType(baseFile.getRelationId(), baseFile.getRelationType());
        }
        this.iBaseFileDao.saveAll(baseFiles);
    }
}

