/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.zhgd.dao.IProjectProgressDao;
import com.geoway.zhgd.domain.ProjectProgress;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectProgressService {
    @Autowired
    private IProjectProgressDao iProjectProgressDao;

    @Transactional(rollbackFor={Exception.class})
    public ProjectProgress saveProjectProgress(ProjectProgress projectProgress, SysUser user) {
        if (StringUtils.isBlank((CharSequence)projectProgress.getId())) {
            projectProgress.setCreateTime(new Date());
            projectProgress.setCreateUser(user.getId());
            projectProgress.setCreateName(user.getUsername());
        }
        return (ProjectProgress)this.iProjectProgressDao.save((Object)projectProgress);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delProjectProgress(String ... id) {
        if (id.length > 1) {
            for (String tmp : id) {
                this.iProjectProgressDao.deleteById((Object)tmp);
            }
        } else {
            this.iProjectProgressDao.deleteById((Object)id[0]);
        }
    }

    public ProjectProgress findById(String id) {
        return this.iProjectProgressDao.findProjectProgressById(id);
    }

    public Page<ProjectProgress> findPages(String filterParam, String sortParam, int page, int size) {
        Page results = this.iProjectProgressDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List<ProjectProgress> findAllByProjectId(String filterParam, String sortParam, String projectId) {
        filterParam = "Q_projectId_S_EQ=" + projectId;
        return this.findAll(filterParam, sortParam);
    }

    public List<ProjectProgress> findAll(String filterParam, String sortParam) {
        List list = this.iProjectProgressDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        return list;
    }
}

