/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.ShapeUtil;
import com.geoway.onemap.core.support.Zip4jUtil;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.stxf.service.GdbhService;
import com.geoway.onemap.stxf.service.GtyService;
import com.geoway.zhgd.dao.IProjectRcjgDao;
import com.geoway.zhgd.dao.IProjectRcjgProcessDao;
import com.geoway.zhgd.dao.IProjectRcjgRecordDao;
import com.geoway.zhgd.dao.IProjectRcjgVoDao;
import com.geoway.zhgd.domain.ProjectRcjg;
import com.geoway.zhgd.domain.ProjectRcjgProcess;
import com.geoway.zhgd.domain.ProjectRcjgRecord;
import com.geoway.zhgd.domain.ProjectRcjgVo;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectRcjgRecordService {
    @Autowired
    private IProjectRcjgRecordDao iProjectRcjgRecordDao;
    @Autowired
    private IProjectRcjgProcessDao iProjectRcjgProcessDao;
    @Autowired
    private IProjectRcjgVoDao iProjectRcjgVoDao;
    @Autowired
    private IProjectRcjgDao iProjectRcjgDao;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ModelManageService modelManageService;
    @Autowired
    private ModelFieldsService modelFieldsService;
    @Autowired
    private GdbhService gdbhService;
    @Autowired
    private BaseFileService baseFileService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value(value="${project.gty.dir}")
    protected String gtyDir;
    @Autowired
    protected GtyService gtyService;

    @Transactional(rollbackFor={Exception.class})
    public ProjectRcjgRecord saveProjectRcjgRecord(ProjectRcjgRecord projectRcjgRecord) {
        return (ProjectRcjgRecord)this.iProjectRcjgRecordDao.save((Object)projectRcjgRecord);
    }

    public ProjectRcjgRecord updateZBGLState(String id, Integer state) {
        ProjectRcjgRecord entity = (ProjectRcjgRecord)this.iProjectRcjgRecordDao.findById((Object)id).get();
        entity.setZbglState(state);
        if (state == 3 || state == 4) {
            entity.setJudgeMatterTime(null);
            entity.setResultState(Integer.valueOf(5));
        } else if (state == 5) {
            entity.setResultState(Integer.valueOf(6));
        }
        return (ProjectRcjgRecord)this.iProjectRcjgRecordDao.save((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delProjectRcjgRecord(String ... id) {
        if (id.length > 1) {
            for (String tmp : id) {
                this.iProjectRcjgRecordDao.deleteById((Object)tmp);
            }
        } else {
            this.iProjectRcjgRecordDao.deleteById((Object)id[0]);
        }
    }

    public List<ProjectRcjgRecord> findByIds(List<String> ids) {
        return this.iProjectRcjgRecordDao.findProjectRcjgRecordsByIdIn(ids);
    }

    public ProjectRcjgRecord findById(String id) {
        return this.iProjectRcjgRecordDao.findProjectRcjgRecordById(id);
    }

    public Page<ProjectRcjgRecord> findPages(String filterParam, String sortParam, int page, int size) {
        Page results = this.iProjectRcjgRecordDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List getRecordMatterTime(String ids) {
        String[] idArr = ids.split(",");
        StringBuilder sb = new StringBuilder();
        for (String id : idArr) {
            sb.append("'").append(id).append("'").append(",");
        }
        String inIds = sb.deleteCharAt(sb.length() - 1).toString();
        String sql = String.format("select f_judge_matter_time from tb_project_rcjg_record where f_id in(%s) order by strpos('%s', f_id::text)", inIds, ids);
        List result = this.jdbcTemplate.queryForList(sql);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addProjectRcjg(String projectId, String userId, String workflowKey) throws Exception {
        ProjectRcjgRecord record = this.saveRcjg(projectId, userId);
        HashMap<String, Object> visiables = new HashMap<String, Object>();
        String processId = this.startWorkflow(workflowKey, userId, visiables);
        record.setProcessId(processId);
        this.iProjectRcjgRecordDao.save((Object)record);
        ProjectRcjgVo recordVo = this.iProjectRcjgVoDao.findProjectRcjgVoByProjectVoId(record.getProjectId());
        if ("fhk".equalsIgnoreCase(recordVo.getKlx())) {
            this.gdbhService.saveFHK2ZBK(record.getProjectId(), userId, "-", "\u7701\u7ea7\u9501\u5b9a\u6307\u6807", Long.parseLong(record.getId()));
        } else if ("lsk".equalsIgnoreCase(recordVo.getKlx())) {
            this.gdbhService.saveLSK2ZBK(record.getProjectId(), userId, "-", "\u7701\u7ea7\u9501\u5b9a\u6307\u6807", Long.parseLong(record.getId()));
        }
    }

    private ProjectRcjgRecord saveRcjg(String projectId, String userId) {
        ProjectRcjg rcjg = this.iProjectRcjgDao.findProjectRcjgByProjectId(projectId);
        Date date = new Date();
        if (rcjg == null) {
            rcjg = new ProjectRcjg();
            rcjg.setCreatetime(date);
            rcjg.setUpdatetime(date);
            rcjg.setNum(Integer.valueOf(1));
            rcjg.setProjectId(projectId);
        } else {
            rcjg.setNum(Integer.valueOf(rcjg.getNum() == null ? 1 : rcjg.getNum() + 1));
            rcjg.setUpdatetime(date);
        }
        rcjg.setState(Integer.valueOf(1));
        this.iProjectRcjgDao.save((Object)rcjg);
        ProjectRcjgRecord record = new ProjectRcjgRecord();
        record.setProjectId(projectId);
        record.setUserId(userId);
        record.setCreateTime(date);
        record.setResultState(Integer.valueOf(2));
        record.setNumber(rcjg.getNum());
        record.setUpdateTime(date);
        record.setZbglState(Integer.valueOf(0));
        return (ProjectRcjgRecord)this.iProjectRcjgRecordDao.save((Object)record);
    }

    private String startWorkflow(String key, String userId, Map<String, Object> visiables) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, visiables);
        this.runtimeService.updateBusinessKey(processInstance.getId(), key);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().singleResult();
        this.taskService.claim(task.getId(), userId);
        this.taskService.complete(task.getId(), visiables);
        return processInstance.getId();
    }

    public void importProjectRecord(ProjectRcjgRecord record, File[] files, String fileUri, String userId) throws Exception {
        this.baseFileService.deleteByRelationIdAndRelationType(record.getProjectId(), record.getId());
        for (File file : files) {
            if (!file.isFile()) continue;
            String fileName = file.getAbsolutePath();
            this.gdbhService.parseDB(fileName, fileUri, record.getId(), userId, "RCJG-CGB", null);
        }
    }

    private boolean checkRcjgFile(File[] files) {
        return true;
    }

    public String exportProjectShp(ProjectRcjgRecord record, String path) {
        this.iProjectRcjgRecordDao.save((Object)record);
        String filePath = "";
        Map project = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_fhk", record.getProjectId(), "");
        List list = null;
        if (project != null && project.size() > 0) {
            filePath = this.getFileName(project.get("f_name"), project.get("f_code"));
            list = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fhk_xmfw", "", "and f_project_id = '" + record.getProjectId() + "'");
            return this.zipShp(list, project, path + File.separator + filePath, "tb_project_gdbh_cbbcgd_fhk");
        }
        project = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_lsk", record.getProjectId(), "");
        filePath = this.getFileName(project.get("f_xmmc"), project.get("f_ys_xmbh"));
        list = this.modelManageService.findList("tb_project_gdbh_cbbcgd_lsk_xmfw", "", "and f_project_id = '" + record.getProjectId() + "'");
        return this.zipShp(list, project, path + File.separator + filePath, "tb_project_gdbh_cbbcgd_lsk");
    }

    private String zipShp(List<Map<String, Object>> tbList, Map<String, Object> project, String path, String tableName) {
        File file = new File(path.substring(0, path.lastIndexOf(File.separator)));
        if (!file.exists()) {
            file.mkdirs();
        }
        List attrKeys = this.modelFieldsService.findFieldNameByTableName(tableName);
        ArrayList list = new ArrayList();
        for (Map<String, Object> map : tbList) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.putAll(project);
            tmp.put("f_shape", map.get("wkt"));
            list.add(tmp);
        }
        ShapeUtil.write2Shape((String)path, (String)"gbk", (String)"MultiPolygon", (String)"f_shape", (List)attrKeys, list);
        return Zip4jUtil.zip((String)path.substring(0, path.lastIndexOf(File.separator)));
    }

    private String getFileName(Object name, Object code) {
        String filePath = "";
        filePath = name == null && code == null ? String.format("\u9879\u76ee\u540d\u79f0{\u9879\u76ee\u7f16\u53f7}%s\u9879\u76ee\u7f16\u53f7.shp", File.separator) : String.format("%s(%s)%s%s.shp", name, code, File.separator, code);
        return filePath;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectRcjgRecord checkRcjgRecord(ProjectRcjgRecord projectRcjgRecord, SysUser user) throws Exception {
        ProjectRcjgRecord db = this.iProjectRcjgRecordDao.findProjectRcjgRecordById(projectRcjgRecord.getId());
        db.setUpdateTime(new Date());
        db.setCheckRemark(projectRcjgRecord.getCheckRemark());
        db.setResultState(projectRcjgRecord.getResultState());
        db.setCheckUserId(user.getId());
        db.setCheckUserName(user.getUsername());
        db.setCheckTime(new Date());
        ProjectRcjgRecord projectRcjgRecordDb = (ProjectRcjgRecord)this.iProjectRcjgRecordDao.save((Object)db);
        ProjectRcjgProcess db2 = new ProjectRcjgProcess();
        BeanUtils.copyProperties((Object)db, (Object)db2);
        db2.setId(null);
        db2.setRecordId(db.getId());
        this.iProjectRcjgProcessDao.save((Object)db2);
        ProjectRcjg rcjg = this.iProjectRcjgDao.findProjectRcjgByProjectId(db.getProjectId());
        if (projectRcjgRecord.getResultState() == 5) {
            ProjectRcjgVo recordVo = this.iProjectRcjgVoDao.findProjectRcjgVoByProjectVoId(db.getProjectId());
            if ("fhk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveFHK2ZBK(db.getProjectId(), user.getId(), "+", "\u7701\u7ea7\u89e3\u9501\u6307\u6807", Long.parseLong(projectRcjgRecordDb.getId()));
            } else if ("lsk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveLSK2ZBK(db.getProjectId(), user.getId(), "+", "\u7701\u7ea7\u89e3\u9501\u6307\u6807", Long.parseLong(projectRcjgRecordDb.getId()));
            }
            rcjg.setState(Integer.valueOf(0));
        } else if (projectRcjgRecord.getResultState() == 7) {
            ProjectRcjgVo recordVo = this.iProjectRcjgVoDao.findProjectRcjgVoByProjectVoId(db.getProjectId());
            if ("fhk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveFHK2ZBK(db.getProjectId(), user.getId(), "-", "\u51bb\u7ed3\u6307\u6807", Long.parseLong(projectRcjgRecordDb.getId()));
            } else if ("lsk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveLSK2ZBK(db.getProjectId(), user.getId(), "-", "\u51bb\u7ed3\u6307\u6807", Long.parseLong(projectRcjgRecordDb.getId()));
            }
        } else {
            rcjg.setState(Integer.valueOf(0));
        }
        this.iProjectRcjgDao.save((Object)rcjg);
        return projectRcjgRecordDb;
    }

    public void updateRcjgRecordState(Integer state, String recordId) {
        ProjectRcjgRecord projectRcjgRecord = (ProjectRcjgRecord)this.iProjectRcjgRecordDao.findById((Object)recordId).get();
        projectRcjgRecord.setUpdateTime(new Date());
        projectRcjgRecord.setResultState(state);
        this.iProjectRcjgRecordDao.save((Object)projectRcjgRecord);
    }

    public void generateHsGty(String projectIds, String type) throws SQLException, IOException {
        String[] projectIdArr = projectIds.split(",");
        ArrayList<Map<String, Object>> XZGDFW = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> PZD = new ArrayList<Map<String, Object>>();
        for (String projectId : projectIdArr) {
            String jhkId;
            ProjectRcjgVo projectRcjgVo = this.iProjectRcjgVoDao.findProjectRcjgVoByProjectVoId(projectId);
            String sql = "";
            String xzgdfwTable = "";
            if ("lsk".equals(projectRcjgVo.getKlx())) {
                sql = "SELECT\n    t1.xzqdm,    t1.xzqmc,    t1.f_jbxx_xmlx AS xmlx,    t1.f_ys_xmbh AS ys_xmbh,    t1.f_xmmc AS jbxx_xmmc,    t1.f_jbxx_xzqdm AS jbxx_xzqdm,    t1.f_ys_gm_zgm AS ys_gm_zgm,    t1.f_ys_tz_ztz AS ys_tz_ztz,    t1.f_ys_yswh AS ys_yswh,    t1.f_ys_ysrq AS ys_ysrq,    t1.f_gdmj AS bcgdmj,    t1.f_stmj AS jzstmj,    t1.f_ys_cx_jsqg AS tzgzqzldb,    t1.f_ys_cx_jshg AS tzgzhzldb,    st_astext ( t2.f_shape ) AS wkt FROM    tb_project_gdbh_cbbcgd_lsk t1    LEFT JOIN tb_project_gdbh_cbbcgd_lsk_xmfw t2 ON t1.f_id = t2.f_project_id  where t1.f_id = '" + projectId + "'";
                xzgdfwTable = "tb_project_gdbh_cbbcgd_lsk_xzgdfw";
            } else if ("fhk".equals(projectRcjgVo.getKlx())) {
                sql = "SELECT     t1.xzqdm,     t1.xzqmc,     t2.f_xmlx AS xmlx,    t1.f_xmzgbm AS xmzgbm,    t2.f_ys_xmbh AS ys_xmbh,     t1.f_name AS jbxx_xmmc,     t1.f_xzqhdm AS jbxx_xzqdm,     t1.f_xzqmc AS jbxx_xzqmc,     t1.f_ys_gm_zgm AS ys_gm_zgm,     t1.f_ys_tz_ztz AS ys_tz_ztz,     t1.f_pf_pfwh AS pf_pfwh,     t1.f_pf_pfrq AS pf_pfrq,     t1.f_ys_yswh AS ys_yswh,     t1.f_ys_ysrq AS ys_ysrq,     t1.f_jgysfzr AS jgysfzr,     t1.f_bcgdmj AS bcgdmj,     t1.f_bcgdpjzldb AS bcgdpjzldb,     t1.f_jzgdmj AS jzgdmj,     t1.f_jzstmj AS jzstmj,     t1.f_tzgzgdmj AS tzgzgdmj,     t1.f_tzgzstmj AS tzgzstmj,     t1.f_tzgzqzldb AS tzgzqzldb,     t1.f_tzgzhzldb AS tzgzhzldb,    st_astext(t2.f_shape) as wkt  FROM tb_project_gdbh_cbbcgd_fhk t1    LEFT JOIN tb_project_gdbh_cbbcgd_fhk_xmfw t2 ON t1.f_id = t2.f_project_id  where t1.f_id = '" + projectId + "'";
                xzgdfwTable = "tb_project_gdbh_cbbcgd_fhk_xzgdfw";
            }
            Map xmMap = this.jdbcTemplate.queryForMap(sql);
            Object ys_xmbh = xmMap.get("ys_xmbh");
            Object jbxx_xmmc = xmMap.get("jbxx_xmmc");
            sql = "select xzqdm, xzqmc, f_dikuai_no as dikuai_no, f_pl_name as pl_name, f_dikuai_area as dikuaiarea, f_purpose as purpose, f_map_no as map_no, f_patchtype as patchtype, f_landtype as landtype, f_avggrade1 as avggrade1, f_avggrade2 as avggrade2, f_jbxx_xmmc as jbxx_xmmc, st_astext(f_shape) as wkt from " + xzgdfwTable + " where f_project_id = '" + projectId + "'";
            List xzdks = this.jdbcTemplate.queryForList(sql);
            for (Map xzdk : xzdks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(xzdk);
                map.put("klx", projectRcjgVo.getKlx());
                map.put("ys_xmbh", (String)ys_xmbh);
                XZGDFW.add(map);
            }
            if (!"fhk".equals(projectRcjgVo.getKlx()) || !StringUtils.isNotBlank((CharSequence)(jhkId = (String)this.jdbcTemplate.queryForObject(sql = "select f_id as jhkid from tb_project_gdbh_cbbcgd_jhk where f_code = (   select f_code from tb_project_gdbh_cbbcgd_fhk where f_id = '" + projectId + "')", String.class)))) continue;
            sql = "select f_id as id, f_lat as y, f_lng as x, f_radius as radius, f_dk_no as dikuai_no from tb_project_gdbh_cbbcgd_jhk_pzd where f_project_id = '" + jhkId + "'";
            List pzds = this.jdbcTemplate.queryForList(sql);
            for (Map pzd : pzds) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(pzd);
                Object x = map.get("x");
                Object y = map.get("y");
                map.put("wkt", "POINT(" + x + " " + y + ")");
                map.put("ys_xmbh", (String)ys_xmbh);
                map.put("jbxx_xmmc", (String)jbxx_xmmc);
                PZD.add(map);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = sdf.format(new Date());
        String dir = this.gtyDir + "/" + type + "/" + type.toUpperCase() + "_" + time;
        this.gtyService.generateGty(XZGDFW, PZD, dir);
    }
}

