/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class VideoUtil {
    private static final String IMAGEMAT = "png";
    private static final String ROTATE = "rotate";
    public static final int MOD = 2;

    public static String randomGrabberFFmpegImage(String filePath, int mod) throws Exception {
        String targetFilePath = "";
        FFmpegFrameGrabber ff = FFmpegFrameGrabber.createDefault((String)filePath);
        ff.start();
        String rotate = ff.getVideoMetadata(ROTATE);
        int ffLength = ff.getLengthInFrames();
        int index = ffLength / mod;
        for (int i = 0; i < ffLength; ++i) {
            Frame f = ff.grabImage();
            if (i != index) continue;
            if (null != rotate && rotate.length() > 1) {
                OpenCVFrameConverter.ToIplImage converter = new OpenCVFrameConverter.ToIplImage();
                opencv_core.IplImage src = converter.convert(f);
                f = converter.convert(VideoUtil.rotate(src, Integer.valueOf(rotate)));
            }
            targetFilePath = VideoUtil.getImagePath(filePath, i);
            VideoUtil.doExecuteFrame(f, targetFilePath);
            break;
        }
        ff.stop();
        return targetFilePath;
    }

    private static String getImagePath(String filePath, int index) {
        if (filePath.contains(".") && filePath.lastIndexOf(".") < filePath.length() - 1) {
            filePath = filePath.substring(0, filePath.lastIndexOf(".")).concat("_").concat(String.valueOf(index)).concat(".").concat(IMAGEMAT);
        }
        return filePath;
    }

    public static opencv_core.IplImage rotate(opencv_core.IplImage src, int angle) {
        opencv_core.IplImage img = opencv_core.IplImage.create((int)src.height(), (int)src.width(), (int)src.depth(), (int)src.nChannels());
        opencv_core.cvTranspose((opencv_core.CvArr)src, (opencv_core.CvArr)img);
        opencv_core.cvFlip((opencv_core.CvArr)img, (opencv_core.CvArr)img, (int)angle);
        return img;
    }

    public static void doExecuteFrame(Frame f, String targerFilePath) {
        if (null == f || null == f.image) {
            return;
        }
        Java2DFrameConverter converter = new Java2DFrameConverter();
        BufferedImage bi = converter.getBufferedImage(f);
        File output = new File(targerFilePath);
        try {
            ImageIO.write((RenderedImage)bi, IMAGEMAT, output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Integer> random(int baseNum, int length) {
        ArrayList<Integer> list = new ArrayList<Integer>(length);
        while (list.size() < length) {
            Integer next = (int)(Math.random() * (double)baseNum);
            if (list.contains(next)) continue;
            list.add(next);
        }
        Collections.sort(list);
        return list;
    }
}

