/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.support.QueryParamRes;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.RegionServiceUtil;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.EnumStatType;
import com.geoway.onemap.zbph.constant.base.EnumXzqLevel;
import com.geoway.onemap.zbph.domain.base.AbstractXmxx;
import com.geoway.onemap.zbph.service.base.AbstractObjectService;
import com.geoway.onemap.zbph.service.base.AbstractXmxxService;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.impl.AbstractEntityServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractXmxxServiceImpl<T extends AbstractXmxx>
extends AbstractEntityServiceImpl<T>
implements AbstractXmxxService<T>,
AbstractObjectService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractXmxxServiceImpl.class);
    @Autowired
    private ModelManageService modelManageService;
    @Autowired
    private BaseLshService sidService;
    @Autowired
    private ModelFieldsService modelFieldsService;

    @Override
    public T findById(String xmid) {
        Map mapObject = this.modelManageService.findObject(this.getTableName(), xmid, "");
        if (mapObject == null) {
            return null;
        }
        return (T)((AbstractXmxx)this.convertFromMap(mapObject));
    }

    @Override
    public List<String> findPreCurNextIds(String filterParam, String sortParam, String curXmid) {
        AbstractXmxx t = (AbstractXmxx)this.convertFromMap(new HashMap<String, Object>());
        return this.findPreCurNextIds(filterParam, sortParam, curXmid, t.getXmidFieldName());
    }

    @Override
    public List<String> findIds(String filterParam) {
        List fields = this.modelFieldsService.findByTableName(this.getTableName());
        fields = fields.stream().filter(f -> f.getIsPrimary() == 1).collect(Collectors.toList());
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        List list = this.modelManageService.findListPage(this.getTableName(), fields, paramRes.getWhere(), paramRes.getValues(), "");
        return list.stream().map(f -> f.values().toArray()[0].toString()).collect(Collectors.toList());
    }

    @Override
    public T findByName(String name) {
        AbstractXmxx t = (AbstractXmxx)this.convertFromMap(new HashMap<String, Object>());
        String xmmcFieldName = t.getXmmcFieldName();
        String where = " and " + xmmcFieldName + " = '" + name + "' ";
        Map one = this.modelManageService.findOne(this.getTableName(), where);
        if (one == null) {
            return null;
        }
        return (T)((AbstractXmxx)this.convertFromMap(one));
    }

    @Override
    public boolean checkNameValid(String xmid, String name) {
        T t = this.findByName(name);
        return t == null || ((AbstractXmxx)t).getXmid().equals(xmid);
    }

    @Override
    public List<T> findByIds(Iterable<String> xmids) {
        return this.findByIds(xmids, "");
    }

    @Override
    public List<T> findByIds(Iterable<String> xmids, String groupCode) {
        ArrayList result = new ArrayList();
        if (xmids == null) {
            return result;
        }
        AbstractXmxx t = (AbstractXmxx)this.getDefault();
        ArrayList temp = new ArrayList();
        xmids.forEach(f -> temp.add("'" + f + "'"));
        String where = String.format("%s in (%s)", t.getXmidFieldName(), StrUtil.join((CharSequence)",", temp));
        List list = this.modelManageService.findListPage(this.getTableName(), groupCode, where, null, "");
        for (Map mapObject : list) {
            result.add(this.convertFromMap(mapObject));
        }
        return result;
    }

    private List<T> findByIdsFields(Iterable<String> xmids, List<ModelFields> list) {
        ArrayList result = new ArrayList();
        if (xmids == null) {
            return result;
        }
        List xmidList = IteratorUtils.toList(xmids.iterator());
        List xmidGroups = Lists.partition((List)xmidList, (int)3000);
        AbstractXmxx t = (AbstractXmxx)this.getDefault();
        for (List xmidGroup : xmidGroups) {
            ArrayList temp = new ArrayList();
            ArrayList values = new ArrayList();
            xmidGroup.forEach(f -> {
                temp.add("?");
                values.add(f);
            });
            String where = String.format("%s in (%s)", t.getXmidFieldName(), StrUtil.join((CharSequence)",", temp));
            long start = System.currentTimeMillis();
            List objectList = this.modelManageService.findListPage(this.getTableName(), list, where, values.toArray(), "");
            System.out.println("\u67e5\u8be2\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (Map mapObject : objectList) {
                result.add(this.convertFromMap(mapObject));
            }
            System.out.println("\u8f6c\u6362\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        return result;
    }

    @Override
    public List<T> findByIds(Iterable<String> xmids, List<String> fields) {
        List<ModelFields> list = this.modelFieldsService.findByTableName(this.getTableName());
        list = list.stream().filter(f -> fields.stream().filter(g -> g.toLowerCase().equals(f.getFieldName().toLowerCase())).count() > 0L).collect(Collectors.toList());
        return this.findByIdsFields(xmids, list);
    }

    @Override
    public void deleteByXmid(String xmid) {
        this.modelManageService.delObjectById(this.getTableName(), xmid);
    }

    @Override
    public int updateByIds(Iterable<String> xmids, T t) {
        try {
            List xmidList = IteratorUtils.toList(xmids.iterator());
            List xmidGroups = Lists.partition((List)xmidList, (int)3000);
            int count = 0;
            for (List xmidGroup : xmidGroups) {
                ArrayList temp = new ArrayList();
                xmidGroup.forEach(f -> temp.add("'" + f + "'"));
                String where = String.format("%s in (%s)", ((AbstractXmxx)t).getXmidFieldName(), StrUtil.join((CharSequence)",", temp));
                count += this.modelManageService.update(t, this.getTableName(), where, new Object[0]);
            }
            return count;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<Map<String, Object>> stat(String filterParam, EnumXzqLevel xzqLvel, Map<String, EnumStatType> statFields, String ... groupField) {
        AbstractXmxx t = (AbstractXmxx)this.getDefault();
        ModelManageService modelManageService = (ModelManageService)SpringContextUtil.getBean(ModelManageService.class);
        ArrayList selectFields = new ArrayList();
        List<Object> groupFields = new ArrayList();
        if (groupField.length > 0) {
            groupFields = Arrays.stream(groupField).collect(Collectors.toList());
        }
        selectFields.addAll(groupFields);
        switch (xzqLvel) {
            case XJ: {
                selectFields.add(t.getXmXzqdmFieldName());
                groupFields.add(t.getXmXzqdmFieldName());
                break;
            }
            case DSJ: {
                selectFields.add(String.format("substring(%s,1,4)||'00' as %s", t.getXmXzqdmFieldName(), t.getXmXzqdmFieldName()));
                groupFields.add(String.format("substring(%s,1,4)||'00'", t.getXmXzqdmFieldName()));
                break;
            }
            case SJ: {
                selectFields.add(String.format("substring(%s,1,2)||'0000' as %s", t.getXmXzqdmFieldName(), t.getXmXzqdmFieldName()));
                groupFields.add(String.format("substring(%s,1,2)||'0000'", t.getXmXzqdmFieldName()));
            }
        }
        for (Map.Entry<String, EnumStatType> statField : statFields.entrySet()) {
            switch (statField.getValue()) {
                case Count: {
                    selectFields.add(String.format("count(0)::int4 as %s_count", statField.getKey(), statField.getKey()));
                    break;
                }
                case Max: {
                    selectFields.add(String.format("max(%s) as %s_max", statField.getKey(), statField.getKey()));
                    break;
                }
                case Min: {
                    selectFields.add(String.format("min(%s) as %s_min", statField.getKey(), statField.getKey()));
                    break;
                }
                case Avg: {
                    selectFields.add(String.format("avg(%s) as %s_avg", statField.getKey(), statField.getKey()));
                    break;
                }
                case Sum: {
                    selectFields.add(String.format("sum(%s) as %s_sum", statField.getKey(), statField.getKey()));
                    break;
                }
                case WeightAvg: {
                    String[] fields = statField.getKey().split(",");
                    if (fields.length != 2) {
                        throw new RuntimeException("\u52a0\u6743\u5e73\u5747\u5fc5\u987b\u5f97\u914d\u7f6e\u4e24\u4e2a\u5b57\u6bb5");
                    }
                    selectFields.add(String.format("case sum(%s) when 0 then 0 else sum(%s*%s)/sum(%s) end as \"%s_weigthavg\"", fields[1], fields[0], fields[1], fields[1], statField.getKey()));
                }
            }
        }
        QueryParamRes paramRes = this.praseFilterParam(filterParam);
        String where = "";
        if (!StrUtil.isBlank((CharSequence)paramRes.getWhere()) && !paramRes.getWhere().startsWith("and")) {
            where = " and " + paramRes.getWhere();
        }
        String sql = "";
        selectFields.removeIf(f -> StrUtil.isBlank((CharSequence)f));
        groupFields.removeIf(f -> StrUtil.isBlank((CharSequence)f));
        sql = groupFields.size() == 0 ? String.format("select %s from %s where 1=1 %s", String.join((CharSequence)",", selectFields), this.getTableName(), where) : String.format("select %s from %s where 1=1 %s group by %s", String.join((CharSequence)",", selectFields), this.getTableName(), where, String.join((CharSequence)",", groupFields));
        return modelManageService.findList(sql, paramRes.getValues());
    }

    private String saveOrUpdate(T xmxx, SysUser sysUser, List<ModelFields> list, String now, Boolean checkValid) {
        try {
            if (StrUtil.isEmpty((CharSequence)((AbstractXmxx)xmxx).getXmid())) {
                ((AbstractXmxx)xmxx).setXmid(UUID.randomUUID().toString());
                ((AbstractXmxx)xmxx).setCreateDate(now);
                if (StrUtil.isEmpty((CharSequence)((AbstractXmxx)xmxx).getXzqmc()) && sysUser != null) {
                    ((AbstractXmxx)xmxx).setXzqmc(sysUser.getFullXzqmc());
                }
                if (StrUtil.isEmpty((CharSequence)((AbstractXmxx)xmxx).getXzqdm())) {
                    ((AbstractXmxx)xmxx).setXzqdm(sysUser.getXzqdm());
                }
                if (StrUtil.isEmpty((CharSequence)((AbstractXmxx)xmxx).getXmXzqdm())) {
                    ((AbstractXmxx)xmxx).setXmXzqdm(((AbstractXmxx)xmxx).getXzqdm());
                    ((AbstractXmxx)xmxx).setXmXzqmc(RegionServiceUtil.getFullRegionName((String)((AbstractXmxx)xmxx).getXzqdm()));
                }
                if (StrUtil.isBlank((CharSequence)((AbstractXmxx)xmxx).getLsh())) {
                    ((AbstractXmxx)xmxx).setLsh(this.sidService.generateLsh(((AbstractXmxx)xmxx).getXzqdm(), ((AbstractXmxx)xmxx).getLshType()));
                }
                if (StrUtil.isBlank((CharSequence)((AbstractXmxx)xmxx).getUserId()) && sysUser != null) {
                    ((AbstractXmxx)xmxx).setUserId(sysUser.getId());
                }
                if (StrUtil.isBlank((CharSequence)((AbstractXmxx)xmxx).getUserName()) && sysUser != null) {
                    ((AbstractXmxx)xmxx).setUserName(sysUser.getAlisname());
                }
                if (StrUtil.isBlank((CharSequence)((AbstractXmxx)xmxx).getUserTel()) && sysUser != null) {
                    ((AbstractXmxx)xmxx).setUserTel(sysUser.getTel());
                }
                ((AbstractXmxx)xmxx).setUpdateDate(now);
                Object object = this.modelManageService.saveModel(xmxx, this.getTableName(), list, ((AbstractXmxx)xmxx).getUserId(), checkValid.booleanValue());
                return object.toString();
            }
            ((AbstractXmxx)xmxx).setUpdateDate(now);
            this.modelManageService.updateModel(xmxx, list, this.getTableName());
            return ((AbstractXmxx)xmxx).getXmid();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public void saveOrUpdate(T xmxx, SysUser sysUser) {
        List list = this.modelFieldsService.findByTableName(this.getTableName());
        String now = DateUtil.now();
        this.saveOrUpdate(xmxx, sysUser, list, now, false);
    }

    @Override
    public void batchSaveOrUpdate(Iterable<T> xmxxs, SysUser sysUser, boolean checkValid) {
        try {
            String now = DateUtil.now();
            List list = this.modelFieldsService.findByTableName(this.getTableName());
            for (AbstractXmxx xmxx : xmxxs) {
                this.saveOrUpdate(xmxx, sysUser, list, now, checkValid);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

