/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.zbph.dao.base.CheckRepository;
import com.geoway.onemap.zbph.domain.base.BaseCheckDetail;
import com.geoway.onemap.zbph.service.base.BaseCheckService;
import com.geoway.onemap.zbph.supoort.BatchRepository;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseCheckServiceImpl
implements BaseCheckService {
    @Autowired
    private CheckRepository checkRepository;
    @Autowired
    private BatchRepository batchRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(BaseCheckDetail baseCheckDetail) {
        if (StrUtil.isBlank((CharSequence)baseCheckDetail.getId())) {
            baseCheckDetail.setId(UUID.randomUUID().toString());
            baseCheckDetail.setCheckDate(new Date());
        }
        this.checkRepository.save(baseCheckDetail);
    }

    @Override
    public void batchSaveOrUpdate(List<BaseCheckDetail> baseCheckDetails) {
        for (BaseCheckDetail baseCheckDetail : baseCheckDetails) {
            if (!StrUtil.isBlank((CharSequence)baseCheckDetail.getId())) continue;
            baseCheckDetail.setId(UUID.randomUUID().toString());
            baseCheckDetail.setCheckDate(new Date());
        }
        this.batchRepository.batchInsert(baseCheckDetails);
    }

    @Override
    public List<BaseCheckDetail> findByProcessId(String processId) {
        return this.checkRepository.findByXmid(processId);
    }

    @Override
    public void deleteByProcessId(String processId) {
        this.checkRepository.deleteByXmid(processId);
    }
}

