/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumLockType;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.dao.base.LshRepository;
import com.geoway.onemap.zbph.domain.base.BaseLsh;
import com.geoway.onemap.zbph.domain.base.BaseLshConfig;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseLshServiceImpl
implements BaseLshService {
    private static final Logger log = LoggerFactory.getLogger(BaseLshServiceImpl.class);
    @Autowired
    private LshRepository lshRepository;
    @Autowired
    private LockUtil lockUtil;

    @Override
    public String generateLsh(String xzqdm) {
        return this.generateLsh(xzqdm, EnumLshType.LSH);
    }

    @Override
    public String generateLsh(String xzqdm, EnumLshType lshType) {
        return this.generateLsh(xzqdm, lshType, new Date());
    }

    @Override
    public String generateLsh(String xzqdm, EnumLshType lshType, Date date) {
        List<BaseLshConfig> rules = ConfigConstant.LshConfig.Rules;
        if (rules != null && rules.stream().anyMatch(f -> f.getType().equals(lshType.toValue()))) {
            BaseLshConfig baseLshConfig = rules.stream().filter(f -> f.getType().equals(lshType.toValue())).findAny().get();
            return this.generateLsh(lshType.toValue(), xzqdm, date, baseLshConfig.getDateFormat(), baseLshConfig.getSortLength(), baseLshConfig.getSortStart());
        }
        switch (lshType) {
            case YJ: 
            case BCGDLX: 
            case BCGDYS_Z: 
            case BCGDYS_G: 
            case BCGDYS_J: 
            case BCGDYS_Q: 
            case BCGDYS_K: {
                return this.generateLsh(lshType, xzqdm, date, "yyyy", 4);
            }
            case ZBK: {
                return this.generateLsh(lshType, xzqdm, date, "yyMMdd", 6);
            }
            case LSH: 
            case ZBKJ: 
            case ZBHZ: 
            case ZBDJ: 
            case ZBHJ: 
            case ZGCK: {
                return this.generateLsh(lshType, xzqdm, date, "yyMMdd", 6);
            }
            case BCGDXXQRD: {
                return this.generateLsh(lshType, xzqdm, date, "yyyy", 8);
            }
        }
        return this.generateLsh(lshType, xzqdm, date, "yyMMdd", 6);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateLsh(EnumLshType lshType, String xzqDm, String dateFormat, int sort_length) {
        return this.generateLsh(lshType.toValue(), xzqDm, dateFormat, sort_length);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateLsh(String lshType, String xzqDm, Date date, String dateFormat, int sort_length) {
        return this.generateLsh(lshType, xzqDm, date, dateFormat, sort_length, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateLsh(String lshType, String xzqDm, Date date, String dateFormat, int sort_length, int sort_start) {
        String lsh = null;
        String dateCode = new SimpleDateFormat(dateFormat).format(date);
        String lockCacheKey = lshType + xzqDm + dateCode;
        try {
            Long serialNo;
            BaseLsh baseLsh;
            if (this.lockUtil.getLock(lockCacheKey, EnumLockType.LSH)) {
                baseLsh = this.lshRepository.findByKeyey(lockCacheKey);
                serialNo = null;
                serialNo = baseLsh != null ? Long.valueOf(Long.parseLong(baseLsh.getSerialNo()) + 1L) : Long.valueOf(Integer.valueOf(sort_start).longValue());
                lsh = this.getCodeOfSix(lockCacheKey, sort_length, serialNo.intValue());
                if (baseLsh == null) {
                    baseLsh = new BaseLsh();
                    baseLsh.setCreateTime(new Date());
                    baseLsh.setUpdateTime(new Date());
                    baseLsh.setDate(dateCode);
                    baseLsh.setId(UUID.randomUUID().toString());
                    baseLsh.setKey(lockCacheKey);
                    baseLsh.setType(lshType);
                    baseLsh.setXzqdm(xzqDm);
                    baseLsh.setXzqmc(xzqDm);
                } else {
                    baseLsh.setUpdateTime(new Date());
                }
            } else {
                throw new RuntimeException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            baseLsh.setLsh(lsh);
            baseLsh.setSerialNo(serialNo.toString());
            this.lshRepository.save(baseLsh);
        }
        catch (Exception e) {
            throw new RuntimeException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff1a" + e.getMessage());
        }
        return lsh;
    }

    @Override
    public String generateLsh(EnumLshType lshType, String xzqDm, Date date, String dateFormat, int sort_length) {
        return this.generateLsh(lshType.toValue(), xzqDm, date, dateFormat, sort_length);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateLsh(String lshType, String xzqDm, String dateFormat, int sort_length) {
        return this.generateLsh(lshType, xzqDm, new Date(), dateFormat, sort_length);
    }

    private String getCodeOfSix(String prefix, int sort_length, int nowNum) {
        StringBuilder numSb = new StringBuilder(prefix);
        int num = sort_length - String.valueOf(nowNum).length();
        for (int i = 0; i < num; ++i) {
            numSb.append("0");
        }
        numSb.append(nowNum);
        return numSb.toString();
    }

    private static int getSeconds() {
        Calendar curDate = Calendar.getInstance();
        GregorianCalendar tomorrowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
        return (int)(tomorrowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000 + 1000;
    }
}

