/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.io.FileUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.dto.base.WordFillDTO;
import com.geoway.onemap.zbph.service.base.BaseQrdManageService;
import com.geoway.onemap.zbph.supoort.BarcodeUtil;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.geoway.onemap.zbph.supoort.WordManageUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseQrdManageServiceImpl
implements BaseQrdManageService {
    @Autowired
    private GeoserverUtil geoserverUtil;

    @Override
    public String getBcgdQrdPdf(List<WordFillDTO> list, String qrd, String qrText, String tempName, String fileName, String type) {
        String tempPath = ConfigConstant.FileConfig.templateDir + File.separator + (StringUtils.isEmpty((CharSequence)tempName) ? "\u6062\u590d\u8015\u5730\u8865\u5145\u4fe1\u606f\u786e\u8ba4\u5355-\u6a21\u677f" : tempName) + ".docx";
        String wordPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + fileName + "-\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355.docx";
        String txmPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + "txm" + UUID.randomUUID() + ".png";
        String qrPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + "qr" + UUID.randomUUID() + ".png";
        String pdfPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + fileName + "-\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355.pdf";
        try {
            WordManageUtil.wordFill(tempPath, wordPath, list);
            BarcodeUtil.create(qrd, txmPath);
            if (qrText != null) {
                BarcodeUtil.createQr(qrText, qrPath, 100);
                WordManageUtil.inertImage(wordPath, qrPath, txmPath);
            } else {
                WordManageUtil.inertImage(wordPath, txmPath);
            }
            if (ConfigConstant.TbrkConfig.userDocument.booleanValue()) {
                this.wordToPdf(wordPath, pdfPath);
            } else {
                WordManageUtil.toPdf2(wordPath, pdfPath);
            }
            String string = pdfPath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            FileUtil.del((String)wordPath);
            FileManageUtil.deleteForceFile(txmPath);
            FileUtil.del((String)txmPath);
            FileUtil.del((String)qrPath);
        }
    }

    @Override
    public String getBcgdQrdPdf(String fileName, String type) {
        String pdfPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + fileName + "-\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355.pdf";
        if (FileUtil.exist((String)pdfPath)) {
            return pdfPath;
        }
        return null;
    }

    @Override
    public void deleteBcgdQrdPdf(String fileName, String type) {
        String pdfPath = ConfigConstant.FileConfig.uploadDir + File.separator + "qrd" + File.separator + type + File.separator + fileName + "-\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355.pdf";
        if (FileUtil.exist((String)pdfPath)) {
            FileUtil.del((String)pdfPath);
        }
    }

    private void wordToPdf(String wordPath, String pdfPath) {
        InputStream inputStream = this.geoserverUtil.httpWordToPdf(wordPath, pdfPath);
        FileManageUtil.createFiles(inputStream, pdfPath);
    }
}

