/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.geoway.onemap.zbph.dao.base.CheckStateDictRepository;
import com.geoway.onemap.zbph.domain.base.CheckStateDict;
import com.geoway.onemap.zbph.service.base.CheckStateDictService;
import com.google.api.client.util.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Service
public class CheckStateDictServiceImpl
implements CheckStateDictService,
ApplicationListener<ServletRequestHandledEvent> {
    @Autowired
    private CheckStateDictRepository checkStateDictRepository;
    private ThreadLocal<List<CheckStateDict>> threadDicts = new ThreadLocal();

    @Override
    public List<CheckStateDict> findAll() {
        if (this.threadDicts.get() == null) {
            this.threadDicts.set(Lists.newArrayList((Iterable)this.checkStateDictRepository.findAll()));
        }
        return this.threadDicts.get();
    }

    @Override
    public CheckStateDict findByState(String state) {
        List<CheckStateDict> dictList = this.findAll();
        return dictList.stream().filter(f -> f.getCheckState().toUpperCase().equals(state.toUpperCase())).findFirst().orElse(null);
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        this.threadDicts.set(null);
    }
}

