/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.base.EnumCheckResult;
import com.geoway.onemap.zbph.constant.base.EnumInvokeType;
import com.geoway.onemap.zbph.constant.base.EnumUserLevel;
import com.geoway.onemap.zbph.dao.base.ProcessInstaceRepository;
import com.geoway.onemap.zbph.domain.base.BaseCheckDetail;
import com.geoway.onemap.zbph.domain.base.ProcessInstance;
import com.geoway.onemap.zbph.domain.base.ProcessModel;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.ProcessTaskEvent;
import com.geoway.onemap.zbph.domain.base.RefObject;
import com.geoway.onemap.zbph.domain.base.TaskListenerDetail;
import com.geoway.onemap.zbph.service.base.BaseCheckService;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.base.ProcessModelService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    @Autowired
    private ProcessModelService modelService;
    @Autowired
    private ProcessInstaceRepository instaceRepository;
    @Autowired
    private BaseCheckService baseCheckService;

    @Override
    public List<ProcessInstance> findByIds(List<String> processIds) {
        List idGroups = Lists.partition(processIds, (int)3000);
        ArrayList<ProcessInstance> results = new ArrayList<ProcessInstance>();
        idGroups.forEach(g -> results.addAll(this.instaceRepository.findByIds((List<String>)g)));
        ArrayList models = new ArrayList();
        results.forEach(f -> {
            ProcessModel processModel = models.stream().filter(g -> g.getId().equals(f.getModelId())).findFirst().orElse(null);
            if (processModel == null) {
                processModel = this.modelService.findById(f.getModelId());
                models.add(processModel);
            }
            f.setProcessModel(processModel);
        });
        return results;
    }

    @Override
    public ProcessInstance findById(String processId) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(processId);
        return this.findByIds(ids).get(0);
    }

    @Override
    public ProcessInstance createInstance(String modelName, SysUser sysUser) {
        ProcessModel processModel = this.modelService.findByName(modelName);
        return this.createInstance(processModel, sysUser);
    }

    @Override
    public ProcessInstance createInstance(ProcessModel processModel, SysUser sysUser) {
        ProcessTaskEvent processTaskEvent;
        ProcessInstance processInstance = new ProcessInstance();
        processInstance.setModelId(processModel.getId());
        processInstance.setId(UUID.randomUUID().toString());
        ProcessStep curStep = processModel.getSteps().get(0);
        processInstance.setProcessState(curStep.getProcessState());
        processInstance.setProcessStateStr(curStep.getProcessStateStr());
        processInstance.setCheckstate(curStep.getCheckState());
        processInstance.setCheckStateStr(curStep.getCheckStateStr());
        if (curStep.getTaskListeners() != null && curStep.getTaskListeners().stream().filter(f -> f.getInvokeType().equals(EnumInvokeType.before.toValue())).count() > 0L) {
            processTaskEvent = new ProcessTaskEvent();
            processTaskEvent.setCheckResult(EnumCheckResult.Pass);
            processTaskEvent.setInstance(processInstance);
            processTaskEvent.setSysUser(sysUser);
            processTaskEvent.setCheckFileName("");
            processTaskEvent.setCheckFilePath("");
            curStep.getTaskListeners().stream().filter(f -> f.getInvokeType().equals(EnumInvokeType.before.toValue())).forEach(f -> f.invoke(processTaskEvent));
        }
        if (curStep.getTaskListeners() != null && curStep.getTaskListeners().stream().filter(f -> f.getInvokeType().equals(EnumInvokeType.after.toValue())).count() > 0L) {
            processTaskEvent = new ProcessTaskEvent();
            processTaskEvent.setCheckResult(EnumCheckResult.Pass);
            processTaskEvent.setInstance(processInstance);
            processTaskEvent.setSysUser(sysUser);
            processTaskEvent.setCheckFileName("");
            processTaskEvent.setCheckFilePath("");
            curStep.getTaskListeners().stream().filter(f -> f.getInvokeType().equals(EnumInvokeType.after.toValue())).forEach(f -> f.invoke(processTaskEvent));
        }
        this.instaceRepository.save(processInstance);
        return processInstance;
    }

    @Override
    public ProcessStep refused(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag) {
        return this.refused(sysUser, processInstances, comment, checkFileName, checkFilePath, "", tag);
    }

    @Override
    public ProcessStep refused(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String refusedState, String tag) {
        ProcessInstance processInstance = processInstances.get(0);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), processInstance.getProcessState());
        if (StrUtil.isBlank((CharSequence)curStep.getRefusedState())) {
            throw new RuntimeException("\u672a\u5b9a\u4e49\u56de\u9000\u72b6\u6001,\u65e0\u6cd5\u56de\u9000,\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e");
        }
        if (StrUtil.isNotBlank((CharSequence)refusedState) && !curStep.getRefusedStatesMap().containsKey(refusedState)) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u56de\u9000\u56de\u9000\u5230\u3010%s\u3011,\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e", refusedState));
        }
        refusedState = StrUtil.isNotBlank((CharSequence)refusedState) ? refusedState : curStep.getRefusedStates().get(0);
        ProcessStep refusedStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), refusedState);
        if (refusedStep == null) {
            throw new RuntimeException(String.format("\u672a\u627e\u5230\u3010%s\u3011\u5bf9\u5e94\u7684\u6d41\u7a0b\u6b65\u9aa4\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e", curStep.getCheckStateStr()));
        }
        List roleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        if (!curStep.getRelatedRoles().contains("*") && curStep.getRelatedRoles().stream().filter(f -> roleNames.contains(f)).count() == 0L) {
            throw new RuntimeException(String.format("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\uff0c\u65e0\u6cd5\u6d41\u8f6c", new Object[0]));
        }
        List<ProcessTaskEvent> processTaskEvents = this.getProcessTaskEvents(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, EnumCheckResult.Refused);
        List<TaskListenerDetail> taskListeners = this.getTaskListenerDetails(refusedStep, EnumInvokeType.before, EnumCheckResult.Refused, true);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        List idGroups = Lists.partition(processInstances.stream().map(f -> f.getId()).collect(Collectors.toList()), (int)1000);
        for (List processIds : idGroups) {
            this.instaceRepository.update(refusedState, curStep.getRefusedStatesMap().get(refusedState), refusedStep.getCheckState(), refusedStep.getCheckStateStr(), processIds);
        }
        taskListeners = this.getTaskListenerDetails(refusedStep, EnumInvokeType.after, EnumCheckResult.Refused, true);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        if (!curStep.getCheckState().equals(refusedStep.getCheckState())) {
            List<BaseCheckDetail> baseCheckDetails = this.getBaseCheckDetails(sysUser, processInstances, comment, checkFileName, checkFilePath, refusedState, curStep.getRefusedStatesMap().get(refusedState), EnumCheckResult.Refused);
            this.baseCheckService.batchSaveOrUpdate(baseCheckDetails);
        }
        refusedStep.setProcessState(refusedState);
        refusedStep.setProcessStateStr(curStep.getRefusedStatesMap().get(refusedState));
        refusedStep = this.getVirtualProcessStep(processInstances.get(0).getId());
        return refusedStep;
    }

    @Override
    public ProcessStep revert(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag) {
        ProcessStep revertStep;
        ProcessInstance processInstance = processInstances.get(0);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), processInstance.getProcessState());
        if (StrUtil.isBlank((CharSequence)curStep.getRevertState())) {
            throw new RuntimeException("\u53ea\u6709\u3010\u4e0a\u7ea7\u5ba1\u6838\u4e2d\u3011\u7684\u6570\u636e\u624d\u80fd\u3010\u64a4\u56de\u3011");
        }
        if (StrUtil.isBlank((CharSequence)curStep.getRevertStateStr())) {
            Map<String, String> totalMap = this.modelService.getTotalProcessStateMap(processInstance.getProcessModel());
            curStep.setRevertStateStr(totalMap.get(curStep.getRevertState()));
        }
        if ((revertStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), curStep.getRevertState())) == null) {
            throw new RuntimeException(String.format("\u672a\u627e\u5230\u3010%s\u3011\u5bf9\u5e94\u7684\u6d41\u7a0b\u6b65\u9aa4\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e", curStep.getCheckStateStr()));
        }
        List roleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        if (!revertStep.getRelatedRoles().contains("*") && revertStep.getRelatedRoles().stream().filter(f -> roleNames.contains(f)).count() == 0L) {
            throw new RuntimeException(String.format("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\uff0c\u65e0\u6cd5\u64a4\u56de", new Object[0]));
        }
        List<ProcessTaskEvent> processTaskEvents = this.getProcessTaskEvents(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, EnumCheckResult.Revert);
        List<TaskListenerDetail> taskListeners = this.getTaskListenerDetails(revertStep, EnumInvokeType.before, EnumCheckResult.Revert, false);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        List idGroups = Lists.partition(processInstances.stream().map(f -> f.getId()).collect(Collectors.toList()), (int)1000);
        for (List processIds : idGroups) {
            this.instaceRepository.update(curStep.getRevertState(), curStep.getRevertStateStr(), revertStep.getCheckState(), revertStep.getCheckStateStr(), processIds);
        }
        taskListeners = this.getTaskListenerDetails(revertStep, EnumInvokeType.after, EnumCheckResult.Revert, false);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        List<BaseCheckDetail> baseCheckDetails = this.getBaseCheckDetails(sysUser, processInstances, comment, checkFileName, checkFilePath, curStep.getRevertState(), curStep.getRevertStateStr(), EnumCheckResult.Revert);
        this.baseCheckService.batchSaveOrUpdate(baseCheckDetails);
        revertStep = this.getVirtualProcessStep(processInstances.get(0).getId());
        return revertStep;
    }

    @Override
    public ProcessStep pass(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag, RefObject<Boolean> finishRef) {
        ProcessInstance processInstance = processInstances.get(0);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstances.get(0).getProcessModel(), processInstance.getProcessState());
        String nextState = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), processInstance.getProcessState());
        if (StrUtil.isBlank((CharSequence)nextState)) {
            throw new RuntimeException(String.format("\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6838\u7ed3\u675f\uff0c\u65e0\u6cd5\u6d41\u8f6c", new Object[0]));
        }
        List roleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        if (!curStep.getRelatedRoles().contains("*") && curStep.getRelatedRoles().stream().filter(f -> roleNames.contains(f)).count() == 0L) {
            throw new RuntimeException(String.format("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\uff0c\u65e0\u6cd5\u6d41\u8f6c", new Object[0]));
        }
        ProcessStep nextStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), nextState);
        List<ProcessTaskEvent> processTaskEvents = this.getProcessTaskEvents(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, EnumCheckResult.Pass);
        List<TaskListenerDetail> taskListeners = this.getTaskListenerDetails(nextStep, EnumInvokeType.before, EnumCheckResult.Pass, true);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        List idGroups = Lists.partition(processInstances.stream().map(f -> f.getId()).collect(Collectors.toList()), (int)1000);
        for (List processIds : idGroups) {
            this.instaceRepository.update(nextStep.getProcessState(), nextStep.getProcessStateStr(), nextStep.getCheckState(), nextStep.getCheckStateStr(), processIds);
        }
        if (!curStep.getCheckState().equals(nextStep.getCheckState())) {
            List<BaseCheckDetail> baseCheckDetails = this.getBaseCheckDetails(sysUser, processInstances, comment, checkFileName, checkFilePath, curStep.getCheckState(), curStep.getCheckStateStr(), EnumCheckResult.Pass);
            this.baseCheckService.batchSaveOrUpdate(baseCheckDetails);
        }
        String nextNextStep = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), nextState);
        finishRef.set(StrUtil.isBlank((CharSequence)nextNextStep));
        taskListeners = this.getTaskListenerDetails(nextStep, EnumInvokeType.after, EnumCheckResult.Pass, true);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        return this.getVirtualProcessStep(processInstances.get(0).getId());
    }

    @Override
    public ProcessStep forcePass(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag, RefObject<Boolean> finishRef) {
        ProcessInstance processInstance = processInstances.get(0);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), processInstance.getProcessState());
        String nextState = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), curStep.getProcessState());
        if (StrUtil.isBlank((CharSequence)nextState)) {
            throw new RuntimeException(String.format("\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6838\u7ed3\u675f\uff0c\u65e0\u6cd5\u6d41\u8f6c", new Object[0]));
        }
        ProcessStep nextStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), nextState);
        List idGroups = Lists.partition(processInstances.stream().map(f -> f.getId()).collect(Collectors.toList()), (int)1000);
        for (List processIds : idGroups) {
            this.instaceRepository.update(nextStep.getProcessState(), nextStep.getProcessStateStr(), nextStep.getCheckState(), nextStep.getCheckStateStr(), processIds);
        }
        if (!curStep.getCheckState().equals(nextStep.getCheckState())) {
            List<BaseCheckDetail> baseCheckDetails = this.getBaseCheckDetails(sysUser, processInstances, comment, checkFileName, checkFilePath, curStep.getCheckState(), curStep.getCheckStateStr(), EnumCheckResult.ForcePass);
            this.baseCheckService.batchSaveOrUpdate(baseCheckDetails);
        }
        String nextNextStep = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), nextState);
        finishRef.set(StrUtil.isBlank((CharSequence)nextNextStep));
        nextStep = this.getVirtualProcessStep(processInstances.get(0).getId());
        return nextStep;
    }

    @Override
    public ProcessStep stop(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag, RefObject<Boolean> finishRef) {
        ProcessInstance processInstance = processInstances.get(0);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstances.get(0).getProcessModel(), processInstance.getProcessState());
        if (StrUtil.isBlank((CharSequence)curStep.getStopState())) {
            throw new RuntimeException(String.format("\u8be5\u73af\u8282\u65e0\u6cd5\u7ec8\u6b62\uff0c\u8bf7\u6838\u67e5\uff01", new Object[0]));
        }
        List roleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        if (!curStep.getRelatedRoles().contains("*") && curStep.getRelatedRoles().stream().filter(f -> roleNames.contains(f)).count() == 0L) {
            throw new RuntimeException(String.format("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\uff0c\u65e0\u6cd5\u7ec8\u6b62", new Object[0]));
        }
        List<ProcessTaskEvent> processTaskEvents = this.getProcessTaskEvents(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, EnumCheckResult.Stop);
        List<TaskListenerDetail> taskListeners = this.getTaskListenerDetails(curStep, EnumInvokeType.before, EnumCheckResult.Stop, false);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        List idGroups = Lists.partition(processInstances.stream().map(f -> f.getId()).collect(Collectors.toList()), (int)1000);
        for (List processIds : idGroups) {
            this.instaceRepository.update(curStep.getStopState(), curStep.getStopStateStr(), curStep.getCheckState(), curStep.getCheckStateStr(), processIds);
        }
        List<BaseCheckDetail> baseCheckDetails = this.getBaseCheckDetails(sysUser, processInstances, comment, checkFileName, checkFilePath, curStep.getStopState(), curStep.getStopStateStr(), EnumCheckResult.Stop);
        this.baseCheckService.batchSaveOrUpdate(baseCheckDetails);
        taskListeners = this.getTaskListenerDetails(curStep, EnumInvokeType.after, EnumCheckResult.Stop, false);
        taskListeners.forEach(f -> f.invoke(processTaskEvents));
        String nextNextStep = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), curStep.getProcessState());
        finishRef.set(StrUtil.isBlank((CharSequence)nextNextStep));
        return this.getVirtualProcessStep(processInstances.get(0).getId());
    }

    @Override
    public ProcessStep getCurrentStep(String processId) {
        ProcessInstance processInstance = this.findById(processId);
        ProcessStep curStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), processInstance.getProcessState());
        return curStep;
    }

    @Override
    public ProcessStep getNextStep(String processId) {
        ProcessInstance processInstance = this.findById(processId);
        String nextState = this.modelService.getNextProcessStateByPass(processInstance.getProcessModel(), processInstance.getProcessState());
        if (StrUtil.isBlank((CharSequence)nextState)) {
            return null;
        }
        ProcessStep nextStep = this.modelService.getStepByProcessState(processInstance.getProcessModel(), nextState);
        return nextStep;
    }

    private List<ProcessTaskEvent> getProcessTaskEvents(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String tag, EnumCheckResult checkResult) {
        ArrayList<ProcessTaskEvent> processTaskEvents = new ArrayList<ProcessTaskEvent>();
        for (ProcessInstance temp : processInstances) {
            ProcessTaskEvent processTaskEvent = new ProcessTaskEvent();
            processTaskEvent.setCheckResult(checkResult);
            processTaskEvent.setInstance(temp);
            processTaskEvent.setSysUser(sysUser);
            processTaskEvent.setTag(tag);
            processTaskEvents.add(processTaskEvent);
            processTaskEvent.setCheckFileName(checkFileName);
            processTaskEvent.setCheckFilePath(checkFilePath);
        }
        return processTaskEvents;
    }

    private ProcessStep getVirtualProcessStep(String processId) {
        ProcessStep processStep = new ProcessStep();
        ProcessInstance processInstance = this.findById(processId);
        processStep.setProcessState(processInstance.getProcessState());
        processStep.setProcessStateStr(processInstance.getProcessStateStr());
        processStep.setCheckState(processInstance.getCheckstate());
        processStep.setCheckStateStr(processInstance.getCheckStateStr());
        return processStep;
    }

    private List<BaseCheckDetail> getBaseCheckDetails(SysUser sysUser, List<ProcessInstance> processInstances, String comment, String checkFileName, String checkFilePath, String processState, String processStateStr, EnumCheckResult checkResult) {
        ArrayList<BaseCheckDetail> baseCheckDetails = new ArrayList<BaseCheckDetail>();
        for (ProcessInstance temp : processInstances) {
            BaseCheckDetail baseCheckDetail = new BaseCheckDetail();
            baseCheckDetail.setId(UUID.randomUUID().toString());
            baseCheckDetail.setCheckComment(comment);
            baseCheckDetail.setCheckDate(new Date());
            baseCheckDetail.setProcessId(temp.getId());
            baseCheckDetail.setCheckState(processState);
            baseCheckDetail.setCheckStateStr(processStateStr);
            baseCheckDetail.setCheckFileName(checkFileName);
            baseCheckDetail.setCheckFilePath(checkFilePath);
            if (sysUser != null) {
                baseCheckDetail.setCheckUserLevel(EnumUserLevel.fromSysUser(sysUser).toValue());
                baseCheckDetail.setCheckUserName(sysUser.getAlisname());
                baseCheckDetail.setCheckUserId(sysUser.getId());
            }
            baseCheckDetail.setCheckResult(checkResult.toValue());
            baseCheckDetails.add(baseCheckDetail);
        }
        return baseCheckDetails;
    }

    private List<TaskListenerDetail> getTaskListenerDetails(ProcessStep step, EnumInvokeType invokeType, EnumCheckResult checkResult, boolean containNullCheckResult) {
        ArrayList<TaskListenerDetail> taskListeners;
        List<TaskListenerDetail> list = taskListeners = step.getTaskListeners() == null ? new ArrayList<TaskListenerDetail>() : step.getTaskListeners().stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getInvokeType()) && f.getInvokeType().equals(invokeType.toValue()) && StrUtil.isNotBlank((CharSequence)f.getInvokeCheckResult()) && f.getInvokeCheckResult().equals(checkResult.toDesc())).collect(Collectors.toList());
        if (containNullCheckResult) {
            taskListeners.addAll(step.getTaskListeners().stream().filter(f -> f.getInvokeType().equals(invokeType.toValue()) && StrUtil.isBlank((CharSequence)f.getInvokeCheckResult())).collect(Collectors.toList()));
        }
        return taskListeners;
    }
}

