/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.wyhc.impl;

import cn.hutool.core.io.FileUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.base.BaseXmxx;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXzgdfwService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXzgdfwService;
import com.geoway.zhgd.dao.OutCheckGtyDao;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstracGtyPushServiceImpl {
    @Value(value="${project.gty.dir:''}")
    protected String gtyDir;
    @Autowired
    protected XfsbcgdLxXmxxService lxXmxxService;
    @Autowired
    protected XfsbcgdLxXzgdfwService lxXzgdfwService;
    @Autowired
    protected XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    protected XfsbcgdYsXzgdfwService ysXzgdfwService;
    @Autowired
    protected OutCheckGtyDao outCheckGtyDao;

    protected void start(BusinessPushDTO dto) {
        String type = dto.getType();
        String xmid = dto.getXmid();
        String[] ids = xmid.split(",");
        ArrayList<Map<String, Object>> xzgdfwList = new ArrayList<Map<String, Object>>();
        ArrayList<OutCheckGty> outCheckGties = new ArrayList<OutCheckGty>();
        BaseXmxx xmxx = null;
        for (String projectId : ids) {
            File file = null;
            try {
                BaseXmxx baseXmxx = xmxx = type.equals(XmxxType.LX.gtyType) ? (BaseXmxx)this.lxXmxxService.findById(projectId) : (BaseXmxx)this.ysXmxxService.findById(projectId);
                if (xmxx == null) continue;
                if (type.equals(XmxxType.LX.gtyType)) {
                    this.getBlocksLx(projectId, xmxx.getXmmc(), xmxx.getXmbh(), outCheckGties, xzgdfwList);
                } else {
                    this.getBlocksYs(projectId, xmxx.getXmmc(), xmxx.getXmbh(), outCheckGties, xzgdfwList);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String time = sdf.format(new Date());
                String dir = this.gtyDir + "/" + type + "/" + type.toUpperCase() + "_" + time;
                file = this.generateGty(xzgdfwList, dir);
                String importId = this.uploadFile(file, xmid, XmxxType.getByGtytype((String)type).type);
                if (outCheckGties.size() > 0) {
                    outCheckGties.forEach(f -> f.setImportId(importId));
                    this.outCheckGtyDao.saveAll(outCheckGties);
                }
                FileUtil.del((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("\u3010" + xmxx.getXmmc() + "\u3011\u5916\u4e1a\u6838\u67e5\u5305\u5904\u7406\u5931\u8d25\uff1a" + e);
            }
            finally {
                FileUtil.del(file);
            }
        }
    }

    protected abstract void getBlocksLx(String var1, String var2, String var3, List<OutCheckGty> var4, List<Map<String, Object>> var5);

    protected abstract void getBlocksYs(String var1, String var2, String var3, List<OutCheckGty> var4, List<Map<String, Object>> var5);

    protected abstract File generateGty(List<Map<String, Object>> var1, String var2) throws IOException;

    protected abstract String uploadFile(File var1, String var2, String var3);
}

