/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.wyhc.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.util.Md5Util;
import com.geoway.onemap.core.support.FileUtil;
import com.geoway.onemap.core.support.HttpsUtil;
import com.geoway.onemap.core.support.ShapeUtil;
import com.geoway.onemap.core.support.Zip4jUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.base.BaseXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXzgdfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXzgdfw;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.service.wyhc.BusinessVerifyPushService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXzgdfwService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXzgdfwService;
import com.geoway.zhgd.dao.OutCheckGtyDao;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty")
public class GtyVerifyPushServiceImpl
implements BusinessVerifyPushService {
    private final String GTY_TOKEN = "gty_token";
    @Value(value="${project.gty.dir:''}")
    protected String gtyDir;
    @Value(value="${gty.base.url:'https://www.landcloud.org.cn:9553'}")
    protected String gtyUrl;
    @Value(value="${gty.token.url:'/mdc/v2/auth/tokenByKey'}")
    protected String gtyTokenUrl;
    @Value(value="${gty.store.url:'/mdc/v2/storage/tempurl'}")
    protected String gtyStore;
    @Value(value="${gty.notice.url:'/mdc/v2/taskData/gty'}")
    protected String noticeStore;
    @Value(value="${gty.ak:'gwbe549e73-7d2b-4a5d-b090-450b22505ed0'}")
    protected String appKey;
    @Value(value="${gty.sk:'0a18f48-4f97-4559-9624-353752757dd2'}")
    protected String appSecret;
    @Value(value="${gty.bizId:'6c0f1af9-747a-4cc0-9652-4ae31ee3179f'}")
    protected String bizId;
    @Autowired
    private XfsbcgdLxXmxxService lxXmxxService;
    @Autowired
    private XfsbcgdLxXzgdfwService lxXzgdfwService;
    @Autowired
    private XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    private XfsbcgdYsXzgdfwService ysXzgdfwService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private OutCheckGtyDao outCheckGtyDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateStart(BusinessPushDTO dto) {
        String type = dto.getType();
        String xmid = dto.getXmid();
        String[] ids = xmid.split(",");
        ArrayList<Map<String, Object>> xzgdfwList = new ArrayList<Map<String, Object>>();
        ArrayList<OutCheckGty> outCheckGties = new ArrayList<OutCheckGty>();
        BaseXmxx xmxx = null;
        for (String projectId : ids) {
            File file = null;
            try {
                BaseXmxx baseXmxx = xmxx = type.equals(XmxxType.LX.gtyType) ? (BaseXmxx)this.lxXmxxService.findById(projectId) : (BaseXmxx)this.ysXmxxService.findById(projectId);
                if (xmxx == null) continue;
                if (type.equals(XmxxType.LX.gtyType)) {
                    this.getBlocksLx(projectId, xmxx.getXmmc(), xmxx.getXmbh(), outCheckGties, xzgdfwList);
                } else {
                    this.getBlocksYs(projectId, xmxx.getXmmc(), xmxx.getXmbh(), outCheckGties, xzgdfwList);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String time = sdf.format(new Date());
                String dir = this.gtyDir + "/" + type + "/" + type.toUpperCase() + "_" + time;
                file = this.generateGty(xzgdfwList, dir);
                String importId = this.uploadFile(file);
                if (outCheckGties.size() > 0) {
                    outCheckGties.forEach(f -> f.setImportId(importId));
                    this.outCheckGtyDao.saveAll(outCheckGties);
                }
                cn.hutool.core.io.FileUtil.del((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("\u3010" + xmxx.getXmmc() + "\u3011\u5916\u4e1a\u6838\u67e5\u5305\u5904\u7406\u5931\u8d25\uff1a" + e);
            }
            finally {
                cn.hutool.core.io.FileUtil.del(file);
            }
        }
    }

    public String uploadFile(File file) throws Exception {
        String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
        JSONObject tempUrlObj = this.getTempUrl();
        String writeUrl = tempUrlObj.getString("writeUrl");
        byte[] bytes = FileUtil.fileConvertToByteArray((File)file);
        HttpsUtil.httpsRequestPost((String)writeUrl, (String)"PUT", (byte[])bytes);
        HttpRequest request = this.getRequest(this.noticeStore, Method.POST);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bizId", this.bizId);
        map.put("filePath", tempUrlObj.getString("readUrl"));
        map.put("fileName", fileName);
        map.put("hash", Md5Util.getFileMd5Str((File)file));
        map.put("updateType", "0");
        request.body(JSON.toJSONString(map));
        return (String)this.getRes(request.execute(), this.noticeStore, String.class);
    }

    public File generateGty(List<Map<String, Object>> XZGDFW, String dir) throws Exception {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (XZGDFW.size() > 0) {
            String path = dir + "/XZGDFW.shp";
            ArrayList<String> attrKeys = new ArrayList<String>(XZGDFW.get(0).keySet());
            attrKeys.remove("WKT");
            ShapeUtil.write2Shape((String)path, (String)"UTF-8", (String)"MultiPolygon", (String)"WKT", attrKeys, XZGDFW);
        }
        String zipUrl = dir;
        zipUrl = Zip4jUtil.zip((String)zipUrl, (boolean)false, (String)"");
        File zipFile = new File(zipUrl);
        String gtyPath = zipUrl.substring(0, zipUrl.lastIndexOf(".")) + ".gty";
        File gtyFile = new File(gtyPath);
        zipFile.renameTo(gtyFile);
        FileUtils.forceDelete((File)dirFile);
        return gtyFile;
    }

    private void getBlocksLx(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdLxXzgdfw> xzgdfws = this.lxXzgdfwService.findByPid(projectId);
        for (XfsbcgdLxXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("f_bsm", bsm);
            map.put("f_xzqdm", xzgdfw.getXzqdm());
            map.put("DIKUAI_NO", xzgdfw.getDkbh());
            map.put("PL_NAME", xzgdfw.getDkmc());
            map.put("DIKUAIAREA", xzgdfw.getDkmj());
            map.put("PURPOSE", xzgdfw.getDkyt());
            map.put("MAP_NO", xzgdfw.getTfh());
            map.put("PATCHTYPE", xzgdfw.getTblx());
            map.put("LANDTYPE", xzgdfw.getDlbm());
            map.put("AVGGRADE1", xzgdfw.getGzqpjzldb());
            map.put("AVGGRADE2", xzgdfw.getGzhpjzldb());
            map.put("JBXX_XMMC", jbxx_xmmc);
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("xmjd", XmxxType.LX.gtyType);
            map.put("YS_XMBH", ys_xmbh);
            map.put("xzqmc", xzgdfw.getXzqmc());
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.LX.gtyType).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("gty").build();
            outCheckGties.add(outCheckGty);
        }
    }

    private void getBlocksYs(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdYsXzgdfw> xzgdfws = this.ysXzgdfwService.findByPid(projectId);
        for (XfsbcgdYsXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("f_bsm", bsm);
            map.put("f_xzqdm", xzgdfw.getXzqdm());
            map.put("DIKUAI_NO", xzgdfw.getDkbh());
            map.put("PL_NAME", xzgdfw.getDkmc());
            map.put("DIKUAIAREA", xzgdfw.getDkmj());
            map.put("PURPOSE", xzgdfw.getDkyt());
            map.put("MAP_NO", xzgdfw.getTfh());
            map.put("PATCHTYPE", xzgdfw.getTblx());
            map.put("LANDTYPE", xzgdfw.getDlbm());
            map.put("AVGGRADE1", xzgdfw.getGzqpjzldb());
            map.put("AVGGRADE2", xzgdfw.getGzhpjzldb());
            map.put("JBXX_XMMC", jbxx_xmmc);
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("xmjd", XmxxType.YS.gtyType);
            map.put("YS_XMBH", ys_xmbh);
            map.put("xzqmc", xzgdfw.getXzqmc());
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.YS.gtyType).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("gty").build();
            outCheckGties.add(outCheckGty);
        }
    }

    private JSONObject getTempUrl() {
        HttpRequest request = this.getRequest(this.gtyStore, Method.POST);
        request.body("{\"type\":\"gty\"}");
        return (JSONObject)this.getRes(request.execute(), this.gtyStore, null);
    }

    public String getToken() {
        String token = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)"gty_token");
        if (obj != null) {
            JSONObject jsonObject = JSON.parseObject((String)obj.toString());
            Long currTime = System.currentTimeMillis();
            Long expireTime = jsonObject.getLong("expireTime");
            if (currTime > expireTime) {
                JSONObject tokenInfo = this.httpGetToken();
                if (tokenInfo != null) {
                    token = tokenInfo.getString("accessToken");
                    this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
                }
            } else {
                token = jsonObject.getString("accessToken");
            }
        } else {
            JSONObject tokenInfo = this.httpGetToken();
            token = tokenInfo.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
        }
        return token;
    }

    private JSONObject httpGetToken() {
        HttpRequest post = HttpUtil.createPost((String)(this.gtyUrl + this.gtyTokenUrl));
        post.header("appKey", this.appKey);
        post.header("appSecret", this.appSecret);
        return (JSONObject)this.getRes(post.execute(), this.gtyTokenUrl, null);
    }

    private Object getRes(HttpResponse execute, String path, Class clazz) {
        JSONObject jsonObject = JSONObject.parseObject((String)execute.body());
        String status = jsonObject.getString("status");
        if (!"true".equalsIgnoreCase(status)) {
            throw new RuntimeException("gty\u63a5\u53e3\u3010" + path + "\u3011\u8bf7\u6c42\u5f02\u5e38\uff0c" + jsonObject.getString("msg"));
        }
        return clazz == null ? jsonObject.getJSONObject("data") : jsonObject.getObject("data", clazz);
    }

    private HttpRequest getRequest(String path, Method method) {
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(this.gtyUrl + path));
        request.header("sysToken", this.getToken());
        return request;
    }
}

