/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.wyhc.impl;

import com.geoway.onemap.core.support.ShapeUtil;
import com.geoway.onemap.core.support.Zip4jUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXzgdfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXzgdfw;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.service.wyhc.BusinessVerifyPushService;
import com.geoway.onemap.zbph.service.wyhc.impl.AbstracGtyPushServiceImpl;
import com.geoway.onemap.zbph.supoort.GtyYnApiUtil;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty-yn")
public class GtyYnVerifyPushServiceImpl
extends AbstracGtyPushServiceImpl
implements BusinessVerifyPushService {
    @Autowired
    private GtyYnApiUtil gtyYnApiUtil;

    @Override
    public void generateStart(BusinessPushDTO dto) {
        this.start(dto);
    }

    @Override
    protected void getBlocksLx(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdLxXzgdfw> xzgdfws = this.lxXzgdfwService.findByPid(projectId);
        for (XfsbcgdLxXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("BH", bsm);
            map.put("XZQDM", xzgdfw.getXzqdm());
            map.put("DIKUAI_NO", xzgdfw.getDkbh());
            map.put("PL_NAME", xzgdfw.getDkmc());
            map.put("DIKUAIAREA", xzgdfw.getDkmj());
            map.put("PURPOSE", xzgdfw.getDkyt());
            map.put("MAP_NO", xzgdfw.getTfh());
            map.put("PATCHTYPE", xzgdfw.getTblx());
            map.put("LANDTYPE", xzgdfw.getDlbm());
            map.put("AVGGRADE1", xzgdfw.getGzqpjzldb());
            map.put("AVGGRADE2", xzgdfw.getGzhpjzldb());
            map.put("JBXX_XMMC", xzgdfw.getJbxxXmmc());
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("xmjd", XmxxType.LX.type);
            map.put("YS_XMBH", xzgdfw.getYsXmbh());
            map.put("XZQMC", xzgdfw.getXzqmc());
            map.put("ZSDM", xzgdfw.getXzqdm().substring(0, 4));
            map.put("ZSMC", "");
            map.put("XZDM", xzgdfw.getXzqdm());
            map.put("XZMC", "");
            map.put("ZLDWDM", xzgdfw.getXzqdm());
            map.put("ZLDWMC", "");
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.LX.type).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("YnGty").build();
            outCheckGties.add(outCheckGty);
        }
    }

    @Override
    protected void getBlocksYs(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdYsXzgdfw> xzgdfws = this.ysXzgdfwService.findByPid(projectId);
        for (XfsbcgdYsXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("BH", bsm);
            map.put("DIKUAI_NO", xzgdfw.getDkbh());
            map.put("PL_NAME", xzgdfw.getDkmc());
            map.put("DIKUAIAREA", xzgdfw.getDkmj());
            map.put("PURPOSE", xzgdfw.getDkyt());
            map.put("MAP_NO", xzgdfw.getTfh());
            map.put("PATCHTYPE", xzgdfw.getTblx());
            map.put("LANDTYPE", xzgdfw.getDlbm());
            map.put("AVGGRADE1", xzgdfw.getGzqpjzldb());
            map.put("AVGGRADE2", xzgdfw.getGzhpjzldb());
            map.put("JBXX_XMMC", xzgdfw.getJbxxXmmc());
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("xmjd", XmxxType.YS.type);
            map.put("YS_XMBH", xzgdfw.getYsXmbh());
            map.put("XZQDM", xzgdfw.getXzqdm());
            map.put("XZQMC", xzgdfw.getXzqmc());
            map.put("ZSDM", xzgdfw.getXzqdm().substring(0, 4) + "00");
            map.put("ZSMC", xzgdfw.getXzqdm().substring(0, 4) + "00");
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.YS.type).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("YnGty").build();
            outCheckGties.add(outCheckGty);
        }
    }

    @Override
    protected File generateGty(List<Map<String, Object>> XZGDFW, String dir) throws IOException {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (XZGDFW.size() > 0) {
            String path = dir + "/XZGDFW.shp";
            ArrayList<String> attrKeys = new ArrayList<String>(XZGDFW.get(0).keySet());
            attrKeys.remove("WKT");
            ShapeUtil.write2Shape((String)path, (String)"UTF-8", (String)"MultiPolygon", (String)"WKT", attrKeys, XZGDFW);
            File file = new File(dir + "/XZGDFW.cpg");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dir + "/XZGDFW.cpg"));){
                writer.write("UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String zipUrl = dir;
        zipUrl = Zip4jUtil.zip((String)zipUrl, (boolean)false, (String)"");
        File zipFile = new File(zipUrl);
        String gtyPath = zipUrl.substring(0, zipUrl.lastIndexOf(".")) + ".gty";
        File gtyFile = new File(gtyPath);
        zipFile.renameTo(gtyFile);
        FileUtils.forceDelete((File)dirFile);
        return gtyFile;
    }

    @Override
    protected String uploadFile(File file, String xmid, String type) {
        return this.gtyYnApiUtil.httpPushGty(file, type);
    }
}

