/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfsbcgdyj.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.stxf.dto.TaskXmxxDTO;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.xfsbcgdyj.XfsbcgdYjXmxx;
import com.geoway.onemap.zbph.dto.xfsbcgdyj.XfsbcgdyjDTO;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import com.geoway.onemap.zbph.service.base.VerifyTaskManageService;
import com.geoway.onemap.zbph.service.xfsbcgdyj.XfsbcgdYjManageService;
import com.geoway.onemap.zbph.service.xfsbcgdyj.XfsbcgdYjXmfwService;
import com.geoway.onemap.zbph.service.xfsbcgdyj.XfsbcgdYjXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdyj.XfsbcgdYjXzgdfwService;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.zhgd.domain.VerifyTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XfsbcgdYjManageServiceImpl
implements XfsbcgdYjManageService,
VerifyTaskManageService {
    @Value(value="${project.fxfw.service.yj:'GDZBPH_YJ'}")
    private String serviceName;
    @Autowired
    private XfsbcgdYjXmxxService xmxxService;
    @Autowired
    private XfsbcgdYjXmfwService xmfwService;
    @Autowired
    private XfsbcgdYjXzgdfwService xzgdfwService;
    @Autowired
    private DataVerifyTaskService verifyTaskService;
    @Autowired
    private BaseLshService sidService;
    @Autowired
    private DataVerifyTaskService dataVerifyTaskService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdata(XfsbcgdyjDTO dto, SysUser sysUser) {
        XfsbcgdYjXmxx xmxx = dto.getXmxx();
        XfsbcgdYjXmxx yjXmxx = this.xmxxService.findByName(xmxx.getName());
        if (StringUtils.isEmpty((CharSequence)xmxx.getId())) {
            ExceptionCustomUtil.isNotNull(yjXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            xmxx.setYjbh(this.sidService.generateLsh(sysUser.getXzqdm(), EnumLshType.YJ));
            xmxx.setXzqdm(sysUser.getXzqdm());
            xmxx.setCreateTime(new Date());
        } else {
            XfsbcgdYjXmxx oldXmxx = this.xmxxService.findById(xmxx.getId());
            if (!oldXmxx.getName().equals(xmxx.getName())) {
                ExceptionCustomUtil.isNotNull(yjXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
        }
        String id = this.xmxxService.saveOrupdate(xmxx);
        if (dto.getXmfwList() != null) {
            dto.getXmfwList().forEach(f -> f.setXmid(id));
            this.xmfwService.saveCover(dto.getXmfwList(), id);
        }
        if (dto.getXzgdfwList() != null) {
            dto.getXzgdfwList().forEach(f -> f.setXmid(id));
            this.xzgdfwService.saveCover(dto.getXzgdfwList(), id);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(String id) {
        this.xmxxService.deleteById(id);
        this.xmfwService.deleteByPid(id);
        this.xzgdfwService.deleteByPid(id);
        this.verifyTaskService.deleteByPid(id);
    }

    @Override
    public XfsbcgdyjDTO detailById(String id) {
        XfsbcgdyjDTO dto = new XfsbcgdyjDTO();
        dto.setXmxx(this.xmxxService.findById(id));
        dto.setXmfwList(this.xmfwService.findByPid(id));
        dto.setXzgdfwList(this.xzgdfwService.findByPid(id));
        return dto;
    }

    @Override
    public Page<XfsbcgdYjXmxx> queryPage(String yjbh, String name, Integer status, Integer ruleStatus, String xzqdm, Integer page, Integer size) {
        return this.xmxxService.queryPage(yjbh, name, status, ruleStatus, xzqdm, page, size);
    }

    @Override
    public void dataVerify(String ids) {
        ArrayList<String> idList = new ArrayList<String>(Arrays.asList(ids.split(",")));
        for (String id : idList) {
            this.dataVerifyManage(id);
        }
    }

    @Override
    public Long queryTotal(String xzqdm) {
        return this.xmxxService.queryTotal(xzqdm);
    }

    @Override
    public void verifyManage(VerifyTask verifyTask) {
        XfsbcgdYjXmxx xmxx = this.xmxxService.findById(verifyTask.getPid());
        xmxx.setStatus(verifyTask.getStatus());
        xmxx.setRuleStatus(verifyTask.getRuleStatus());
        if (verifyTask.getStatus() == 500) {
            xmxx.setRuleStatus(null);
        } else {
            List array = this.dataVerifyTaskService.queryResult(xmxx.getId(), XmxxType.CY.type, null, null, null);
            boolean flag = array.stream().anyMatch(f -> {
                JSONObject ruleItem = f.getJSONObject("ruleItem");
                JSONObject ruleInfo = f.getJSONObject("ruleInfo");
                if (ruleItem == null || ruleInfo == null) {
                    return false;
                }
                Integer type = ruleItem.getInteger("type");
                Boolean result = ruleInfo.getBoolean("result");
                return type == 2 && result != null && result == false;
            });
            if (flag) {
                xmxx.setRuleStatus(3);
            }
        }
        this.xmxxService.update(xmxx);
    }

    private void dataVerifyManage(String id) {
        XfsbcgdyjDTO detail = this.detailById(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TaskXmxxDTO xxmx = new TaskXmxxDTO();
        xxmx.setLxsj(sdf.format(detail.getXmxx().getXmnf()));
        xxmx.setXmlx(XmxxType.CY.type);
        List<TaskBlockDTO> xmq = detail.getXmfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id("1");
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isAnalysis", false);
            map.put("xmdklx", "xmq");
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        List gdfw = detail.getXzgdfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id(UUID.randomUUID().toString());
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isImage", false);
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        xmq.addAll(gdfw);
        Map map = BeanUtil.beanToMap((Object)xxmx, (String[])new String[0]);
        Class<?> aClass = this.getClass();
        this.dataVerifyTaskService.createTask(map, xmq, null, this.serviceName, VerifyTask.builder().pid(id).type(XmxxType.CY.type).customClass(aClass.getName()).build());
        detail.getXmxx().setStatus(0);
        detail.getXmxx().setRuleStatus(null);
        this.xmxxService.update(detail.getXmxx());
    }
}

