/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfstbrk.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.RegionServiceUtil;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.domain.base.EntityCheckResult;
import com.geoway.onemap.zbph.domain.xfsgdtbrk.ZbkTbrkDetail;
import com.geoway.onemap.zbph.dto.xfstbrk.TbrkInputDataCheckValidInfo;
import com.geoway.onemap.zbph.dto.xfstbrk.TbrkTaskParam;
import com.geoway.onemap.zbph.dto.xfstbrk.TerranAreaDTO;
import com.geoway.onemap.zbph.exception.xfstbrk.XfsTbrkDataInputException;
import com.geoway.onemap.zbph.service.base.BaseTaskExecuteService;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkDetailService;
import com.geoway.onemap.zbph.supoort.EasyShpUtil;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbkTbrkTaskExecuteServiceImpl
implements BaseTaskExecuteService {
    @Autowired
    private ZbkTbrkDetailService zbkTbrkDetailService;
    @Autowired
    private GeoserverUtil geoserverUtil;
    private static final String SJTCTBRK = "SJTCTBRK";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void execute(Map map, SysUser user, BaseTaskManage taskInfo) throws Exception {
        TbrkTaskParam param = TbrkTaskParam.convertFromMap(map, TbrkTaskParam.class);
        EasyShpUtil easyShpUtil = new EasyShpUtil();
        try {
            if (ConfigConstant.TbrkConfig.checkValid.booleanValue()) {
                List<EntityCheckResult<ZbkTbrkDetail>> checkResults = this.checkValid(map, user, taskInfo);
                ArrayList tbrkInputDataCheckValidInfos = new ArrayList();
                if (checkResults != null && checkResults.size() >= 1) {
                    String dateStr = DateUtil.now();
                    checkResults.forEach(checkResult -> {
                        TbrkInputDataCheckValidInfo tbrkInputDataCheckValidInfo = new TbrkInputDataCheckValidInfo();
                        tbrkInputDataCheckValidInfo.setDate(dateStr);
                        tbrkInputDataCheckValidInfo.setUser(user.getAlisname());
                        tbrkInputDataCheckValidInfo.setBsm(((ZbkTbrkDetail)checkResult.getData()).getBsm());
                        tbrkInputDataCheckValidInfo.setTbbh(((ZbkTbrkDetail)checkResult.getData()).getTbbh());
                        tbrkInputDataCheckValidInfo.setMsg(checkResult.getMsg());
                        tbrkInputDataCheckValidInfos.add(tbrkInputDataCheckValidInfo);
                    });
                    String msg = JSON.toJSONString(tbrkInputDataCheckValidInfos);
                    throw new XfsTbrkDataInputException(msg);
                }
            }
            this.inputData(map, user, taskInfo);
        }
        catch (Exception e) {
            throw new XfsTbrkDataInputException(e.getMessage(), e);
        }
        finally {
            easyShpUtil.deleteReadFile(param.getFilePath());
        }
    }

    public void inputData(Map map, SysUser user, BaseTaskManage taskInfo) throws Exception {
        TbrkTaskParam param = TbrkTaskParam.convertFromMap(map, TbrkTaskParam.class);
        EasyShpUtil easyShpUtil = new EasyShpUtil();
        try {
            Iterator<EasyShpUtil.Feature> featureIterator = easyShpUtil.readByFile(param.getFilePath());
            HashMap<String, String> xzqDmMcMap = new HashMap<String, String>();
            ArrayList<ZbkTbrkDetail> saves = new ArrayList<ZbkTbrkDetail>();
            int index = 0;
            while (featureIterator.hasNext()) {
                EasyShpUtil.Feature feature = featureIterator.next();
                ZbkTbrkDetail detail = this.convert2ZbkTbrkDetail(feature, user, param, xzqDmMcMap, taskInfo);
                if (!user.getXzqdm().endsWith("00") && !detail.getXzqdm().equals(user.getXzqdm())) {
                    throw new RuntimeException(String.format("\u6807\u8bc6\u7801\u4e3a\u3010%s\u3011\u7684\u56fe\u6591\u6240\u5728\u7684\u884c\u653f\u533a\u4ee3\u7801\uff0c\u4e0e\u5f53\u524d\u7528\u6237\u7684\u884c\u653f\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5165\u5e93\uff01", detail.getBsm()), new Exception());
                }
                saves.add(detail);
                if (++index != 500) continue;
                this.dataManages(saves, user);
                index = 0;
                saves = new ArrayList();
            }
            this.dataManages(saves, user);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ZbkTbrkDetail convert2ZbkTbrkDetail(EasyShpUtil.Feature feature, SysUser user, TbrkTaskParam param, Map<String, String> xzqDmMcMap, BaseTaskManage taskInfo) {
        Map<String, String> fieldMap = ConfigConstant.TbrkConfig.FieldMap;
        Map<String, BigDecimal> unitConvertMap = ConfigConstant.TbrkConfig.UnitConvertMap;
        ZbkTbrkDetail detail = new ZbkTbrkDetail();
        for (Map.Entry<String, Object> kv : feature.getAttrs().entrySet()) {
            Map.Entry realField;
            Map.Entry unitConvert = unitConvertMap.entrySet().stream().filter(f -> ((String)f.getKey()).toLowerCase().equals(((String)kv.getKey()).toLowerCase())).findFirst().orElse(null);
            Object value = kv.getValue();
            if (unitConvert != null && kv.getValue() != null && StrUtil.isNotBlank((CharSequence)kv.getValue().toString())) {
                value = new BigDecimal(kv.getValue().toString()).divide((BigDecimal)unitConvert.getValue());
            }
            if ((realField = (Map.Entry)fieldMap.entrySet().stream().filter(f -> ((String)f.getValue()).toLowerCase().equals(((String)kv.getKey()).toLowerCase())).findFirst().orElse(null)) != null) {
                detail.put(realField.getKey(), value);
                continue;
            }
            detail.put(kv.getKey(), value);
        }
        if (param.getProcessGroup().toLowerCase().equals(SJTCTBRK.toLowerCase())) {
            detail.setXzqdm(user.getXzqdm());
        } else {
            detail.setXzqdm(detail.getZldwdm().substring(0, 6));
        }
        detail.setProcessGroup(param.getProcessGroup());
        detail.setShape(feature.getGeometry());
        detail.setRklx("-1");
        detail.setTotalGddj(detail.getGddj() * detail.getTbdlmj());
        if (!user.getXzqdm().endsWith("00") && !detail.getXzqdm().equals(user.getXzqdm())) {
            throw new RuntimeException(String.format("\u6807\u8bc6\u7801\u4e3a\u3010%s\u3011\u7684\u56fe\u6591\u6240\u5728\u7684\u884c\u653f\u533a\u4ee3\u7801\uff0c\u4e0e\u5f53\u524d\u7528\u6237\u7684\u884c\u653f\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5165\u5e93\uff01", detail.getBsm()));
        }
        if (!xzqDmMcMap.containsKey(detail.getXzqdm())) {
            xzqDmMcMap.put(detail.getXzqdm(), RegionServiceUtil.getFullRegionName((String)detail.getXzqdm()));
        }
        detail.setXzqmc(xzqDmMcMap.get(detail.getXzqdm()));
        detail.put("uuid", UUID.randomUUID().toString());
        detail.setTaskid(taskInfo.getId());
        return detail;
    }

    private List<EntityCheckResult<ZbkTbrkDetail>> checkValid(Map map, SysUser user, BaseTaskManage taskInfo) throws Exception {
        TbrkTaskParam param = TbrkTaskParam.convertFromMap(map, TbrkTaskParam.class);
        EasyShpUtil easyShpUtil = new EasyShpUtil();
        ArrayList<EntityCheckResult<ZbkTbrkDetail>> checkResults = new ArrayList<EntityCheckResult<ZbkTbrkDetail>>();
        ArrayList<ModelFields> listFields = new ArrayList();
        listFields = this.zbkTbrkDetailService.findFields();
        try {
            Iterator<EasyShpUtil.Feature> featureIterator = easyShpUtil.readByFile(param.getFilePath());
            HashMap<String, String> xzqDmMcMap = new HashMap<String, String>();
            while (featureIterator.hasNext()) {
                EasyShpUtil.Feature feature = featureIterator.next();
                ZbkTbrkDetail detail = this.convert2ZbkTbrkDetail(feature, user, param, xzqDmMcMap, taskInfo);
                detail.setXmid(UUID.randomUUID().toString());
                EntityCheckResult checkResult = this.zbkTbrkDetailService.checkValid(detail, listFields);
                if (checkResult.isValid()) continue;
                checkResults.add(checkResult);
            }
            return checkResults;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void dataManages(ArrayList<ZbkTbrkDetail> details, SysUser sysUser) {
        if (details.size() > 0) {
            List<TaskBlockDTO> blocks = details.stream().map(m -> {
                TaskBlockDTO block = new TaskBlockDTO();
                block.setWkt(m.getShape().toText());
                block.setDk_id((String)m.get("uuid"));
                return block;
            }).collect(Collectors.toList());
            JSONArray array = this.geoserverUtil.httpTerranArea(blocks);
            List dtos = array.toJavaList(TerranAreaDTO.class);
            Map<String, Double> map = dtos.stream().collect(Collectors.toMap(TerranAreaDTO::getDK_ID, a -> a.getDK_MJ()));
            for (ZbkTbrkDetail detail : details) {
                Double tqmj = map.get(detail.get("uuid"));
                Double dlmj = tqmj * (1.0 - detail.getKcxs());
                detail.setXttbmj(this.hectareManage(tqmj));
                detail.setXttbdlmj(this.hectareManage(dlmj));
            }
            this.zbkTbrkDetailService.batchSaveOrUpdate(details, sysUser, ConfigConstant.TbrkConfig.checkValid);
        }
    }

    private Double hectareManage(Double val) {
        Double res = val / 10000.0;
        return new BigDecimal(res).setScale(4, 4).doubleValue();
    }
}

