/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbsync.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.onemap.core.domain.Region;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.RegionService;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputMethod;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKPzType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKType;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKBaseDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKConfigDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKOperateDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKRkmxQdlRepository;
import com.geoway.onemap.zbph.dao.zbsync.JczbkSyncRepository;
import com.geoway.onemap.zbph.dao.zbsync.QdlxxSyncRepository;
import com.geoway.onemap.zbph.dao.zbsync.ZbczmxSyncRepository;
import com.geoway.onemap.zbph.dao.zbsync.ZbsxSyncRepository;
import com.geoway.onemap.zbph.dao.zbtj.ZbdjMxRepository;
import com.geoway.onemap.zbph.dao.zbtj.ZbhjMxRepository;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKBaseDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKConfigDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKRkmxQdl;
import com.geoway.onemap.zbph.domain.zbktj.Zbkgltj;
import com.geoway.onemap.zbph.domain.zbsync.BjjkqqjlSyncDetail;
import com.geoway.onemap.zbph.domain.zbsync.JczbkSyncDetail;
import com.geoway.onemap.zbph.domain.zbsync.QdlxxSyncDetail;
import com.geoway.onemap.zbph.domain.zbsync.ZbczmxSyncDetail;
import com.geoway.onemap.zbph.domain.zbsync.ZbsxSyncDetail;
import com.geoway.onemap.zbph.domain.zbtj.Zbdj;
import com.geoway.onemap.zbph.domain.zbtj.ZbdjMx;
import com.geoway.onemap.zbph.domain.zbtj.Zbhj;
import com.geoway.onemap.zbph.domain.zbtj.ZbhjMx;
import com.geoway.onemap.zbph.domain.zgck.ZgckBcgdXzqDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.dto.zbsync.BcgddlmxSyncParam;
import com.geoway.onemap.zbph.dto.zbsync.JczbkSyncParam;
import com.geoway.onemap.zbph.dto.zbsync.ZbSyncTaskParam;
import com.geoway.onemap.zbph.dto.zbsync.ZbczmxSyncParam;
import com.geoway.onemap.zbph.dto.zbsync.ZbgxCxggParam;
import com.geoway.onemap.zbph.dto.zbsync.ZbgxGgDataParam;
import com.geoway.onemap.zbph.dto.zbsync.ZbgxSyncParam;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.BaseTaskExecuteService;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsManageService;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkManagerService;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkFreezeHandler;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkSubtractionHandler;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKInputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailService;
import com.geoway.onemap.zbph.service.zbktj.impl.ZbkgltjServiceImpl;
import com.geoway.onemap.zbph.service.zbsync.BjjkqqjlSyncService;
import com.geoway.onemap.zbph.service.zbsync.UsermanageService;
import com.geoway.onemap.zbph.service.zbsync.ZbsyncService;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjService;
import com.geoway.onemap.zbph.service.zbtj.hj.ZbhjService;
import com.geoway.onemap.zbph.service.zgck.ZgckXmxxService;
import com.geoway.onemap.zbph.service.zgck.impl.ZgckBcgdXzqDetailServiceImpl;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbsyncServiceImpl
implements ZbsyncService,
BaseTaskExecuteService {
    private static final Logger log = LoggerFactory.getLogger(ZbsyncServiceImpl.class);
    @Value(value="${project.zbsync.url:''}")
    protected String url;
    @Value(value="${project.zbsync.mapping.zblx:''}")
    private String zblxMapping;
    @Value(value="${project.zbsync.mapping.virtual.xzq:''}")
    private String virtualXzqMapping;
    @Value(value="${project.zbsync.nonSync.zblx:''}")
    private String zblxNonSync;
    @Value(value="${project.zbsync.qdlyear.default:true}")
    private Boolean qdlDefaultYear;
    @Value(value="${project.fxfw.service.qdl:'GDZBPH_TDLYXZ_SD_LAST'}")
    private String qdlService;
    @Value(value="${project.zbsync.qdldksize:'100'}")
    private String qdlDksize;
    @Autowired
    private UsermanageService usermanageService;
    @Autowired
    private BaseTaskManageService baseTaskManageService;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private BaseLshService baseSidService;
    @Autowired
    private ZBKOperateDetailRepository zbkOperateDetailRepository;
    @Autowired
    private ZBKOutputDetailService zbkOutputDetailService;
    @Autowired
    private ZBKInputDetailService zbkInputDetailService;
    @Autowired
    private ZbkgltjServiceImpl zbkgltjService;
    @Autowired
    private ZBKConfigDetailRepository zbkConfigDetailRepository;
    @Autowired
    private BjjkqqjlSyncService bjjkqqjlSyncService;
    @Autowired
    private ZbsxSyncRepository zbsxSyncRepository;
    @Autowired
    private ZgckXmxxService zgckXmxxService;
    @Autowired
    private ZgckBcgdXzqDetailServiceImpl zgckBcgdXzqDetailService;
    @Autowired
    private ZBKBaseDetailRepository zbkBaseDetailRepository;
    @Autowired
    private RegionService regionService;
    @Autowired
    private ZbczmxSyncRepository zbczmxSyncRepository;
    @Autowired
    private JczbkSyncRepository jczbkSyncRepository;
    @Autowired
    private QdlxxSyncRepository qdlxxSyncRepository;
    @Autowired
    private ModelManageService modelManageService;
    @Autowired
    private ZbhjService zbhjService;
    @Autowired
    private ZbhjMxRepository zbhjMxRepository;
    @Autowired
    private ZbdjService zbdjService;
    @Autowired
    private ZbdjMxRepository zbdjMxRepository;
    @Autowired
    private ZbkSubtractionHandler zbkSubtractionHandler;
    @Autowired
    private ZbkFreezeHandler zbkFreezeHandler;
    @Autowired
    XfsbcgdYsManageService xfsbcgdYsManageService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private GeoserverUtil geoserverUtil;
    @Autowired
    ZBKRkmxQdlRepository zbkRkmxQdlRepository;
    @Autowired
    ZbkTbrkManagerService zbkTbrkManagerService;
    private Map<String, String> zblxMap;
    private Map<String, List<String>> zblxBjMap;
    private List<String> nonSyncZblxs;
    private Map<String, String> realXzqdmMap;
    private Map<String, String> realXzqmcMap;

    private String getBjZblx(String zblx) {
        if (MapUtils.isEmpty(this.zblxMap)) {
            this.zblxMap = new HashMap<String, String>();
            JSONObject jsonObject = JSON.parseObject((String)this.zblxMapping);
            for (String key : jsonObject.keySet()) {
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                jsonArray.forEach(item -> this.zblxMap.put(item.toString(), key));
            }
        }
        return this.zblxMap.get(zblx);
    }

    private JSONObject handleVirtualXzqdm(JSONObject jsonObject, String interfacePath) {
        JSONObject reqParam = new JSONObject();
        switch (interfacePath) {
            case "/index/getZbsx": {
                break;
            }
            case "/index/syncJczbk": {
                JczbkSyncParam jczbkSyncParam = (JczbkSyncParam)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), JczbkSyncParam.class);
                List<ZbczmxSyncParam> mxData = jczbkSyncParam.getMxData();
                ArrayList<ZbczmxSyncParam> mxDataNew = new ArrayList<ZbczmxSyncParam>();
                if (mxData.size() > 0) {
                    for (ZbczmxSyncParam zbczmxSyncParam : mxData) {
                        zbczmxSyncParam.setCbzbxzqdm(this.getBjxzqdm(zbczmxSyncParam.getCbzbxzqdm()));
                        zbczmxSyncParam.setCzxzqdm(this.getBjxzqdm(zbczmxSyncParam.getCzxzqdm()));
                        List<BcgddlmxSyncParam> qdlData = zbczmxSyncParam.getQdlData();
                        ArrayList<BcgddlmxSyncParam> qdlDataNew = new ArrayList<BcgddlmxSyncParam>();
                        if (qdlData.size() > 0) {
                            for (BcgddlmxSyncParam qdl : qdlData) {
                                qdl.setZbxzqdm(this.getBjxzqdm(qdl.getZbxzqdm()));
                                qdl.setCzxzqdm(this.getBjxzqdm(qdl.getCzxzqdm()));
                                qdlDataNew.add(qdl);
                            }
                        }
                        zbczmxSyncParam.setQdlData(qdlDataNew);
                        mxDataNew.add(zbczmxSyncParam);
                    }
                    jczbkSyncParam.setMxData(mxDataNew);
                }
                jczbkSyncParam.setXzqdm(this.getBjxzqdm(jczbkSyncParam.getXzqdm()));
                log.debug(":5.2.2. \u57fa\u7840\u6307\u6807\u5e93\u4fe1\u606f\u540c\u6b65\u53d1\u9001\u8bf7\u6c42,\u865a\u62df\u884c\u653f\u533a\u6620\u5c04\u540e\uff1a" + JSON.toJSON((Object)jczbkSyncParam));
                reqParam = (JSONObject)JSON.toJSON((Object)jczbkSyncParam);
                break;
            }
            case "/index/syncZbgx": {
                break;
            }
            case "/index/cxggZbgx": {
                break;
            }
            case "/index/hxZbgx": {
                break;
            }
            case "/index/getAllzb": {
                break;
            }
            case "/index/getAllzbczmx": {
                break;
            }
            case "/index/updateIndicatorIssuance": {
                break;
            }
            case "/index/getHistoryDetails": {
                break;
            }
            case "/index/getCarryoverIndex": {
                break;
            }
            case "/index/readZip": {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u63a5\u53e3\u8def\u5f84\u4e0d\u5b58\u5728");
            }
        }
        return reqParam;
    }

    private String getBjxzqdm(String virtualXzqdm) {
        String xzqdmResult;
        String realXzqdm = virtualXzqdm;
        if (MapUtils.isEmpty(this.realXzqdmMap)) {
            this.realXzqdmMap = new HashMap<String, String>();
            JSONObject jsonObject = JSON.parseObject((String)this.virtualXzqMapping);
            if (jsonObject.size() > 0) {
                for (String key : jsonObject.keySet()) {
                    JSONObject value = jsonObject.getJSONObject(key);
                    this.realXzqdmMap.put(key, value.getString("xzqdm"));
                }
            }
        }
        if ((xzqdmResult = this.realXzqdmMap.get(virtualXzqdm)) != null && !xzqdmResult.equalsIgnoreCase("")) {
            realXzqdm = xzqdmResult;
        }
        return realXzqdm;
    }

    private String getBjxzqmc(String virtualXzqdm) {
        if (MapUtils.isEmpty(this.realXzqmcMap)) {
            this.realXzqmcMap = new HashMap<String, String>();
            JSONObject jsonObject = JSON.parseObject((String)this.virtualXzqMapping);
            if (jsonObject.size() > 0) {
                for (String key : jsonObject.keySet()) {
                    JSONObject value = jsonObject.getJSONObject(key);
                    this.realXzqmcMap.put(key, value.getString("xzqmc"));
                }
            }
        }
        return this.realXzqmcMap.get(virtualXzqdm);
    }

    private List<String> getBjZblxMap(String zblx) {
        if (MapUtils.isEmpty(this.zblxBjMap)) {
            this.zblxBjMap = new HashMap<String, List<String>>();
            JSONObject jsonObject = JSON.parseObject((String)this.zblxMapping);
            for (String key : jsonObject.keySet()) {
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                ArrayList zbphZblxs = new ArrayList();
                jsonArray.forEach(item -> zbphZblxs.add(item.toString()));
                this.zblxBjMap.put(key, zbphZblxs);
            }
        }
        return this.zblxBjMap.get(zblx);
    }

    private boolean isNonSync(String zblx) {
        if (CollectionUtils.isEmpty(this.nonSyncZblxs) && StringUtils.isNotBlank((CharSequence)this.zblxNonSync)) {
            this.nonSyncZblxs = Arrays.asList(this.zblxNonSync.split(","));
        }
        return this.nonSyncZblxs.contains(zblx);
    }

    @Override
    public JSONObject createHttp(JSONObject jsonObject, String path) {
        if (this.virtualXzqMapping != null && !this.virtualXzqMapping.equalsIgnoreCase("")) {
            jsonObject = this.handleVirtualXzqdm(jsonObject, path);
        }
        BjjkqqjlSyncDetail builder = this.bjjkqqjlSyncService.builder(path, jsonObject.toJSONString());
        try {
            if (this.isSwap().booleanValue()) {
                JSONObject swap = this.swap(jsonObject, path);
                builder.setResponseResult(swap.toJSONString());
                this.bjjkqqjlSyncService.save(builder);
                return swap;
            }
            JSONObject userinfo = this.usermanageService.getUserInfo();
            String encryptBase64Str = this.usermanageService.getEncryptBase64Str(jsonObject, userinfo.getString("key"));
            log.debug("\u8c03\u7528\u90e8\u7cfb\u7edf\u63a5\u53e3\u5730\u5740\uff1a{}", (Object)(this.url + path));
            log.debug("\u8c03\u7528\u53c2\u6570\uff1a{}" + jsonObject.toJSONString());
            log.debug("token\uff1a{}\uff0cAuthorization\uff1a{}\uff0cencryptBase64Str\uff1a{}", new Object[]{userinfo.getString("token"), userinfo.getString("authorization"), encryptBase64Str});
            HttpResponse result = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.url + path)).header("Content-Type", "application/json")).header("Token-Auth", userinfo.getString("token"))).header("Authorization", userinfo.getString("authorization"))).body(encryptBase64Str).execute();
            String body = result.body();
            builder.setResponseResult(body);
            this.bjjkqqjlSyncService.save(builder);
            return JSON.parseObject((String)body);
        }
        catch (Exception e) {
            builder.setResponseResult(e.getMessage());
            builder.setStatus("1");
            this.bjjkqqjlSyncService.save(builder);
            return JSON.parseObject((String)("{\"code\":500, \"msg\":\"" + e.getMessage() + "\"}"));
        }
    }

    private Boolean isSwap() {
        return ConfigConstant.SwapConfig.enable != false && "inner".equals(ConfigConstant.SwapConfig.type);
    }

    private JSONObject swap(JSONObject jsonObject, String path) {
        ZbSyncTaskParam param = new ZbSyncTaskParam();
        param.setPath(path);
        param.setJsonObject(jsonObject);
        param.setClassPath(this.getClass().getName());
        param.setType("zbsync");
        param.setIsSwap(true);
        SysUser user = new SysUser();
        user.setId("1");
        user.setUsername("admin");
        user.setAlisname("\u7cfb\u7edf\u7528\u6237");
        user.setFullXzqmc("1");
        try {
            String taskId = this.baseTaskManageService.createAsync(BeanUtil.beanToMap((Object)param, (String[])new String[0]), user);
            String result = this.baseTaskManageService.pollingResult(taskId);
            return JSON.parseObject((String)result);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5185\u5916\u7f51\u4ea4\u6362\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public void execute(Map map, SysUser user, BaseTaskManage info) throws Exception {
        ZbSyncTaskParam param = ZbSyncTaskParam.convertFromMap(map, ZbSyncTaskParam.class);
        JSONObject object = this.createHttp(param.getJsonObject(), param.getPath());
        info.setMsg(JSON.toJSONString((Object)object));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject getZbsx(String xzqdm, String zbnd) {
        JSONObject data;
        JSONObject paramJson = new JSONObject();
        if (StringUtils.isBlank((CharSequence)zbnd)) {
            zbnd = String.valueOf(LocalDate.now().getYear());
        }
        paramJson.put("xzqdm", (Object)xzqdm);
        paramJson.put("zbnd", (Object)zbnd);
        JSONObject result = this.createHttp(paramJson, "/index/getZbsx");
        if (result.getInteger("code") == 10000 && Objects.nonNull(data = result.getJSONObject("data"))) {
            ZbsxSyncDetail zbsxSyncDetail = (ZbsxSyncDetail)JSON.toJavaObject((JSON)data, ZbsxSyncDetail.class);
            zbsxSyncDetail.setId(UUID.randomUUID().toString());
            zbsxSyncDetail.setSyncTime(new Date());
            this.zbsxSyncRepository.save(zbsxSyncDetail);
            JSONObject feedback = this.updateIndicatorIssuance(xzqdm);
            if (feedback.getInteger("code") != 10000) {
                return feedback;
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONArray syncJczbk(String xzqdm) {
        JSONArray resultArr = new JSONArray();
        Date now = new Date();
        JczbkSyncParam jczbkSyncParam = new JczbkSyncParam();
        jczbkSyncParam.setXzqdm(xzqdm);
        jczbkSyncParam.setGxsj(now);
        jczbkSyncParam.setBz("");
        String queryJzzbSql = "select base.* from tb_zbph_sync_jzzb base inner join (select f_xzqdm, max(f_jzsd) as f_jzsd from tb_zbph_sync_jzzb group by f_xzqdm) as t on base.f_xzqdm = t.f_xzqdm and base.f_jzsd = t.f_jzsd and base.f_xzqdm = '" + xzqdm + "'";
        List jzzbList = this.jdbcTemplate.queryForList(queryJzzbSql);
        if (jzzbList.size() > 0) {
            Map jzzb = (Map)jzzbList.get(0);
            if (jzzb.get("f_ycbkslzb") != null) {
                jczbkSyncParam.setYcbkslzb(Double.valueOf(jzzb.get("f_ycbkslzb").toString()));
            } else {
                jczbkSyncParam.setYcbkslzb(0.0);
            }
            if (jzzb.get("f_ycbkstzb") != null) {
                jczbkSyncParam.setYcbkstzb(Double.valueOf(jzzb.get("f_ycbkstzb").toString()));
            } else {
                jczbkSyncParam.setYcbkstzb(0.0);
            }
            if (jzzb.get("f_ygjtcslzb") != null) {
                jczbkSyncParam.setYgjtcslzb(Double.valueOf(jzzb.get("f_ygjtcslzb").toString()));
            } else {
                jczbkSyncParam.setYgjtcslzb(0.0);
            }
            if (jzzb.get("f_ygjtcstzb") != null) {
                jczbkSyncParam.setYgjtcstzb(Double.valueOf(jzzb.get("f_ygjtcstzb").toString()));
            } else {
                jczbkSyncParam.setYgjtcstzb(0.0);
            }
            if (jzzb.get("f_cnslzb") != null) {
                jczbkSyncParam.setCnslzb(Double.valueOf(jzzb.get("f_cnslzb").toString()));
            } else {
                jczbkSyncParam.setCnslzb(0.0);
            }
            if (jzzb.get("f_cnstzb") != null) {
                jczbkSyncParam.setCnstzb(Double.valueOf(jzzb.get("f_cnstzb").toString()));
            } else {
                jczbkSyncParam.setCnstzb(0.0);
            }
        } else {
            jczbkSyncParam.setYcbkslzb(0.0);
            jczbkSyncParam.setYcbkstzb(0.0);
            jczbkSyncParam.setYgjtcslzb(0.0);
            jczbkSyncParam.setYgjtcstzb(0.0);
            jczbkSyncParam.setCnslzb(0.0);
            jczbkSyncParam.setCnstzb(0.0);
        }
        jczbkSyncParam.setQzslzb(0.0);
        jczbkSyncParam.setQzstzb(0.0);
        List<String> xfsrkZblxList = this.getBjZblxMap(EnumZBKType.XFSRKBCGDZB.toValue());
        List<Zbkgltj> xfsrkbcgdZbkgls = this.zbkgltjService.findByxzqdmAndzblxs(xzqdm, xfsrkZblxList);
        double xrkbcgdzb = 0.0;
        if (xfsrkbcgdZbkgls.size() > 0) {
            for (Zbkgltj xzb : xfsrkbcgdZbkgls) {
                xrkbcgdzb += xzb.getSygd();
            }
        }
        jczbkSyncParam.setXrkbcgdzb(xrkbcgdzb);
        String zbnd = String.valueOf(DateUtil.year((Date)now));
        List<ZBKConfigDetail> zbkConfigDetails = this.zbkConfigDetailRepository.findByXzqdmAndYear(xzqdm, zbnd);
        Optional<ZBKConfigDetail> zbkConfigDetail = zbkConfigDetails.stream().filter(a -> EnumZBKPzType.XFSZBRKSX.toValue().equals(a.getType())).findFirst();
        jczbkSyncParam.setZbnd(zbnd);
        jczbkSyncParam.setZbbbrksx(zbkConfigDetail.isPresent() ? zbkConfigDetail.get().getValue() : 0.0);
        List<ZBKOperateDetail> czmxs = this.zbkOperateDetailRepository.findBySyncFlagAndDateBeforeAndZbxzqdmAndCzlxNotIn("0", now, xzqdm, Lists.newArrayList((Object[])new String[]{EnumZBKInputType.FNJSZYGDJGRK.toValue(), EnumZBKOutputType.JSXMGGCK.toValue()}));
        czmxs = czmxs.stream().filter(czmx -> !this.isNonSync(czmx.getZblx())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(czmxs)) {
            return JSON.parseArray((String)"[{\"msg\":\"\u6307\u6807\u5e93\u6ca1\u6709\u53d8\u5316\uff0c\u4e0d\u8bf7\u6c42\u57fa\u7840\u6307\u6807\u5e93\u4fe1\u606f\u540c\u6b65\u63a5\u53e3\"}]");
        }
        JczbkSyncDetail jczbkSyncDetail = new JczbkSyncDetail();
        BeanUtil.copyProperties((Object)jczbkSyncParam, (Object)jczbkSyncDetail, (String[])new String[0]);
        jczbkSyncDetail.setId(UUID.randomUUID().toString());
        jczbkSyncDetail.setXzqmc(this.getFullXzqmc(xzqdm));
        jczbkSyncDetail.setSjjhsj(now);
        this.jczbkSyncRepository.save(jczbkSyncDetail);
        czmxs.forEach(czmx -> czmx.setSyncFlag("1"));
        this.zbkOperateDetailRepository.saveAll(czmxs);
        ArrayList<ZBKOperateDetail> sucessSyncCzmxs = new ArrayList<ZBKOperateDetail>();
        for (ZBKOperateDetail czmx2 : czmxs) {
            ArrayList<QdlxxSyncDetail> qdlxxSyncDetails = new ArrayList<QdlxxSyncDetail>();
            ZbczmxSyncParam mxparam = new ZbczmxSyncParam();
            mxparam.setLsh(czmx2.getLsh_2());
            mxparam.setCzlx(czmx2.getCzlx());
            mxparam.setCbzbxzqdm(czmx2.getZbxzqdm());
            mxparam.setCzxzqdm(czmx2.getCzxzqdm());
            mxparam.setZblx(this.getBjZblx(czmx2.getZblx()));
            mxparam.setZbgm(czmx2.getGdmj());
            mxparam.setStgm(czmx2.getStmj());
            mxparam.setZy(czmx2.getZy());
            mxparam.setCzrq(czmx2.getDate());
            mxparam.setCzr(czmx2.getUsername());
            if (StringUtils.isNotBlank((CharSequence)czmx2.getGllsh())) {
                mxparam.setGllsh(czmx2.getGllsh());
            }
            if (EnumZBKInputType.ZBBBRK.toValue().equals(czmx2.getCzlx()) && EnumZBKType.XFSRKBCGDZB.toValue().equals(this.getBjZblx(czmx2.getZblx()))) {
                ArrayList<BcgddlmxSyncParam> qdlData = new ArrayList<BcgddlmxSyncParam>();
                String sid = czmx2.getLsh();
                List<ZBKRkmxQdl> zbkQdlList = this.zbkRkmxQdlRepository.findListByLsh(sid);
                if (zbkQdlList.size() > 0) {
                    for (ZBKRkmxQdl rkmxQdl : zbkQdlList) {
                        BcgddlmxSyncParam qdl = new BcgddlmxSyncParam();
                        qdl.setZbxzqdm(czmx2.getZbxzqdm());
                        qdl.setCzxzqdm(czmx2.getCzxzqdm());
                        qdl.setQdldm(rkmxQdl.getQdlbm());
                        qdl.setQdlmc(rkmxQdl.getQdlmc());
                        qdl.setRkzbgm(rkmxQdl.getRkzbgm());
                        qdlData.add(qdl);
                        QdlxxSyncDetail qdlxxSyncDetail = new QdlxxSyncDetail();
                        BeanUtil.copyProperties((Object)qdl, (Object)qdlxxSyncDetail, (String[])new String[0]);
                        qdlxxSyncDetail.setId(UUID.randomUUID().toString());
                        qdlxxSyncDetail.setLsh(czmx2.getLsh());
                        qdlxxSyncDetail.setCzlx(czmx2.getCzlx());
                        qdlxxSyncDetail.setRkzblx(czmx2.getZblx());
                        qdlxxSyncDetail.setSjjhsj(now);
                        qdlxxSyncDetails.add(qdlxxSyncDetail);
                    }
                } else {
                    List<ZBKRkmxQdl> yzfxQdlList;
                    String getDkListSql = "select rkmx.f_id,rkmx.f_dkid,st_astext(rkdk.f_shape) as wkt,rkmx.f_sid,EXTRACT(YEAR FROM rkmx.f_xmjgysrq) AS year from tb_zbph_zbk_rkmx  rkmx  join tb_zbph_zbk_rkdk rkdk on rkmx.f_sid='" + sid + "' and rkmx.f_dkid = rkdk.f_dkid";
                    List dkList = this.jdbcTemplate.queryForList(getDkListSql);
                    if (dkList.size() > 0 && (yzfxQdlList = this.getZbkQdlFromYzfx(sid, dkList)).size() > 0) {
                        for (ZBKRkmxQdl rkmxQdl : yzfxQdlList) {
                            BcgddlmxSyncParam qdl = new BcgddlmxSyncParam();
                            qdl.setZbxzqdm(czmx2.getZbxzqdm());
                            qdl.setCzxzqdm(czmx2.getCzxzqdm());
                            qdl.setQdldm(rkmxQdl.getQdlbm());
                            qdl.setQdlmc(rkmxQdl.getQdlmc());
                            qdl.setRkzbgm(rkmxQdl.getRkzbgm());
                            qdlData.add(qdl);
                            QdlxxSyncDetail qdlxxSyncDetail = new QdlxxSyncDetail();
                            BeanUtil.copyProperties((Object)qdl, (Object)qdlxxSyncDetail, (String[])new String[0]);
                            qdlxxSyncDetail.setId(UUID.randomUUID().toString());
                            qdlxxSyncDetail.setLsh(czmx2.getLsh());
                            qdlxxSyncDetail.setCzlx(czmx2.getCzlx());
                            qdlxxSyncDetail.setRkzblx(czmx2.getZblx());
                            qdlxxSyncDetail.setSjjhsj(now);
                            qdlxxSyncDetails.add(qdlxxSyncDetail);
                        }
                    }
                }
                mxparam.setQdlData(qdlData);
            }
            if (EnumZBKOutputType.JSXMGGCK.toValue().equals(czmx2.getCzlx()) || EnumZBKInputType.FNJSZYGDJGRK.toValue().equals(czmx2.getCzlx())) {
                if (EnumZBKOutputType.JSXMGGCK.toValue().equals(czmx2.getCzlx())) {
                    List zgckXmxxes = this.zgckXmxxService.findByFilter("Q_f_cksid_S_EQ=" + czmx2.getLsh());
                    ZgckXmxx zgckXmxx = (ZgckXmxx)zgckXmxxes.get(0);
                    mxparam.setBcgdqrdbh(zgckXmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""));
                } else {
                    List<ZBKOperateDetail> ckMxDatas = this.zbkOperateDetailRepository.findByLsh_2(czmx2.getGllsh());
                    String cklsh = ckMxDatas.get(0).getLsh();
                    List xmxxes = this.zgckXmxxService.findByFilter("Q_f_cksid_S_EQ=" + cklsh);
                    ZgckXmxx xmxx = (ZgckXmxx)xmxxes.get(0);
                    mxparam.setBcgdqrdbh(xmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""));
                }
            }
            jczbkSyncParam.setMxData(Lists.newArrayList((Object[])new ZbczmxSyncParam[]{mxparam}));
            log.debug(xzqdm + ":5.2.2. \u57fa\u7840\u6307\u6807\u5e93\u4fe1\u606f\u540c\u6b65\u53d1\u9001\u8bf7\u6c42\uff1a" + JSON.toJSON((Object)jczbkSyncParam));
            JSONObject result = this.createHttp((JSONObject)JSON.toJSON((Object)jczbkSyncParam), "/index/syncJczbk");
            if (10000 == result.getInteger("code")) {
                czmx2.setSyncFlag("2");
                czmx2.setSyncTime(new Date());
                if (CollectionUtils.isNotEmpty(qdlxxSyncDetails)) {
                    this.qdlxxSyncRepository.saveAll(qdlxxSyncDetails);
                }
                sucessSyncCzmxs.add(czmx2);
            } else {
                czmx2.setSyncFlag("0");
            }
            resultArr.add((Object)result);
        }
        this.zbkOperateDetailRepository.saveAll(czmxs);
        this.readZipForBxt(sucessSyncCzmxs);
        return resultArr;
    }

    @Override
    public void readZipForBxt(List<ZBKOperateDetail> czmxs) {
        List<String> xfsrkZblxList = this.getBjZblxMap(EnumZBKType.XFSRKBCGDZB.toValue());
        try {
            if (czmxs.size() > 0) {
                JSONObject jSONObject;
                JSONObject readZipParams;
                int lastDotIndex;
                String fileName;
                String encode;
                String base64File;
                byte[] fileBytes;
                String zipPath;
                File zipFile;
                List ysxmlist;
                String sql;
                List<Object> sid2List;
                List sczbCzmxs;
                if (xfsrkZblxList.contains(EnumZBKType.XFSRKBCGDZB.toValue()) && (sczbCzmxs = czmxs.stream().filter(e -> e.getCzlx().equalsIgnoreCase(EnumZBKInputType.ZBBBRK.toValue()) && e.getZblx().equalsIgnoreCase(EnumZBKType.XFSRKBCGDZB.toValue())).collect(Collectors.toList())).size() > 0) {
                    sid2List = new ArrayList();
                    sid2List = sczbCzmxs.stream().map(ZBKOperateDetail::getLsh_2).filter(Objects::nonNull).filter(s -> !s.isEmpty()).distinct().collect(Collectors.toList());
                    sql = "select czmx.f_sid_2 as bxt_lsh, ysxmxx.f_id as xmid from tb_zbph_zbk_czmx  czmx join tb_zbph_zbk_rkmx rkmx on czmx.f_sid_2 in ('" + StringUtils.join(sid2List, (String)"','") + "') and czmx.f_sid= rkmx.f_sid join tb_zbph_bcgdys_xmxx ysxmxx on rkmx.f_xmbh = ysxmxx.f_xmbh group by czmx.f_sid_2 , ysxmxx.f_id";
                    ysxmlist = this.jdbcTemplate.queryForList(sql);
                    if (ysxmlist.size() > 0) {
                        zipFile = this.xfsbcgdYsManageService.exportShpForBxt(ysxmlist);
                        zipPath = zipFile.getPath();
                        fileBytes = FileManageUtil.readLargeFileToByteArray(zipPath);
                        base64File = Base64.getEncoder().encodeToString(fileBytes);
                        encode = URLEncoder.encode(base64File, "UTF-8");
                        fileName = zipFile.getName();
                        lastDotIndex = fileName.lastIndexOf(46);
                        if (lastDotIndex != -1) {
                            fileName = fileName.substring(0, lastDotIndex);
                        }
                        readZipParams = new JSONObject();
                        readZipParams.put("fileName", (Object)fileName);
                        readZipParams.put("file", (Object)encode);
                        log.debug(":5.2.13. \u4e0a\u4f20\u5730\u5757\u5750\u6807\uff1a" + JSON.toJSON((Object)readZipParams));
                        jSONObject = this.createHttp((JSONObject)JSON.toJSON((Object)readZipParams), "/index/readZip");
                    }
                }
                if (xfsrkZblxList.contains(EnumZBKType.FFGDZB.toValue()) && (sczbCzmxs = czmxs.stream().filter(e -> e.getCzlx().equalsIgnoreCase(EnumZBKInputType.ZBBBRK.toValue()) && e.getZblx().equalsIgnoreCase(EnumZBKType.FFGDZB.toValue())).collect(Collectors.toList())).size() > 0) {
                    sid2List = new ArrayList();
                    sid2List = sczbCzmxs.stream().map(ZBKOperateDetail::getLsh_2).filter(Objects::nonNull).filter(s -> !s.isEmpty()).distinct().collect(Collectors.toList());
                    sql = "select czmx.f_sid_2 as bxt_lsh, czmx.f_sid_2 as rksid from tb_zbph_zbk_czmx  czmx where czmx.f_sid_2 in ('" + StringUtils.join(sid2List, (String)"','") + "') ";
                    ysxmlist = this.jdbcTemplate.queryForList(sql);
                    if (ysxmlist.size() > 0) {
                        zipFile = this.zbkTbrkManagerService.exportHfgdShpForBxt(ysxmlist);
                        zipPath = zipFile.getPath();
                        fileBytes = FileManageUtil.readLargeFileToByteArray(zipPath);
                        base64File = Base64.getEncoder().encodeToString(fileBytes);
                        encode = URLEncoder.encode(base64File, "UTF-8");
                        fileName = zipFile.getName();
                        lastDotIndex = fileName.lastIndexOf(46);
                        if (lastDotIndex != -1) {
                            fileName = fileName.substring(0, lastDotIndex);
                        }
                        readZipParams = new JSONObject();
                        readZipParams.put("fileName", (Object)fileName);
                        readZipParams.put("file", (Object)encode);
                        log.debug(":5.2.13. \u4e0a\u4f20\u5730\u5757\u5750\u6807\uff1a" + JSON.toJSON((Object)readZipParams));
                        jSONObject = this.createHttp((JSONObject)JSON.toJSON((Object)readZipParams), "/index/readZip");
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void insertZbkQdl() {
        String czmxSql = "select f_sid from tb_zbph_zbk_czmx where f_czlx='1101' and (f_zblx='01' or f_zblx='05')";
        List sidCzmxList = this.jdbcTemplate.queryForList(czmxSql, String.class);
        String qdlSql = "select distinct(f_sid) as f_sid from tb_zbph_zbk_rkmx_qdl";
        List sidQdlList = this.jdbcTemplate.queryForList(qdlSql, String.class);
        List<Object> diffrenceSidList = new ArrayList();
        if (sidCzmxList.size() > 0 && (diffrenceSidList = sidQdlList.size() > 0 ? sidCzmxList.stream().filter(element -> !sidQdlList.contains(element)).collect(Collectors.toList()) : sidCzmxList).size() > 0) {
            for (String sid : diffrenceSidList) {
                List<ZBKRkmxQdl> yzfxQdlList;
                String getDkListSql = "select rkmx.f_id,rkmx.f_dkid,st_astext(rkdk.f_shape) as wkt,rkmx.f_sid,EXTRACT(YEAR FROM rkmx.f_xmjgysrq) AS year from tb_zbph_zbk_rkmx  rkmx  join tb_zbph_zbk_rkdk rkdk on rkmx.f_sid='" + sid + "' and rkmx.f_dkid = rkdk.f_dkid";
                List dkList = this.jdbcTemplate.queryForList(getDkListSql);
                if (dkList.size() <= 0 || (yzfxQdlList = this.getZbkQdlFromYzfx(sid, dkList)).size() <= 0) continue;
                this.zbkRkmxQdlRepository.saveAll(yzfxQdlList);
            }
        }
    }

    private List<ZBKRkmxQdl> getZbkQdlFromYzfx(String sid, List<Map<String, Object>> oneSidDkList) {
        ArrayList<ZBKRkmxQdl> qdlList = new ArrayList();
        String pageSizeStr = this.qdlDksize;
        int pageSize = Integer.valueOf(pageSizeStr);
        int totalSize = oneSidDkList.size();
        if (totalSize < pageSize || totalSize == pageSize) {
            qdlList = this.getZbkQdlFromYzfxSub(sid, oneSidDkList);
        } else {
            int page = totalSize / pageSize;
            if (totalSize % pageSize > 0) {
                ++page;
            }
            for (int i = 0; i < page; ++i) {
                List<Map<String, Object>> onePageDkList = ZbsyncServiceImpl.getPage(oneSidDkList, i + 1, pageSize);
                List<Object> onePageQdlList = new ArrayList();
                onePageQdlList = this.getZbkQdlFromYzfxSub(sid, onePageDkList);
                qdlList.addAll(onePageQdlList);
            }
        }
        return qdlList;
    }

    private List<ZBKRkmxQdl> getZbkQdlFromYzfxSub(String sid, final List<Map<String, Object>> dkList) {
        ArrayList<ZBKRkmxQdl> onePageQdlList = new ArrayList<ZBKRkmxQdl>();
        String serviceName = this.qdlService;
        String pageSizeStr = this.qdlDksize;
        final String year = dkList.get(0).get("year").toString();
        String preYear = "2019";
        if (year.length() > 0) {
            double yearDouble = Double.parseDouble(year);
            int yearInt = (int)yearDouble;
            int preYearInt = yearInt - 1;
            preYear = String.valueOf(preYearInt);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", dkList.stream().map(m -> TaskBlockDTO.builder().wkt(m.get("wkt").toString()).wkid("4490").dk_id(m.get("f_id").toString()).build()).collect(Collectors.toList()));
                this.put("ApplicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
                if (!ZbsyncServiceImpl.this.qdlDefaultYear.booleanValue()) {
                    this.put("yearmonth", String.valueOf(Integer.parseInt(year) - 1));
                }
            }
        };
        log.debug("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u524d\u5730\u7c7b\u53c2\u6570:" + map.toString());
        JSONObject object = this.geoserverUtil.httpCreateByType(serviceName, "yzfx", JSON.toJSONString((Object)map));
        log.debug("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u524d\u5730\u7c7b\u7ed3\u679c:" + object.toString());
        if (object.getInteger("StatusCode") == 200) {
            List resultList = object.getJSONArray("Results").toJavaList(JSONObject.class);
            if (resultList.size() > 0) {
                for (JSONObject obj : resultList) {
                    if (obj.get((Object)"YZMJ") == null || obj.get((Object)"YZMJ").toString().equalsIgnoreCase("")) continue;
                    Double rkzbgmOld = Double.parseDouble(obj.get((Object)"YZMJ").toString()) * 1.0E-4;
                    BigDecimal bd = new BigDecimal(Double.toString(rkzbgmOld));
                    bd = bd.setScale(4, RoundingMode.HALF_UP);
                    double rkzbgm = bd.doubleValue();
                    ZBKRkmxQdl qdl = new ZBKRkmxQdl();
                    qdl.setId(UUID.randomUUID().toString());
                    qdl.setSid(sid);
                    qdl.setZbid(obj.get((Object)"DK_ID").toString());
                    qdl.setQdlbm(obj.get((Object)"DLBM").toString());
                    qdl.setQdlmc(obj.get((Object)"DLMC").toString());
                    qdl.setRkzbgm(rkzbgm);
                    qdl.setQuerytime(preYear);
                    onePageQdlList.add(qdl);
                }
            }
        } else {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u524d\u5730\u7c7b\u5931\u8d25:" + object.getInteger("Message"));
        }
        return onePageQdlList;
    }

    private static List<Map<String, Object>> getPage(List<Map<String, Object>> originalList, int pageNum, int pageSize) {
        if (originalList == null || originalList.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        int startIndex = (pageNum - 1) * pageSize;
        if (startIndex >= originalList.size()) {
            return new ArrayList<Map<String, Object>>();
        }
        int endIndex = Math.min(startIndex + pageSize, originalList.size());
        return originalList.subList(startIndex, endIndex);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject syncZbgx(String xmid) {
        ZgckXmxx zgckXmxx = (ZgckXmxx)this.zgckXmxxService.findById(xmid);
        if (this.isNonSync(zgckXmxx.getCklx())) {
            return null;
        }
        List<ZgckBcgdXzqDetail> bcgdXzqDetails = this.zgckBcgdXzqDetailService.findByXmid(xmid);
        ZbgxSyncParam zbgxSyncParam = new ZbgxSyncParam();
        zbgxSyncParam.setXmmc(zgckXmxx.getXmmc());
        switch ((String)zgckXmxx.get("f_xmxz")) {
            case "\u5355\u72ec\u9009\u5740\u5efa\u8bbe\u7528\u5730\u9879\u76ee": {
                zbgxSyncParam.setXmydlx("01");
                break;
            }
            case "\u57ce\u9547\u6751\u6279\u6b21\u7528\u5730": {
                zbgxSyncParam.setXmydlx("02");
                break;
            }
            default: {
                zbgxSyncParam.setXmydlx("03");
            }
        }
        zbgxSyncParam.setSheng(zgckXmxx.getXmXzqdm().substring(0, 2) + "0000");
        zbgxSyncParam.setShi(zgckXmxx.getXmXzqdm().substring(0, 4) + "00");
        zbgxSyncParam.setXian(zgckXmxx.getXmXzqdm());
        zbgxSyncParam.setJsydzmj((Double)zgckXmxx.get("f_jsmj"));
        zbgxSyncParam.setYbcgdmj(bcgdXzqDetails.stream().map(item -> BigDecimal.valueOf(item.getBcgdmj())).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue());
        zbgxSyncParam.setCnxmbs(Objects.isNull(zgckXmxx.get("f_sfkcn")) || 0 == Integer.parseInt(String.valueOf(zgckXmxx.get("f_sfkcn"))) ? "\u5426" : "\u662f");
        zbgxSyncParam.setBcgdqrdbh(zgckXmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""));
        zbgxSyncParam.setBz("");
        zbgxSyncParam.setSjyszdjsxmbs(Objects.isNull(zgckXmxx.get("f_sfgjzdjsxm")) || 0 == Integer.parseInt(String.valueOf(zgckXmxx.get("f_sfgjzdjsxm"))) ? "\u5426" : "\u662f");
        zbgxSyncParam.setCzxzqdm(zgckXmxx.getXzqdm());
        zbgxSyncParam.setGgsj(zgckXmxx.getUpdateDate());
        List<ZBKOperateDetail> mxDatas = this.zbkOperateDetailRepository.findByLshAndSyncFlag(zgckXmxx.getCkLsh(), "0");
        mxDatas.forEach(mxData -> mxData.setSyncFlag("1"));
        this.zbkOperateDetailRepository.saveAll(mxDatas);
        List tempBcgdXzqDetails = BeanUtil.copyToList(bcgdXzqDetails, ZgckBcgdXzqDetail.class);
        Map<String, List<ZgckBcgdXzqDetail>> bcgdXzqDetailsGroup = tempBcgdXzqDetails.stream().peek(item -> item.setZblx(this.getBjZblx(item.getZblx()))).collect(Collectors.groupingBy(ZgckBcgdXzqDetail::getXzqdm));
        List tempMxDatas = BeanUtil.copyToList(mxDatas, ZBKOperateDetail.class);
        Map<String, List<ZBKOperateDetail>> mxDatasGroup = tempMxDatas.stream().peek(item -> item.setZblx(this.getBjZblx(item.getZblx()))).collect(Collectors.groupingBy(ZBKOperateDetail::getZbxzqdm));
        ArrayList<ZbgxGgDataParam> ggData = new ArrayList<ZbgxGgDataParam>();
        bcgdXzqDetailsGroup.forEach((xzqdm, bcgdXzqs) -> {
            ZbgxGgDataParam ggDataParam = new ZbgxGgDataParam();
            ggDataParam.setZbxzqdm((String)xzqdm);
            ggDataParam.setGgxfsrkzb(bcgdXzqs.stream().filter(item -> EnumZBKType.XFSRKBCGDZB.toValue().equals(item.getZblx())).map(item -> BigDecimal.valueOf(item.getBcgdmj()).add(BigDecimal.valueOf(item.getBcstmj()))).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue());
            ggDataParam.setGgycbkzb(bcgdXzqs.stream().filter(item -> EnumZBKType.YCBKJZZB.toValue().equals(item.getZblx())).map(item -> BigDecimal.valueOf(item.getBcgdmj()).add(BigDecimal.valueOf(item.getBcstmj()))).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue());
            ggDataParam.setGgygjtczb(bcgdXzqs.stream().filter(item -> EnumZBKType.YGJTCZB.toValue().equals(item.getZblx())).map(item -> BigDecimal.valueOf(item.getBcgdmj()).add(BigDecimal.valueOf(item.getBcstmj()))).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue());
            List czmxList = (List)mxDatasGroup.get(xzqdm);
            if (CollectionUtils.isNotEmpty((Collection)czmxList)) {
                ArrayList<ZbczmxSyncParam> zbczmxSyncParams = new ArrayList<ZbczmxSyncParam>();
                Map<String, List<ZbczmxSyncParam>> mergeZbczmx = czmxList.stream().map(item -> {
                    ZbczmxSyncParam czmx = new ZbczmxSyncParam();
                    czmx.setLsh(item.getLsh_2());
                    czmx.setCzlx(item.getCzlx());
                    czmx.setCbzbxzqdm(item.getZbxzqdm());
                    czmx.setCzxzqdm(item.getCzxzqdm());
                    czmx.setZblx(item.getZblx());
                    czmx.setZbgm(item.getGdmj());
                    czmx.setStgm(item.getStmj());
                    czmx.setZy(item.getZy());
                    czmx.setCzrq(item.getDate());
                    czmx.setCzr(item.getUsername());
                    return czmx;
                }).collect(Collectors.groupingBy(ZbczmxSyncParam::getZblx));
                for (String key : mergeZbczmx.keySet()) {
                    List<ZbczmxSyncParam> temp = mergeZbczmx.get(key);
                    ZbczmxSyncParam reduce = temp.stream().reduce(null, (a, b) -> {
                        if (Objects.isNull(a)) {
                            a = new ZbczmxSyncParam();
                            BeanUtil.copyProperties((Object)b, (Object)a, (String[])new String[0]);
                        } else {
                            a.setZbgm(BigDecimal.valueOf(a.getZbgm()).add(BigDecimal.valueOf(b.getZbgm())).doubleValue());
                            a.setStgm(BigDecimal.valueOf(a.getStgm()).add(BigDecimal.valueOf(b.getStgm())).doubleValue());
                        }
                        return a;
                    });
                    String lsh = temp.stream().map(ZbczmxSyncParam::getLsh).min(Comparator.comparing(Long::valueOf)).get();
                    reduce.setLsh(lsh);
                    zbczmxSyncParams.add(reduce);
                }
                ggDataParam.setMxData(zbczmxSyncParams);
            }
            ggData.add(ggDataParam);
        });
        zbgxSyncParam.setGgData(ggData);
        log.debug(xmid + "\uff1a5.2.5. \u5efa\u8bbe\u9879\u76ee\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u6302\u94a9\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)zbgxSyncParam));
        JSONObject result = this.createHttp((JSONObject)JSON.toJSON((Object)zbgxSyncParam), "/index/syncZbgx");
        if (10000 == result.getInteger("code")) {
            mxDatas.forEach(czmx -> {
                czmx.setSyncFlag("2");
                czmx.setSyncTime(new Date());
            });
            this.zbkOperateDetailRepository.saveAll(mxDatas);
        } else {
            mxDatas.forEach(czmx -> czmx.setSyncFlag("0"));
            this.zbkOperateDetailRepository.saveAll(mxDatas);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject cxggZbgx(String xmid) {
        if (StringUtils.isEmpty((CharSequence)xmid)) {
            throw new IllegalArgumentException("\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZgckXmxx zgckXmxx = (ZgckXmxx)this.zgckXmxxService.findById(xmid);
        if (Objects.isNull(zgckXmxx)) {
            return null;
        }
        if (this.isNonSync(zgckXmxx.getCklx())) {
            return null;
        }
        List<ZBKOperateDetail> ckMxDatas = this.zbkOperateDetailRepository.findByLsh(zgckXmxx.getCkLsh());
        List reduceMxDatas = ckMxDatas.stream().peek(item -> item.setZblx(this.getBjZblx(item.getZblx()))).collect(Collectors.toList());
        ZbgxCxggParam cxggParam = new ZbgxCxggParam();
        cxggParam.setBcgdqrdbh(zgckXmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""));
        List<String> gllshs = ckMxDatas.stream().map(ZBKOperateDetail::getLsh_2).collect(Collectors.toList());
        List<ZBKOperateDetail> rkczmxDatas = this.zbkOperateDetailRepository.findByGllshInAndSyncFlag(gllshs, "0");
        rkczmxDatas.forEach(czmx -> czmx.setSyncFlag("1"));
        this.zbkOperateDetailRepository.saveAll(rkczmxDatas);
        ArrayList<ZbczmxSyncParam> mxDatas = new ArrayList<ZbczmxSyncParam>();
        Map<String, List<ZbczmxSyncParam>> rkMxDataByXzq = rkczmxDatas.stream().map(item -> {
            ZbczmxSyncParam czmxSyncParam = new ZbczmxSyncParam();
            czmxSyncParam.setLsh(item.getLsh_2());
            czmxSyncParam.setCzlx(item.getCzlx());
            czmxSyncParam.setCbzbxzqdm(item.getZbxzqdm());
            czmxSyncParam.setCzxzqdm(item.getCzxzqdm());
            czmxSyncParam.setZblx(this.getBjZblx(item.getZblx()));
            czmxSyncParam.setZbgm(item.getGdmj());
            czmxSyncParam.setStgm(item.getStmj());
            czmxSyncParam.setZy("\u64a4\u9500\u6302\u94a9");
            czmxSyncParam.setCzrq(item.getDate());
            czmxSyncParam.setCzr(item.getUsername());
            return czmxSyncParam;
        }).collect(Collectors.groupingBy(ZbczmxSyncParam::getCbzbxzqdm));
        rkMxDataByXzq.forEach((xzqdm, mxs) -> {
            Map<String, List<ZbczmxSyncParam>> mergeZbczmx = mxs.stream().collect(Collectors.groupingBy(ZbczmxSyncParam::getZblx));
            for (String zblx : mergeZbczmx.keySet()) {
                List<ZbczmxSyncParam> temp = mergeZbczmx.get(zblx);
                ZbczmxSyncParam reduce = temp.stream().reduce(null, (a, b) -> {
                    if (Objects.isNull(a)) {
                        a = new ZbczmxSyncParam();
                        BeanUtil.copyProperties((Object)b, (Object)a, (String[])new String[0]);
                    } else {
                        a.setZbgm(BigDecimal.valueOf(a.getZbgm()).add(BigDecimal.valueOf(b.getZbgm())).doubleValue());
                        a.setStgm(BigDecimal.valueOf(a.getStgm()).add(BigDecimal.valueOf(b.getStgm())).doubleValue());
                    }
                    return a;
                });
                String lsh = temp.stream().map(ZbczmxSyncParam::getLsh).min(Comparator.comparing(Long::valueOf)).get();
                reduce.setLsh(lsh);
                String cxlsh = reduceMxDatas.stream().filter(item -> xzqdm.equals(item.getZbxzqdm())).filter(item -> zblx.equals(item.getZblx())).map(ZBKOperateDetail::getLsh_2).min(Comparator.comparing(Long::valueOf)).get();
                reduce.setCxlsh(cxlsh);
                mxDatas.add(reduce);
            }
        });
        cxggParam.setMxData(mxDatas);
        log.debug(xmid + "\uff1a5.2.6. \u5efa\u8bbe\u9879\u76ee\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u89e3\u6302\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)cxggParam));
        JSONObject result = this.createHttp((JSONObject)JSON.toJSON((Object)cxggParam), "/index/cxggZbgx");
        if (10000 == result.getInteger("code")) {
            rkczmxDatas.forEach(czmx -> {
                czmx.setSyncFlag("2");
                czmx.setSyncTime(new Date());
            });
            this.zbkOperateDetailRepository.saveAll(rkczmxDatas);
        } else {
            rkczmxDatas.forEach(czmx -> czmx.setSyncFlag("0"));
            this.zbkOperateDetailRepository.saveAll(rkczmxDatas);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void hxZbgx(String xmid) {
        List<Object> zgckXmxxes = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)xmid)) {
            zgckXmxxes = this.zgckXmxxService.findByFilter("Q_f_processstate_S_EQ=p51;Q_f_verification_N_EQ=0;Q_f_unhook_N_EQ=0");
        } else {
            ZgckXmxx zgckXmxx = (ZgckXmxx)this.zgckXmxxService.findById(xmid);
            zgckXmxxes.add(zgckXmxx);
        }
        zgckXmxxes = zgckXmxxes.stream().filter(item -> !this.isNonSync(item.getCklx())).collect(Collectors.toList());
        for (ZgckXmxx zgckXmxx : zgckXmxxes) {
            JSONObject data;
            JSONObject param = new JSONObject();
            if (StringUtils.isEmpty((CharSequence)zgckXmxx.getBcgdxxqrdh())) continue;
            param.put("bcgdqrdbh", (Object)zgckXmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""));
            JSONObject result = this.createHttp(param, "/index/hxZbgx");
            if (result.getInteger("code") != 10000 || !"\u662f".equals((data = result.getJSONObject("data")).getString("hxbs"))) continue;
            zgckXmxx.setVerification(1);
            zgckXmxx.setVerificationTime(data.getString("hxsj"));
            zgckXmxx.setApprovalOffice(data.getString("pzjg"));
            zgckXmxx.setApprovalTime(data.getString("jsxm_pzsj"));
            zgckXmxx.setDzjgh(data.getString("jsxmbh"));
            this.zgckXmxxService.saveOrUpdate(zgckXmxx, null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject getAllzb(String xzqdm, String zbnd) {
        JSONObject paramJson = new JSONObject();
        if (StringUtils.isBlank((CharSequence)zbnd)) {
            zbnd = String.valueOf(LocalDate.now().getYear());
        }
        paramJson.put("xzqdm", (Object)xzqdm);
        paramJson.put("zbnd", (Object)zbnd);
        JSONObject info = this.createHttp(paramJson, "/index/getAllzb");
        if (info.getInteger("code") == 10000) {
            ZBKBaseDetail zbkBaseDetail = (ZBKBaseDetail)info.getJSONObject("data").toJavaObject(ZBKBaseDetail.class);
            zbkBaseDetail.setId(UUID.randomUUID().toString());
            zbkBaseDetail.setUpdatetime(new Date());
            this.zbkBaseDetailRepository.save(zbkBaseDetail);
        }
        return info;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject getAllzbczmx(String xzqdm, String zbnd) {
        JSONObject result;
        if (StringUtils.isBlank((CharSequence)zbnd)) {
            zbnd = DateUtil.format((Date)new Date(), (String)"yyyy");
        }
        Date date = this.zbczmxSyncRepository.queryLastSyncTime();
        JSONObject paramJson = new JSONObject();
        paramJson.put("xzqdm", (Object)xzqdm);
        paramJson.put("zbnd", (Object)zbnd);
        if (date != null) {
            paramJson.put("startTime", (Object)DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.isNull(result = this.createHttp(paramJson, "/index/getAllzbczmx")) || result.getInteger("code") != 10000) {
            return result;
        }
        JSONArray data = result.getJSONArray("data");
        Date now = new Date();
        List detailList = data.stream().map(item -> {
            JSONObject mxData = (JSONObject)item;
            return (ZbczmxSyncDetail)mxData.toJavaObject(ZbczmxSyncDetail.class);
        }).peek(item -> {
            item.setId(UUID.randomUUID().toString().replace("-", ""));
            item.setCzzt(0);
            item.setSyncTime(now);
        }).sorted(Comparator.comparing(ZbczmxSyncDetail::getCzrq)).collect(Collectors.toList());
        this.zbczmxSyncRepository.saveAll(detailList);
        return result;
    }

    private void zbkBjDjCxMxSync(ZbczmxSyncDetail czmx) {
        List<ZBKOperateDetail> djOperates = this.zbkOperateDetailRepository.findByGllsh(czmx.getGllsh());
        List djlsh = djOperates.stream().map(ZBKOperateDetail::getLsh).collect(Collectors.toList());
        List zbdjs = this.zbdjService.findByFilter("Q_f_djlsh_S_EQ=" + djlsh);
        for (Zbdj zbdj : zbdjs) {
            this.zbkFreezeHandler.revert(zbdj, null);
            List<ZBKOperateDetail> zbkCzmxs = this.zbkOperateDetailRepository.findByLsh(zbdj.getJdlsh());
            zbkCzmxs.forEach(item -> item.setGllsh(czmx.getLsh()));
            this.zbkOperateDetailRepository.saveAll(zbkCzmxs);
        }
    }

    private void zbkBjDjMxSync(ZbczmxSyncDetail czmx, ZBKInputDetail rkzb) {
        Zbdj zbdj = new Zbdj();
        zbdj.setZBXzqmc(czmx.getCbzbxzqmc());
        zbdj.setZBXzqdm(czmx.getCbzbxzqdm());
        zbdj.setDjjb("1");
        zbdj.setDjnf(DateUtil.format((Date)czmx.getCzrq(), (String)"yyyy"));
        zbdj.setZbgm(czmx.getZbgm());
        zbdj.setStgm(czmx.getStgm());
        zbdj.setBz(czmx.getZy());
        zbdj.setUserName(czmx.getCzr());
        zbdj.setCreateDate(DateUtil.format((Date)czmx.getCzrq(), (String)"yyyy-MM-dd HH:mm:ss"));
        zbdj.setState("1");
        zbdj.setUpdateDate(DateUtil.format((Date)czmx.getCzrq(), (String)"yyyy-MM-dd HH:mm:ss"));
        zbdj.setXmbh(this.baseSidService.generateLsh(czmx.getCbzbxzqdm(), EnumLshType.ZBDJ));
        zbdj.setXzqdm(czmx.getCzxzqdm());
        zbdj.setXzqmc(czmx.getCzxzqmc());
        zbdj.setZblx("02".equals(czmx.getZblx()) ? EnumZBKType.YCBKJZZB.toValue() : czmx.getZblx());
        zbdj.setDjlx("1");
        zbdj.setLscn(0.0);
        this.zbdjService.saveOrUpdate(zbdj, null);
        ZbdjMx zbdjMx = new ZbdjMx();
        zbdjMx.setId(UUID.randomUUID().toString().replace("-", ""));
        zbdjMx.setXmid(zbdj.getXmid());
        zbdjMx.setXmmc(rkzb.getXmmc());
        zbdjMx.setXmbh(rkzb.getXmbh());
        zbdjMx.setDjzbgm(czmx.getZbgm());
        zbdjMx.setDjstgm(czmx.getStgm());
        zbdjMx.setXmzbgm(rkzb.getGdmj());
        zbdjMx.setXmstgm(rkzb.getStmj());
        zbdjMx.setXzqdm(rkzb.getZbxzqdm());
        zbdjMx.setXzqmc(rkzb.getZbxzqmc());
        this.zbdjMxRepository.save(zbdjMx);
        SysUser sysUser = this.getTempSysUser(czmx);
        this.zbkFreezeHandler.freeze(zbdj, Lists.newArrayList((Object[])new ZbdjMx[]{zbdjMx}), sysUser);
        List<ZBKOperateDetail> zbkCzmxs = this.zbkOperateDetailRepository.findByLsh(zbdj.getDjlsh());
        zbkCzmxs.forEach(item -> item.setGllsh(czmx.getLsh()));
        this.zbkOperateDetailRepository.saveAll(zbkCzmxs);
    }

    private void zbkBjHjCxtMxSync(ZbczmxSyncDetail czmx) {
        List<ZBKOperateDetail> hjCzmxs = this.zbkOperateDetailRepository.findByGllsh(czmx.getGllsh());
        List hjLshs = hjCzmxs.stream().map(ZBKOperateDetail::getLsh).collect(Collectors.toList());
        List hjCkmxs = hjLshs.stream().map(lsh -> this.zbkOutputDetailService.findListBySid((String)lsh)).flatMap(Collection::stream).collect(Collectors.toList());
        List hjXmids = hjCkmxs.stream().map(ZBKOutputDetail::getXmbh).collect(Collectors.toList());
        List zbhjs = this.zbhjService.findByFilter("Q_f_id_S_IN=" + hjXmids);
        for (Zbhj zbhj : zbhjs) {
            this.zbkSubtractionHandler.revert(zbhj, null);
            String hjcxLsh = "\u5f85\u4ea7\u54c1\u4fee\u6539";
            List<ZBKOperateDetail> hjcxMxData = this.zbkOperateDetailRepository.findByLsh(hjcxLsh);
            hjcxMxData.forEach(item -> item.setGllsh(czmx.getLsh()));
            this.zbkOperateDetailRepository.saveAll(hjcxMxData);
        }
    }

    private void zbkBjHjMxSync(ZbczmxSyncDetail czmx, ZBKInputDetail rkzb) {
        String czrq = DateUtil.format((Date)czmx.getCzrq(), (String)"yyyy-MM-dd HH:mm:ss");
        Zbhj zbhj = new Zbhj();
        zbhj.setZbxzqmc(czmx.getCbzbxzqmc());
        zbhj.setZbxzqdm(czmx.getCbzbxzqdm());
        zbhj.setCzlx("03");
        zbhj.setCklx("");
        zbhj.setZbgm(czmx.getZbgm());
        zbhj.setStgm(czmx.getStgm());
        zbhj.setLscn(0.0);
        zbhj.setBz(czmx.getZy());
        zbhj.setUserName(czmx.getCzr());
        zbhj.setCreateDate(czrq);
        zbhj.setProcessId(czmx.getLsh());
        zbhj.setProcessStateStr("\u5df2\u5b8c\u6210\u6838\u51cf");
        zbhj.setProcessState("p51");
        zbhj.setProcessGroup("HJ");
        zbhj.setXmbh(this.baseSidService.generateLsh(czmx.getCbzbxzqdm(), EnumLshType.ZBHJ));
        zbhj.setXzqdm(czmx.getCzxzqdm());
        zbhj.setXzqmc(czmx.getCzxzqmc());
        zbhj.setUpdateDate(czrq);
        this.zbhjService.saveOrUpdate(zbhj, null);
        ZbhjMx zbhjMx = new ZbhjMx();
        zbhjMx.setId(UUID.randomUUID().toString().replace("-", ""));
        zbhjMx.setHjzbgm(czmx.getZbgm());
        zbhjMx.setHjstgm(czmx.getStgm());
        zbhjMx.setRkzbgm(0.0);
        zbhjMx.setRkstgm(0.0);
        zbhjMx.setXmid(zbhj.getXmid());
        zbhjMx.setZbid(rkzb.getId());
        this.zbhjMxRepository.save(zbhjMx);
        SysUser sysUser = this.getTempSysUser(czmx);
        this.zbkSubtractionHandler.subtraction(Lists.newArrayList((Object[])new ZbhjMx[]{zbhjMx}), zbhj, sysUser);
        String hjlsh = "\u5f85\u4ea7\u54c1\u5b8c\u5584";
        List<ZBKOperateDetail> zbkCzmxs = this.zbkOperateDetailRepository.findByLsh(hjlsh);
        zbkCzmxs.forEach(item -> item.setGllsh(czmx.getLsh()));
        this.zbkOperateDetailRepository.saveAll(zbkCzmxs);
    }

    private SysUser getTempSysUser(ZbczmxSyncDetail czmx) {
        SysUser sysUser = new SysUser();
        sysUser.setId("");
        sysUser.setUsername(czmx.getCzr());
        sysUser.setXzqdm(czmx.getCzxzqdm());
        sysUser.setFullXzqmc(czmx.getCzxzqmc());
        return sysUser;
    }

    @Override
    public JSONObject updateIndicatorIssuance(String xzqdm) {
        JSONObject param = new JSONObject();
        param.put("xzqdm", (Object)xzqdm);
        return this.createHttp(param, "/index/updateIndicatorIssuance");
    }

    @Override
    public JSONObject getHistoryDetails(String xzqdm) {
        JSONObject param = new JSONObject();
        param.put("xzqdm", (Object)xzqdm);
        return this.createHttp(param, "/index/getHistoryDetails");
    }

    @Override
    public JSONObject getCarryoverIndex(String xzqdm) {
        JSONObject param = new JSONObject();
        param.put("xzqdm", (Object)xzqdm);
        return this.createHttp(param, "/index/getCarryoverIndex");
    }

    private void inputBjZbkOld() {
        List<Map<String, Object>> latestZBKData = this.zbkBaseDetailRepository.findLatestZBKData();
        for (Map<String, Object> zbkBaseDetail : latestZBKData) {
            String xzqdm = zbkBaseDetail.get("f_xzqdm").toString();
            String xzqmc = this.getFullXzqmc(xzqdm);
            ArrayList<ZBKInputDTO> inputDTOS = new ArrayList<ZBKInputDTO>();
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            zbkInputDetail.setId(UUID.randomUUID().toString());
            zbkInputDetail.setZbxzqdm(xzqdm);
            zbkInputDetail.setZbxzqmc(xzqmc);
            zbkInputDetail.setCzxzqdm(xzqdm);
            zbkInputDetail.setCzxzqmc(xzqmc);
            zbkInputDetail.setCnzb(0.0);
            zbkInputDetail.setGddb(0.0);
            zbkInputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
            zbkInputDetail.setXmbh(this.baseSidService.generateLsh(xzqdm, EnumLshType.BCGDYS_Q));
            zbkInputDetail.setXmmc("\u90e8\u7ed3\u8f6c\u6307\u6807\u5165\u5e93");
            zbkInputDetail.setDkbh("");
            zbkInputDetail.setDkmc("");
            zbkInputDetail.setDkxzqdm(xzqdm);
            zbkInputDetail.setDkxzqmc(xzqmc);
            zbkInputDetail.setUserid("");
            zbkInputDetail.setUsername("");
            zbkInputDetail.setRklx(EnumZBKInputMethod.BJZZBRK.toValue());
            double ycbkslzb = Double.parseDouble(zbkBaseDetail.get("f_ycbkslzb").toString());
            double ycbkstzb = Double.parseDouble(zbkBaseDetail.get("f_ycbkstzb").toString());
            if (!(ycbkslzb <= 0.0) || !(ycbkstzb <= 0.0)) {
                ZBKInputDetail ycbkInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)ycbkInputDetail, (String[])new String[0]);
                ycbkInputDetail.setGdmj(ycbkslzb < 0.0 ? 0.0 : ycbkslzb);
                ycbkInputDetail.setStmj(ycbkstzb < 0.0 ? 0.0 : ycbkstzb);
                ycbkInputDetail.setZblx(EnumZBKType.YCBKJZZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(ycbkInputDetail);
                inputDTOS.add(inputDTO);
            }
            double ygjtcslzb = Double.parseDouble(zbkBaseDetail.get("f_ygjtcslzb").toString());
            double ygjtcstzb = Double.parseDouble(zbkBaseDetail.get("f_ygjtcstzb").toString());
            if (!(ygjtcslzb <= 0.0) || !(ygjtcstzb <= 0.0)) {
                ZBKInputDetail ygjtcInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)ygjtcInputDetail, (String[])new String[0]);
                ygjtcInputDetail.setGdmj(ygjtcslzb < 0.0 ? 0.0 : ygjtcslzb);
                ygjtcInputDetail.setStmj(ygjtcstzb < 0.0 ? 0.0 : ygjtcstzb);
                ygjtcInputDetail.setZblx(EnumZBKType.YGJTCZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(ygjtcInputDetail);
                inputDTOS.add(inputDTO);
            }
            double cnslzb = Double.parseDouble(zbkBaseDetail.get("f_cnslzb").toString());
            double cnstzb = Double.parseDouble(zbkBaseDetail.get("f_cnstzb").toString());
            if (!(cnslzb <= 0.0) || !(cnstzb <= 0.0)) {
                ZBKInputDetail cnInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)cnInputDetail, (String[])new String[0]);
                cnInputDetail.setGdmj(cnslzb < 0.0 ? 0.0 : cnslzb);
                cnInputDetail.setStmj(cnstzb < 0.0 ? 0.0 : cnstzb);
                cnInputDetail.setZblx(EnumZBKType.CNZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(cnInputDetail);
                inputDTOS.add(inputDTO);
            }
            if (inputDTOS.size() <= 0) continue;
            this.zbkManagerService.input(inputDTOS);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void inputBjZbk() {
        String queryJzzbSql = "select base.* from tb_zbph_sync_jzzb base inner join (select f_xzqdm, max(f_jzsd) as f_jzsd from tb_zbph_sync_jzzb group by f_xzqdm) as t on base.f_xzqdm = t.f_xzqdm and base.f_jzsd = t.f_jzsd";
        List latestZBKData = this.jdbcTemplate.queryForList(queryJzzbSql);
        for (Map zbkBaseDetail : latestZBKData) {
            String xzqdm = zbkBaseDetail.get("f_xzqdm").toString();
            if (xzqdm.endsWith("0000") || xzqdm.endsWith("00")) continue;
            String xzqmc = this.getFullXzqmc(xzqdm);
            ArrayList<ZBKInputDTO> inputDTOS = new ArrayList<ZBKInputDTO>();
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            zbkInputDetail.setId(UUID.randomUUID().toString());
            zbkInputDetail.setZbxzqdm(xzqdm);
            zbkInputDetail.setZbxzqmc(xzqmc);
            zbkInputDetail.setCzxzqdm(xzqdm);
            zbkInputDetail.setCzxzqmc(xzqmc);
            zbkInputDetail.setCnzb(0.0);
            zbkInputDetail.setGddb(0.0);
            zbkInputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
            zbkInputDetail.setXmbh(this.baseSidService.generateLsh(xzqdm, EnumLshType.BCGDYS_Q));
            zbkInputDetail.setXmmc("\u90e8\u7ed3\u8f6c\u6307\u6807\u5165\u5e93");
            zbkInputDetail.setDkbh("");
            zbkInputDetail.setDkmc("");
            zbkInputDetail.setDkxzqdm(xzqdm);
            zbkInputDetail.setDkxzqmc(xzqmc);
            zbkInputDetail.setUserid("");
            zbkInputDetail.setUsername("");
            zbkInputDetail.setRklx(EnumZBKInputMethod.BJZZBRK.toValue());
            double ycbkslzb = Double.parseDouble(zbkBaseDetail.get("f_ycbkslzb").toString());
            double ycbkstzb = Double.parseDouble(zbkBaseDetail.get("f_ycbkstzb").toString());
            if (!(ycbkslzb <= 0.0) || !(ycbkstzb <= 0.0)) {
                ZBKInputDetail ycbkInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)ycbkInputDetail, (String[])new String[0]);
                ycbkInputDetail.setGdmj(ycbkslzb < 0.0 ? 0.0 : ycbkslzb);
                ycbkInputDetail.setStmj(ycbkstzb < 0.0 ? 0.0 : ycbkstzb);
                ycbkInputDetail.setZblx(EnumZBKType.YCBKJZZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(ycbkInputDetail);
                inputDTOS.add(inputDTO);
            }
            double ygjtcslzb = Double.parseDouble(zbkBaseDetail.get("f_ygjtcslzb").toString());
            double ygjtcstzb = Double.parseDouble(zbkBaseDetail.get("f_ygjtcstzb").toString());
            if (!(ygjtcslzb <= 0.0) || !(ygjtcstzb <= 0.0)) {
                ZBKInputDetail ygjtcInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)ygjtcInputDetail, (String[])new String[0]);
                ygjtcInputDetail.setGdmj(ygjtcslzb < 0.0 ? 0.0 : ygjtcslzb);
                ygjtcInputDetail.setStmj(ygjtcstzb < 0.0 ? 0.0 : ygjtcstzb);
                ygjtcInputDetail.setZblx(EnumZBKType.YGJTCZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(ygjtcInputDetail);
                inputDTOS.add(inputDTO);
            }
            double cnslzb = Double.parseDouble(zbkBaseDetail.get("f_cnslzb").toString());
            double cnstzb = Double.parseDouble(zbkBaseDetail.get("f_cnstzb").toString());
            if (!(cnslzb <= 0.0) || !(cnstzb <= 0.0)) {
                ZBKInputDetail cnInputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)cnInputDetail, (String[])new String[0]);
                cnInputDetail.setGdmj(cnslzb < 0.0 ? 0.0 : cnslzb);
                cnInputDetail.setStmj(cnstzb < 0.0 ? 0.0 : cnstzb);
                cnInputDetail.setZblx(EnumZBKType.CNZB.toValue());
                ZBKInputDTO inputDTO = new ZBKInputDTO();
                inputDTO.setZbkInputDetail(cnInputDetail);
                inputDTOS.add(inputDTO);
            }
            if (inputDTOS.size() <= 0) continue;
            this.zbkManagerService.input(inputDTOS);
        }
    }

    private String getFullXzqmc(String xzqdm) {
        log.debug("\u83b7\u53d6\u5f53\u524d\u884c\u653f\u533a\u4ee3\u7801\uff0cxzqdm:{}", (Object)xzqdm);
        ArrayList<String> regions = new ArrayList<String>();
        String xzqmc = null;
        if (xzqdm.endsWith("0000")) {
            Region shengRegion = this.regionService.queryRegionByCode(xzqdm, null);
            if (Objects.nonNull(shengRegion)) {
                regions.add(shengRegion.getName());
            }
        } else if (xzqdm.endsWith("00")) {
            Region dsjRegion;
            Region shengRegion = this.regionService.queryRegionByCode(xzqdm.substring(0, 2) + "0000", null);
            if (Objects.nonNull(shengRegion)) {
                regions.add(shengRegion.getName());
            }
            if (Objects.nonNull(dsjRegion = this.regionService.queryRegionByCode(xzqdm.substring(0, 4) + "00", null))) {
                regions.add(dsjRegion.getName());
            }
        } else {
            Region xianRegion;
            Region dsjRegion;
            Region shengRegion = this.regionService.queryRegionByCode(xzqdm.substring(0, 2) + "0000", null);
            if (Objects.nonNull(shengRegion)) {
                regions.add(shengRegion.getName());
            }
            if (Objects.nonNull(dsjRegion = this.regionService.queryRegionByCode(xzqdm.substring(0, 4) + "00", null))) {
                regions.add(dsjRegion.getName());
            }
            if (Objects.nonNull(xianRegion = this.regionService.queryRegionByCode(xzqdm, null))) {
                regions.add(xianRegion.getName());
            }
        }
        xzqmc = String.join((CharSequence)"\u00b7", regions);
        return xzqmc;
    }
}

