/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zgck.impl;

import com.geoway.onemap.zbph.dao.fnzygd.ZgckBcgdDkDetailRepository;
import com.geoway.onemap.zbph.domain.base.AbstractXmxx;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckBcgdDkDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.service.base.impl.BaseXmglxxServiceImpl;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zgck.ZgckBcgdDkDetailService;
import com.geoway.onemap.zbph.service.zgck.impl.ZgckXmxxServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZgckBcgdDkDetailServiceImpl
extends BaseXmglxxServiceImpl<ZgckBcgdDkDetail>
implements ZgckBcgdDkDetailService {
    @Autowired
    private ZgckBcgdDkDetailRepository bcgdDetailRepository;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private ZgckXmxxServiceImpl zgckXmxxService;

    @Override
    public List<ZgckBcgdDkDetail> findByzbId(String zbid) {
        List<ZgckBcgdDkDetail> details = this.bcgdDetailRepository.findByZbid(zbid);
        List zgckXmxxes = this.zgckXmxxService.findByIds(details.stream().map(m -> m.getXmid()).collect(Collectors.toList()));
        List<ZBKDKDetail> zbkdkDetails = this.zbkdkDetailService.findByIds(details.stream().map(m -> m.getZbid()).collect(Collectors.toList()));
        Map map = zgckXmxxes.stream().collect(Collectors.toMap(AbstractXmxx::getXmid, Function.identity()));
        Map zbkDkDetailMap = zbkdkDetails.stream().collect(Collectors.toMap(ZBKDKDetail::getId, Function.identity()));
        details.forEach(f -> {
            f.setZbkDetail((ZBKDKDetail)zbkDkDetailMap.get(f.getZbid()));
            f.setXmxx((ZgckXmxx)map.get(f.getXmid()));
        });
        return details;
    }

    @Override
    public List<String> findXmIdByXmbh(String xmbh) {
        List<ZBKDKDetail> listByXmbh = this.zbkdkDetailService.findListByXmbh(xmbh);
        List<String> zbids = listByXmbh.stream().map(m -> m.getId()).collect(Collectors.toList());
        List<ZgckBcgdDkDetail> details = this.bcgdDetailRepository.findByZbids(zbids);
        return details.stream().map(m -> m.getXmid()).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, Integer> countByXmbhs(List<String> xmbhs) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList record = new ArrayList();
        List<ZBKDKDetail> list = this.zbkdkDetailService.findListByXmbhs(xmbhs);
        Map<String, String> map = list.stream().collect(Collectors.toMap(ZBKDKDetail::getId, m -> m.getXmbh()));
        List<ZgckBcgdDkDetail> dkDetails = this.bcgdDetailRepository.findByZbids(map.keySet().stream().collect(Collectors.toList()));
        dkDetails.forEach(f -> {
            if (!record.contains(f.getXmid())) {
                String xmbh;
                Integer count = (Integer)result.get(xmbh = (String)map.get(f.getZbid()));
                result.put(xmbh, count == null ? 1 : count + 1);
                record.add(f.getXmid());
            }
        });
        return result;
    }

    @Override
    public void updateBatch(List<ZgckBcgdDkDetail> bcgdDetails) {
        this.bcgdDetailRepository.saveAll(bcgdDetails);
    }

    @Override
    public List<ZgckBcgdDkDetail> findByXmid(String xmid) {
        List<ZgckBcgdDkDetail> list = super.findByXmid(xmid);
        List<ZBKDKDetail> zbkdkDetails = this.zbkdkDetailService.findByIds(list.stream().map(m -> m.getZbid()).collect(Collectors.toList()));
        Map zbkDkDetailMap = zbkdkDetails.stream().collect(Collectors.toMap(ZBKDKDetail::getId, Function.identity()));
        list.forEach(f -> f.setZbkDetail((ZBKDKDetail)zbkDkDetailMap.get(f.getZbid())));
        return list;
    }
}

