/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zgck.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.zbph.constant.zgck.EnumHXState;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.service.base.VerifyTaskManageService;
import com.geoway.onemap.zbph.service.base.impl.AbstractProcessXmxxServiceImpl;
import com.geoway.onemap.zbph.service.zgck.ZgckXmxxService;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.geoway.zhgd.domain.VerifyTask;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZgckXmxxServiceImpl
extends AbstractProcessXmxxServiceImpl<ZgckXmxx>
implements ZgckXmxxService,
VerifyTaskManageService {
    @Autowired
    private GeoserverUtil geoserverUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchFinish(String[] xmids) {
        List xmxxs = this.findByIds(Arrays.stream(xmids).collect(Collectors.toList()));
        for (ZgckXmxx xmxx : xmxxs) {
            xmxx.setHxBs(UUID.randomUUID().toString());
            xmxx.setHxState(EnumHXState.HX);
            xmxx.setHxDate(DateUtil.now());
        }
        this.batchSaveOrUpdate(xmxxs, null);
    }

    @Override
    public String getTableName() {
        return "tb_zbph_zgck_xmxx";
    }

    @Override
    public void verifyManage(VerifyTask verifyTask) {
        JSONArray array = this.geoserverUtil.httpFindSubTask(verifyTask.getTaskId());
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            Integer status = obj.getInteger("status");
            if (status != 500) continue;
            verifyTask.setStatus(Integer.valueOf(500));
            verifyTask.setMessage("\u5206\u6790\u9879\u3010" + obj.getString("serviceName") + "\u3011\u5206\u6790\u5931\u8d25\uff0c" + obj.getString("msg"));
            break;
        }
    }
}

