/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BatchRepository {
    private static final Logger log = LoggerFactory.getLogger(BatchRepository.class);
    @PersistenceContext
    protected EntityManager entityManager;
    @Value(value="${spring.jpa.properties.hibernate.jdbc.batch_size:}")
    private Integer batchSize;
    @Value(value="${spring.jpa.properties.hibernate.jdbc.batch_versioned_data:}")
    private String batchVersionedData;
    @Value(value="${spring.jpa.properties.hibernate.order_inserts:}")
    private String orderInserts;
    @Value(value="${spring.jpa.properties.hibernate.order_updates:}")
    private String orderUpdates;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PostConstruct
    public void init() {
        log.info("BaseDao\u521d\u59cb\u5316\u52a0\u8f7d\u3002batchSize\uff1a{}\uff0cbatchVersionedData\uff1a{}\uff0corderInserts\uff1a{}\uff0corderUpdates\uff1a{}", new Object[]{this.batchSize, this.batchVersionedData, this.orderInserts, this.orderUpdates});
        System.out.println(String.format("BaseDao\u521d\u59cb\u5316\u52a0\u8f7d\u3002batchSize\uff1a%s\uff0cbatchVersionedData\uff1a%s\uff0corderInserts\uff1a%s\uff0corderUpdates\uff1a%s", this.batchSize, this.batchVersionedData, this.orderInserts, this.orderUpdates));
    }

    @Transactional(rollbackFor={Exception.class})
    public <T> void batchInsert(List<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (T entity : entities) {
            this.entityManager.persist(entity);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public <T> void batchUpdate(List<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Session session = (Session)this.entityManager.unwrap(Session.class);
        session.setJdbcBatchSize(this.batchSize);
        for (T t : entities) {
            session.update(t);
        }
    }
}

